#!/bin/sh
# This script builds and minifies CSS and JS that we bundle to HTML report and guide.
set -e 

if ! type yuicompressor > /dev/null; then
	echo "Please install yuicompressor utility"
	exit 1
fi

ALL_CSS=`mktemp`
ALL_CSS_MIN=`mktemp`
ALL_JS=`mktemp`
ALL_JS_MIN=`mktemp`

echo "" > $ALL_CSS
cat xccdf-resources/jquery.treetable.css >> $ALL_CSS
cat xccdf-resources/jquery.treetable.theme.css >> $ALL_CSS
cat xccdf-resources/openscap.css >> $ALL_CSS
yuicompressor --type css $ALL_CSS > $ALL_CSS_MIN
rm $ALL_CSS
echo "" > $ALL_JS
cat xccdf-resources/jquery.treetable.js >> $ALL_JS
cat xccdf-resources/bootstrap.min.js >> $ALL_JS
cat xccdf-resources/openscap.js >> $ALL_JS
yuicompressor --type js $ALL_JS > $ALL_JS_MIN
rm $ALL_JS

XCCDF_RESOURCES="xccdf-resources.xsl"

echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>" > $XCCDF_RESOURCES
echo "<!-- This file was autogenerated! See the xccdf-resources/ folder! -->" >> $XCCDF_RESOURCES

echo "<xsl:stylesheet version=\"1.1\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">" >> $XCCDF_RESOURCES
echo "<xsl:template name=\"css-sources\"><![CDATA[" >> $XCCDF_RESOURCES
# bootstrap.min.css can't be minified further without breaking behavior
cat xccdf-resources/bootstrap.min.css >> $XCCDF_RESOURCES
cat $ALL_CSS_MIN >> $XCCDF_RESOURCES
echo "]]></xsl:template>" >> $XCCDF_RESOURCES
echo "<xsl:template name=\"js-sources\"><![CDATA[" >> $XCCDF_RESOURCES
# jquery.min.js can't be minified further without breaking behavior
cat xccdf-resources/jquery.min.js >> $XCCDF_RESOURCES
cat $ALL_JS_MIN >> $XCCDF_RESOURCES
echo "]]></xsl:template>" >> $XCCDF_RESOURCES

echo "</xsl:stylesheet>" >> $XCCDF_RESOURCES

rm $ALL_CSS_MIN
rm $ALL_JS_MIN
