CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;

CREATE TABLE capitals (
    id integer NOT NULL,
    name character varying(256),
    country_id integer,
    geom geometry(Point,4326)
);

CREATE TABLE countries (
    id integer NOT NULL,
    name character varying(256),
    geom geometry(MultiPolygon,4326)
);

--
-- Data for Name: countries; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY countries (id, name, geom) FROM stdin;
1	Antigua and Barbuda	0106000020E61000000200000001030000000100000004000000DC9AADBCE4D74EC0A4AEEFC3410631405825917D90F14EC0741EA33CF31A314078AB3C81B0E54EC0C474B0FECF293140DC9AADBCE4D74EC0A4AEEFC341063140010300000001000000040000004894128255DD4EC08C15E0BBCD9B3140A8CB290131ED4EC06CCDE50643953140B0B0E07EC0EF4EC0140C040132B431404894128255DD4EC08C15E0BBCD9B3140
2	Algeria	0106000020E6100000010000000103000000010000002D00000000CAE02879B50740FA298E03AF664240009AD024B12413408281204086724240402861A6ED4F1540563D997FF4514240A0AB1F9BE49719402A6211C30E8B4240004356B77A3E214022C022BF7E784240605FD042025E20402EE78BBD174342409018213CDA802040021E8A027D524140C04069A851F81D402E266F8099F14040301E8A027DB220405E70784144444040307156444D1C22403AD505BCCC0C40405083A279001323407C82A8FB003C3E40204B3B35979B22404CD367075C1F3E40201808026488234084035ABA826D3D4020809BC58BE523402C6211C30ED33B40001286014BBE2340CCC77C40A0833A40E0D58F4DF2CB22402C6E15C440273A40D0A9F23D2381244024E78BBD179B3840D051D66F261E2740F41A4982704D3840C0A44E4013F927409489CDC7B5853740603BA759A0CD1D40F4F7C43A55DA3440A021E4BCFF3F17402C6BD4433472334040D8D5E429FB104024809BC58B25334040D48041D2A70A405C3D997FF4F93240C05A99F04BDD094064C2137AFDD13340803D4162BBBBFC3FDC57C9C7EE4E34400048E17A14AEF23FD4CDFE40B9BD344000FC5580EFB6F23F1C6F0F42401A354080C87729753913C0AC01BC0512003940A008AA46AFA61AC064C1E10511213A406099B67F655521C02CD461855B4A3B4040941282555521C0B46BED7DAAAA3B402047C8409E5521C0AC68ACFD9DB53C40E0550DC2DC7E1CC03C6211C30EA33D40804C3107412716C054C554FA09E73D40E08B683BA6AE13C07CA2EBC20F823E4000DCF3FC69030DC07C00193A76F83E4080A339B2F28B0EC074A2EBC20FB23F4040508BC1C3D406C02E14E97E4E0B4040808B31B08EE3F2BF52499D80260E404000E49D43192AF0BF86457EFD104140400059FE7C5BB0FABFA65CA8FC6BA14040809F4D0E9FF4FBBF520ABABDA45F4140807C0A80F1AC01C0CEFD9C82FC8A4140006666666666EE3FFE264D83A239424000CAE02879B50740FA298E03AF664240
3	Azerbaijan	0106000020E6100000050000000103000000010000000700000000000050AA8A4640000000504FE2434000000050F5E84640000000505DC64340000000D0D0164740000000D0AA6B43400000005091804640000000104CB54340000000D01168464000000090BED04340000000D0B1634640000000D06ADA434000000050AA8A4640000000504FE2434001030000000100000004000000000000B0ABC1464000000070B94D4440000000303DC246400000007030554440000000D059C9464000000070F5504440000000B0ABC1464000000070B94D44400103000000010000000400000000000010659F4640000000700C7D444000000030559D4640000000300D7C4440000000B010994640000000F0B67F444000000010659F4640000000700C7D44400103000000010000000400000000000070CB854640000000D0838444400000007047814640000000103B844440000000702480464000000070608B444000000070CB854640000000D083844440010300000001000000160000000000001023494740000000909BEF4440000000D02AE24740000000901999444000000010BF4A484000000090FAEA44400000001097C3484000000090D5544440000000D0FF2F494000000050902144400000005078BE4840000000D04413444000000050B3714840000000D0A038434000000050AA02484000000010F36A4340000000900D2E4840000000D04EB143400000005003FD4740000000D00FDC4340000000102B4547400000005013704340000000104C454740000000903FC84340000000D043CC46400000009030FD4340000000903F004740000000D0DE1C444000000010B2934640000000D06B994440000000D0EF824640000000D005A644400000009017AB46400000001033BB444000000050AA4247400000001066864440000000D0D058474000000050F6A7444000000010E318474000000010C9D7444000000010D3394740000000D0D2F244400000001023494740000000909BEF4440
4	Albania	0106000020E6100000010000000103000000010000000F000000A80E80B8AB6F33408E0B0742B28244401073F4F8BD993340D27FD6FCF8E54440D06A813D265E334022ABCDFFABEC4440E0B5F63E55A533407EA52C431C4F4540A02E19C7481234405E7347FFCB474540185932C7F296344066FAEC80EBF0444058499D80267E3440D2B837BF61AA4440386BD44334D234402AF6D03E5674444078F12900C6FB3440FE84ECBC8D6D444060BEA08504AC34403A232E008D0C44401003B342910234405E7FD93D79D8434050BFD2F9F0DC3340CE031F8315054440C8548847E2493340FE1A49827035444078812040867A3340FAD5E3BED52C4440A80E80B8AB6F33408E0B0742B2824440
5	Armenia	0106000020E6100000010000000103000000040000000F00000000000010B2934640000000D06B994440000000903F004740000000D0DE1C4440000000D043CC46400000009030FD4340000000104C454740000000903FC84340000000102B4547400000005013704340000000D0D0164740000000D0AA6B434000000050F5E84640000000505DC6434000000050AA8A4640000000504FE24340000000D0B1634640000000D06ADA434000000090712C4640000000D00E034440000000D028D4454000000090E60D4440000000903FE0454000000050B85E444000000090FABA454000000090758E4440000000D0EF824640000000D005A6444000000010B2934640000000D06B994440040000000000007047814640000000103B84444000000070CB854640000000D083844440000000702480464000000070608B44400000007047814640000000103B84444004000000000000B010994640000000F0B67F444000000030559D4640000000300D7C444000000010659F4640000000700C7D4440000000B010994640000000F0B67F444004000000000000D059C9464000000070F5504440000000303DC246400000007030554440000000B0ABC1464000000070B94D4440000000D059C9464000000070F5504440
6	Angola	0106000020E61000000300000001030000000100000004000000000000406D802740000000005AC130C0000000C020632740000000401A8930C0000000C0CC8C27400000008002CE30C0000000406D802740000000005AC130C00103000000010000002300000000000040B8FE2B4000000080FA6417C0000000A06894304000000000749A17C00000002011F130400000008060CB1CC000000060C99F314000000080343220C0000000A0805F33400000008004FC1FC0000000A0F88933400000008088FC1BC00000002037A1344000000080D0A71BC0000000A0788C3440000000006C221DC00000002070C8354000000000951F1DC0000000E061CA354000000000A5CF22C0000000E0ED4F36400000008098BA24C0000000E0FE403640000000C0606B26C00000002078FC374000000000ADBD25C000000020430538400000008045032AC0000000E092FF35400000004022022AC0000000E00900364000000000F22B30C000000060E2793740000000C036A031C0000000A0E3483740000000C099A931C0000000A0AADA344000000040320432C00000002074EA324000000040C8D031C0000000209873324000000040CC6331C00000004087FC2B40000000C0876C31C00000004034522A4000000040E9F330C0000000C06C812740000000C03C4131C00000004044A4274000000040C88030C0000000C0259F27400000000072FC2FC0000000C078762740000000807EB12FC000000040FA04294000000040BED92AC0000000C0C2952B4000000080559527C0000000C0168C2B4000000000945E25C00000004009F8294000000000CD2C22C00000004064C82A400000000042C620C0000000C0707D284000000080686418C000000040965B2A4000000080E16C17C000000040B8FE2B4000000080FA6417C001030000000100000008000000000000C0822D2A400000008066A612C00000004090212940000000002B1A14C000000040A70D2940000000008CE516C0000000C0D96D284000000000001317C000000040610D2840000000005B0F14C000000040DF8E294000000080538E11C0000000C0CA2E2A40000000803F8812C0000000C0822D2A400000008066A612C0
7	American Samoa	0106000020E610000005000000010300000001000000040000000D5707405C5165C058EC2E5052982CC0149CFA40F25165C0F0D1FE0758932CC01272DEFF475165C01831CF4A5A912CC00D5707405C5165C058EC2E5052982CC0010300000001000000040000003359DC7F645465C070EA1F4432942CC0B4FB55806F5A65C0183410CB66A62CC0031BD7BFEB5165C000228AC91B882CC03359DC7F645465C070EA1F4432942CC001030000000100000004000000D0CDFE40392E65C068E28E37F9852CC03FDAFF006B3065C08050A4FB398D2CC0CEA96400283165C0400F27309D762CC0D0CDFE40392E65C068E28E37F9852CC001030000000100000004000000052159C0043465C0B8A9F23D23612CC04E2844C0A13465C078EE92382B5A2CC001FA7DFFE63365C0186DE34F54562CC0052159C0043465C0B8A9F23D23612CC001030000000100000004000000793C2D3FF03565C08853E57B46622CC0CEA623801B3665C03018EAB0C2552CC0B6EC10FF303565C0C88827BB99592CC0793C2D3FF03565C08853E57B46622CC0
8	Argentina	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
40	Central African Republic	0106000020E61000000100000001030000000100000024000000404415FE0C0F3340A8307DAF21282140386893C327FD3240D0C3094CA7ED21400809C380255F34408838BA4A77372240088E3D7B2EB73540B8716F7EC3942440B04D637B2DB83540383F37346547254020D28C45D3DD3640409622F94AD8254010904C874EAB374020FEF0F3DFBB234070A7CAF78C843740F0C3094CA76D2140C0DDAF027C333840C06E2EFEB65F21402094BF7B47313840407A19C5729B20408818213CDA40394030CCD1E3F7661F40A01A3048FA343940002CBB6070FD1D40A8E9B303AE673A40801B62BCE6951A40A021E4BCFF6F3A4080861DC6A44F184070A7CAF78C243B400060E97C7816174050A7CAF78C743B4040301004C810144090F4143944E43940700D36751EC514406834D6FECE8A3940803788D68A86154050BEA08504BC3840809AD024B1A41340683A58FFE7643840B08EC70C54761440D8420246976B3740105B99F04B5D1240D8B5F63E55E53640108B6D52D148134078C1E10511613640C0F5285C8F821040981B62BCE695344040713D0AD7A31140B0F5B704E06B3340A0F0D8CF62891440D84BC5C6BC8A3240C009DCBA9B571140A05F5B3FFD9F3240801B62BCE6D50B40888AE3C0AB79314080FE092E56B40D40007CB779E3A83040C005871744440C40100341800C3530404005871744C40140E0B837BF611A304060573F36C92F0740B085048C2E772D40F06F4221027E12404020990E9DD62C40A03465A71F24184080E200FA7DFF2E40E01DC3633F1B1E4088129F3BC1963240F08FDB2F9F142040404415FE0C0F3340A8307DAF21282140
129	Belgium	0106000020E610000001000000010300000001000000120000004083C0CAA1351140526A6803B0A14940603ACAC16C021140062159C004B04940C0A8C5E0612A1440021286014BBE494020D926158D651740D6DF844204944940A0CAA48636901640AEDDAF027C6B494080A260C6140C1840D69A9141EE604940008C14CAC29719407A7500C45D294940807FD8D2A38918405676FA415D104940804B55DAE21A1840D22AFA4333174940E05E0CE5443B1740CA707500C4C5484060704221027E134036E44A3D0BE64840004A9BAA7B541340A6E33103951549404048A5D8D19810406E2DCC423BFD4840605C8FC2F5A81040D20CE2033B24494040951282555504405E2B137EA98B49404096E99788F70A40FEB46E83DAAF4940205264ADA1F410408ED558C2DAAC49404083C0CAA1351140526A6803B0A14940
9	Australia	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
10	Bahrain	0106000020E610000006000000010300000001000000040000008C21E4BCFF6749405CD6A88768A43940ACA78FC01F6449409C93A641D1A83940DCA9F23D2369494034DB87BCE5A639408C21E4BCFF6749405CD6A88768A43940010300000001000000040000002C6552431B684940E4CDFE40B9AD3940FCDB65BFEE664940E431AEB838AE39400CBB9A3C65674940B4656B7D91B039402C6552431B684940E4CDFE40B9AD394001030000000100000004000000E4C1FA3F87614940141808026498394014DC65BFEE5E4940B477F17EDCAE3940CC7FD6FCF86549401C990F0874BA3940E4C1FA3F876149401418080264983940010300000001000000040000007C8120408662494094F1D3B837BF394064F833BC596149409C01BC0512C039400CD9243FE2614940A4ABAE4335C139407C8120408662494094F1D3B837BF394001030000000100000004000000ACA78FC01F4449406CBEA085043C3A406CE89FE062494940ACD1AB014ACF394044E78BBD173B49407CA52C431CF73940ACA78FC01F4449406CBEA085043C3A4001030000000100000004000000642B137EA953494044D367075C3F3A40ACB6D4415E4D49405CA7CAF78C443A40DCB2B5BE48504940643D997FF4493A40642B137EA953494044D367075C3F3A40
11	Barbados	0106000020E61000000100000001030000000100000004000000806F9A3E3BC44DC0285DC136E2192A402C05A4FD0FD24DC0F8921CB0ABA92A4078BA8102EFB64DC0D0BEB9BF7A542A40806F9A3E3BC44DC0285DC136E2192A40
12	Bermuda	0106000020E610000003000000010300000001000000040000006CF12900C63650C0662B137EA923404018BD5301F73750C0527FBDC282254040AA8905BEA23550C0924E417E362840406CF12900C63650C0662B137EA92340400103000000010000000400000044CBBA7F2C2950C0BAB6D4415E2D4040BE58DFC0E42B50C0DACDFE40B92D4040661B4641F02950C0AABC5642772F404044CBBA7F2C2950C0BAB6D4415E2D4040010300000001000000040000008269183E223250C0AEE67283A1224040E88A19E1ED3650C00E5A0F5F26224040681E87C1FC2A50C00ACADFBDA33040408269183E223250C0AEE67283A1224040
13	Bahamas	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
130	Hong Kong	0106000020E61000000400000001030000000100000004000000826F0C01C08F5C40D464FF3C0D3436402AF0879FFF875C40A4E9B303AE47364026081EDFDE8C5C40E4B837BF614A3640826F0C01C08F5C40D464FF3C0D343640010300000001000000040000002EF911BF62795C409CACE0B7213236408693A641D1745C40AC9BFD81723B3640AE83F57F0E835C4074C554FA095736402EF911BF62795C409CACE0B72132364001030000000100000004000000AE8636001B945C40B4F3A8F8BF5736407A78CF81E5925C404402D53F885836406ADCD440F3925C40E431AEB8385E3640AE8636001B945C40B4F3A8F8BF573640010300000001000000050000000EA27C410B8E5C40CCFACDC474793640C20D315EF3925C40EC9C2D20B4423640A2F7D41522825C40ECD9B3E056823640CA0862023F8E5C400C4BDBBAF08C36400EA27C410B8E5C40CCFACDC474793640
14	Bangladesh	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
15	Belize	0106000020E61000000600000001030000000100000004000000EA9925016AF355C024904C874E4B3140AEB321FFCCF455C0D46BED7DAA4A3140585BB1BFECF455C0A45FE97C78663140EA9925016AF355C024904C874E4B3140010300000001000000040000003CE0810184F455C0545260014C6D3140ACF204C24EFB55C0EC3FC1C58A4631407C9CF7FF71F455C02CD505BCCC8C31403CE0810184F455C0545260014C6D31400103000000010000000400000044B9347EE10256C094035ABA828D3140D6DF12807F0456C094FDD7B969A331406EDC627E6E0356C05CBFD2F9F09C314044B9347EE10256C094035ABA828D3140010300000001000000040000006EDFA3FE7A0856C06C34D6FECEAA314012AE0E80B80A56C03C7A19C572AB314000EB387EA80456C0C4F5B704E0BB31406EDFA3FE7A0856C06C34D6FECEAA314001030000000100000004000000EA66463F1AF955C09414AE47E10A32409838F240640056C054DB87BCE5E63140DAE5948098F655C0BC073E062B2A3240EA66463F1AF955C09414AE47E10A324001030000000100000009000000302C7FBE2D1856C0F4420246977B3240B6490C022B1356C0544A253CA17B324046BFB67EFA0456C00C8E3D7B2E373240C07FBA81021256C06CB950F9D7A23140D8D64FFF590D56C0849C69C2F6F730402A3201BF463A56C018C2FA3F87C92F40FED5E3BED54D56C088A0DE8C9AC72F40682409C2154956C0FC264D83A2D13140302C7FBE2D1856C0F4420246977B3240
16	Bosnia and Herzegovina	0106000020E6100000010000000103000000010000000F000000A899D2FA5BA6314056D40B3ECD714540E0E2A9471A943140D612F241CF7845408887A2409F243040D2C1FA3F87194640F0D03FC1C5922F40365FD04202964640287D5A457F403240D673D2FBC6914640B0073E062B0A334082AEEFC3416E4640E828EB37135F3340A674B0FECF714640E04BC5C6BC1A3340520438BD8B2D464000F4DF83D79E334022AE9CBD33064640D887F546AD3C33401E7B2FBE68014640D8D03FC1C58233405A40DAFF00D74540C807043A933A3340B2EC10FFB0C14540584CDE0033B332405A2E54FEB5A045409087A2409F743240FE9C82FC6C484540A899D2FA5BA6314056D40B3ECD714540
17	Bolivia	0106000020E61000000100000001030000000100000032000000A6AAD0402C4C50C044F3AB39401836C05A58703FE06F50C070022846961C36C0D4F126BF458E50C050D76839D0C735C0B2B0E07EC0CB50C0D033BDC458D236C05A85CD0017F850C0A8415F7AFBD336C054647440120C51C02CA5F5B7044C35C0849CF7FF713051C0302C7FBE2D6834C002000000001C51C0D027B9C3266E33C09A266C3F193A51C0CC27B9C3260E33C09244F641964451C0C41BB5C2F40932C0F8FCBE7FF35E51C0A8AD9FFEB3A231C092FF907EFB5F51C0AC52B3075A8131C002E8F7FD9B6751C030A2B437F83631C080A8FB00A43451C02CA2B437F85630C0EE60C43E015B51C0A82094F7713C2FC028508BC1C34851C0487D3CF4DD7D2EC0D4DCD1FF725751C008F3C98AE19A2DC0D6E59480983651C088E28E37F9652CC0F096E4805D3E51C03039B5334CBD29C030293E3E212B51C0E0C798BB960029C09C776341616451C068F9D687F5E625C07036AB3E572551C0A8B94DB8573626C0148733BF9AA850C0C879E2395BD023C0829CF7FF715850C0D8AB014A436523C05A880E81235950C080F62345648826C03CDD4081773F50C0E0010F0C200428C02C2FC03E3A1950C0183883BF5FEC28C09C048BC399894FC040ABE80FCD4C29C078AE7D01BDEA4EC028B16A10E6162BC0801D8D43FD844EC0282366F679FC2AC0F8D2307C443C4EC01839B5334C9D2BC050880E8123214EC0E8F50A0BEE2F2EC05C880E8123494EC0B8963AC8EB312EC0502250FD83144EC07CF3E2C4574330C0F81AD7BFEB294DC04C1F0F7D774730C030776682E1324DC0B0355B79C93F31C02C08E57D1CDF4CC054B29C84D29731C0B4AD9FFEB3C24CC07CEA1F44323432C0A8FE08C3800F4DC0D0942BBCCBBD33C0F0C9DFBDA3EC4CC060855B3E92FA33C0A8D4EC8156144DC078E5CFB7052B34C084785DBF60134DC0B8415F7AFBD333C004D3307C448C4DC000D671FC505933C0D8A3703D0ADF4EC08CEB51B81EA533C0081B65FD66524FC098EA3BBF283D36C0247AA702EE674FC0F4CFEFFB37FF35C004DF347D76F84FC020B1F9B8360036C0A692C83EC81450C0F86C72F8A4DF36C0C0525DC0CB2550C028A2B437F83636C0A6AAD0402C4C50C044F3AB39401836C0
28	Democratic Republic of the Congo	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
29	Burundi	0106000020E6100000010000000103000000010000000B000000E872A087DA3A3D40E0C8E369F9010EC088AEEFC341063D4080E4D4CE30F505C0A874B0FECFD93D40206AC020E91306C0789065C1C4F33D404049D74CBE7902C0E8D03FC1C5923E408023D5777E3103C07814AE47E16A3E40C09A8F6B43E506C0D8E09A3BFAD73E40202BDCF291D407C08831957EC2D53E40A0F61E2E390E0AC0182A8E03AF063E40D069C020E91311C0D84334BA836C3D40301B2B31CFCA11C0E872A087DA3A3D40E0C8E369F9010EC0
41	Cuba	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
42	Cape Verde	0106000020E6100000060000000103000000010000000400000070F0A1444B5E38C0182FDE8FDB9F2D40203E05C0788638C07809DCBA9BD72D40F0ED79FEB46138C0902FF7C951182E4070F0A1444B5E38C0182FDE8FDB9F2D4001030000000100000004000000B833BDC4587237C0E085048C2EF72D4038B98AC56FAE37C00838A11001DF2D40F0D2307C44C437C0803E3C4B90812E40B833BDC4587237C0E085048C2EF72D400103000000010000000400000030508BC1C3B436C07CF755B950093040A0CB290131F536C034DB87BCE516304030185B0872CC36C024917EFB3A3C304030508BC1C3B436C07CF755B95009304001030000000100000004000000E091EA3BBF0838C03C6552431B983040103201BF465238C0CC420246977B3040C08B683BA66E38C0643A58FFE7A43040E091EA3BBF0838C03C6552431B983040010300000001000000040000008066D7BD15ED38C054D505BCCCCC3040D09AADBCE41739C03C895E46B1D4304028560DC2DCEE38C094F5B704E0EB30408066D7BD15ED38C054D505BCCCCC3040010300000001000000040000006063963D094839C0A474B0FECFE93040E085E63A8D5439C0CCCABDC0AC18314010C03E3A75F938C05CB5DD04DF1C31406063963D094839C0A474B0FECFE93040
149	British Indian Ocean Territory	0106000020E61000000900000001030000000100000004000000562B85402E1F5240C09CF3531C871DC05A1F813FFC165240B0643909A50F1DC0320ED940BA1C5240B0D79E5912F01CC0562B85402E1F5240C09CF3531C871DC001030000000100000004000000F61186014BD65140D0C64ACCB3A21AC0BE3D0801F9D55140207365506DA01AC0EE57738060D75140408713984E9B1AC0F61186014BD65140D0C64ACCB3A21AC001030000000100000004000000FE0241800CD15140A052B3075A9119C032232E008DD05140503F3734658719C002E2E7BF07D151405038BA4A777719C0FE0241800CD15140A052B3075A9119C00103000000010000000400000096F0BDBF41D65140E069C020E9D318C0E669F981ABD55140B0E8297288C818C08EC6A17E17D75140502B84D558B218C096F0BDBF41D65140E069C020E9D318C0010300000001000000040000000AE5284014F25140F0B850F9D7C215C0EE8711C2A3F05140B06ABB09BEB915C0060341800CF15140C07C410B09B815C00AE5284014F25140F0B850F9D7C215C00103000000010000000400000016967840D90D5240C090EF52EA7215C0565260014C0D5240F0EB4CA1F36A15C046B665C0590D524090B4C4CA686415C016967840D90D5240C090EF52EA7215C0010300000001000000040000001A786000E10E5240403F3734654715C056499D80260E5240E0E7F7FD9B5715C03EC5AA41980E524030FDD7B9694315C01A786000E10E5240403F3734654715C0010300000001000000040000009AFF024180EF5140F0058200192A15C05258E20165EF5140B0573A1F9E1515C0AA7A32FFE8EF514090067DE9ED0F15C09AFF024180EF5140F0058200192A15C00103000000010000000400000046C8EBC1A4F751404083BEF4F60715C0960B0742B2F75140E05DBC1FB7FF14C0D29D60FF75F85140409544F6410615C046C8EBC1A4F751404083BEF4F60715C0
18	Burma	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
19	Benin	0106000020E6100000010000000103000000010000001100000040C05C8B16E00340A0FBAA5CA85C194080F67B629D2AFA3F70CBD765F8DF1840805181936D60F63F3009DFFB1BDC22400048E17A14AEF53F08EC6AF294FD2340003E9CC074DAE83F8818213CDAC0244000B3169F0260ED3FC8887D0228FE254080B16A10E6F6F63F701EA33CF3EA264000416491261E0040982FF7C951D8264000166A4DF32E0340807D586FD4CA274040FAF02C4106034090289831057B2840002C0E677EB50640E064E3C116CB2840002FA699EED50C40A8554ACFF462274080A4703D0AD70E40C8622AFD842B254040F6285C8FC2084078FA96395D2E224080301004C8500640B05FE97C78162240800B60CAC0C10540601956F14676194040C05C8B16E00340A0FBAA5CA85C1940
20	Solomon Islands	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
35	Cameroon	0106000020E61000000200000001030000000100000004000000202FDE8FDB5F2340E05512D907990C40C0656B7D9140234000BB4BE2AC680C40505C8FC2F5482340E0D9D0CDFEA00C40202FDE8FDB5F2340E05512D907990C40010300000001000000260000001021CB8289272D40401077F52A7A2940E0D02346CF152E401018080264282840008D9AAF921F2E4010BFB9BF7A942540508E75711B5D2F40D0091346B3FA2340E08C2AC3B8632C4050B29DEFA7F6234020E8154F3DEA2B4068BB5F05F8462340603F373465672E4078B3CEF8BEF8204080E200FA7DFF2E40E01DC3633F1B1E404020990E9DD62C40A03465A71F241840B085048C2E772D40F06F4221027E1240E0B837BF611A304060573F36C92F0740100341800C3530404005871744C40140201E8A027D123040007D82C47677FA3F908B868C47212D406007B474055B0140E05FE97C78962A40E020B248134F014010A7B1BD160C2940A00587174444024070B7088CF5AD2640E0F755B950590140A032384A5E0D2440C02B7FBE2D5801404024F0879F9F2340809BADBCE4BF024080B81E85EB712340C0963FDF16EC0E4020C87C40A0F32140208B7269FC62104080C1E10511B121402033384A5E8D12400083C30B22022140A03106D6711C1240209A7B48F82E2140201F4DF5643E13401007B47405BB214060416491265E1740E05626FC52972340104391EEE7341B40C014AE47E13A254030B728B341461C40602975C938AE2640A0FDD7B969C3194080A148F773BA2740F0012D5DC1561C40A0C2137AFD812840F8003274ECD02040E07C410B0998294008068200198A2140D05A99F04B9D2B4008240C03961C2640A01EA33CF34A2D4028FBAF73D3262740F0B837BF614A2D40F094490D6D602840B0F755B950592C40D0DE52CE17CB284000B728B341262C40E074B0FECF292A40B0C420B072002D40D80D863AAC002A401021CB8289272D40401077F52A7A2940
21	Brazil	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
22	Bulgaria	0106000020E6100000010000000103000000010000001800000058C1E10511E13B409EC85A43A96B4540D0D03FC1C5723B407EA86DC3283C45401815C78157033C40D2CDFE40B9FD4440A804FD851E653B407A03CC7C07014540D0BFCFB8705C3A40BAE07EC003DB444010904C874E4B3A40A6E67283A1DA4440C0F8F884EC103A40E20F238447D94440289221C7D6233A40B23B4F3C67AD4440505C8FC2F548394082A52C431C9F4440B8E7A4F78D43384006E2E7BF07C94440D00166BE83EF3640721283C0CAAB4440809065C1C4033740A2C2D84290E1444088035ABA825D36407E5D86FF7429454080ABAE4335713640A6AAD0402C6945400894BF7B47013740D6CABDC0AC984540285FD042025E364032D8463CD9E9454098592F8672AE364076309B00C31C464000904C874E0B3740DEEE5701BE094640A001BC0512E03640D2F4D901D7EB45402069C537142E38405A0ABABDA4D7454070CADC7C236E394016EDF1423AD04540F8B0A54753093B4072361D01DC1246409896917A4F953C40FA0B76C3B6DF454058C1E10511E13B409EC85A43A96B4540
23	Brunei Darussalam	0106000020E61000000200000001030000000100000005000000F6F02C4146CE5C4040624D6551381340C23D0801F9D55C4070DD5CFC6D3F11406697E13FDDC15C40D0685721E54713402296067E54C95C4000C251F2EA9C1340F6F02C4146CE5C4040624D655138134001030000000100000005000000B613ECBFCEBE5C4030DA0242EB911340AE0A9B012EC15C4000AFD3484B951340FAE1E7BF07A95C40B0253960571310406A2409C215865C40602E54FEB55C1240B613ECBFCEBE5C4030DA0242EB911340
24	Canada	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
25	Cambodia	0106000020E61000000300000001030000000100000005000000000000C89DF15940000000408FE22440000000C8E8EF594000000040E9F32440000000485FF0594000000040F90525400000008820F359400000004000002540000000C89DF15940000000408FE2244001030000000100000004000000000000081BD459400000004034722540000000E842D15940000000C0E5562540000000485FCC59400000004045832540000000081BD45940000000403472254001030000000300000017000000000000484EDF5A4000000040B0E52C40000000280AE35A40000000400CB5284000000048E59A5A40000000C07CF2274000000068539D5A4000000040EC542740000000E877765A4000000040EB51274000000008038D5A4000000040868A2540000000C885465A40000000403EE9254000000048801C5A400000004071D8244000000008DB0F5A40000000408F2225400000008852FB5940000000C0382E254000000048E4E7594000000040B9FD24400000000889E35940000000C05A502640000000084DC85940000000C01FC4254000000048A1BA5940000000408E4527400000000824985940000000C0D4252B40000000088ECB594000000040D1A82C40000000887A4D5A400000004005B32C4000000008A0835A40000000C028DC2B40000000284D805A40000000C000BF2C40000000889BA25A40000000408C322D4000000048A1B65A40000000C0299B2C4000000088FBE25A4000000040D06A2D40000000484EDF5A4000000040B0E52C4004000000000000A818C25940000000C027DD2640000000C8E9C25940000000407FF02640000000289AC05940000000C0CC0C2740000000A818C25940000000C027DD26400400000000000048CBC1594000000040267E2640000000E8AEC25940000000C048C026400000008820BF5940000000402DD8264000000048CBC1594000000040267E2640
26	Sri Lanka	0106000020E610000006000000010300000001000000050000006231957EC26D5440708C9FC6BDB91E40CEB5F63E556D5440504D689258B21E40563A58FFE76C544000EA5BE674B91E409A26DE019E6D5440E0D90242EBD11E406231957EC26D5440708C9FC6BDB91E40010300000001000000040000004AC8EBC1A4735440D01FB75F3EE91D4082336ABE4A6E544010FF092E56F41E40BEFE243E7773544090EDB5A0F7661E404AC8EBC1A4735440D01FB75F3EE91D400103000000010000000400000046B9A64066FA5340200F45813E09224032FC523F6FF65340E8656B7D9100224096F63FC05AEC5340F8F44BC45B2F224046B9A64066FA5340200F45813E0922400103000000010000000400000012967840D9ED5340B8ED974F56F42240E627D53E1DEA5340A89D0C8E92FF2240FEE4284014EA534050240C03961C234012967840D9ED5340B8ED974F56F4224001030000000100000004000000CE97DEFE5CFE534090289831053B2340D2B22781CDF75340185A80B6D54423407A6CCB80B3F65340B894490D6D802340CE97DEFE5CFE534090289831053B2340010300000001000000110000002E0516C094115440F8CCCCCCCC8C2340AE716F7EC334544030C422861D86224072A3737E8A3A5440B0B950F9D7E2214056137D3ECA4E54408832384A5E4D214096F63FC05A485440100000000000214002E869C020575440C0FACDC474F92040E645ED7E15595440903BFBCA834C2040E65AB4006D78544000EEB5A0F7261D408A54C37E4F6A5440D0170D198FC219402A0516C094255440F015E0BBCDAB17406EDCD440F302544040A8FC6B79F51840AA7D737FF5EC5340E8CABDC0AC282040FEF36DC15203544030BDAAB35A302340562B85402E27544078B950F9D7E22240AA8FF98040FB5340D85A99F04B7D2340563ACAC16C1C544060895E46B12423402E0516C094115440F8CCCCCCCC8C2340
27	Congo	0106000020E610000001000000010300000001000000250000000018963FDF8E2940B0C01DA8538E11C000D3DC0A610D2840C026A25F5B0F14C070A5F5B70448264060EDB5A0F7660FC010E3A7716FFE264000F71E2E390E0CC0801D71C806DA274080CEC29E76180DC0100473F4F8252740406BED7DAAAA02C0F0716F7EC3F42840A0406491269E02C0D0CCCCCCCC4C2940005C8FC2F528FDBF406E8786C5002A40203D7D04FEF002C0E085048C2EF72A40C0FFFFFFFF7F03C0D0B628B341862B4000CB9F6F0BB600C080B3CEF8BE382C4000C61858C7F103C090BEA08504DC2C40C0C0BE9D4444FEBF00C2FA3F87092D4080ACD9CA4B7EE3BF005EDA7058B22B400016D0D2156CC9BF70D9E90775F92C400086C8224D3CED3F10261B0FB6602C40403BB01C2143F63F70C49448A25F2A40405182FE428FF33FE05FE97C78962A40E020B248134F0140908B868C47212D406007B474055B0140201E8A027D123040007D82C47677FA3F100341800C3530404005871744C40140007CB779E3A83040C005871744440C40888AE3C0AB79314080FE092E56B40D40A05F5B3FFD9F3240801B62BCE6D50B402021CB82891732404000378B17CB014060C554FA09B7314080211631EC30E1BF188BFCFA21323040A032FCA71B6801C018068200193A30402094490D6DA00AC0A0D97745F0C72F40E0AA764D488B0FC010EFAB72A1522D40F00AD28C45A313C00060E97C78D62C40802A89EC838C13C0B050A4FB39CD2C40208FC2F5281C11C0C0978A8D79752B4090C745B588C811C0E07A32FFE8D32A40A0BF9657AE8713C0B06DFC89CA2E2A40802502D53F8812C00018963FDF8E2940B0C01DA8538E11C0
30	China	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
31	Afghanistan	0106000020E61000000100000001030000000100000036000000D2A623809BBA52406A368FC3609E424056465C001A9952400A3961C2689642405E8B4F0130A45240EEA2E8818F83424036A79201A023524092A8893E1F694240D285CABF96CF51407A6649809A104240C604A73E90E9514062FB743C66B64140564CDE0033BF51405E61A5828A464140060F45813EC551408E2AA73D25074140B280B4FF017A5140AEBF97C283044140BE3AC780EC945140061E8A027DAA40402EF6D03E56605140A659677C5F844040AE80B4FF01555140B44DB9C2BBF03F405A73B9C1503551402C83DC45989A3F4026085740A10A51406CCDE50643D53F4002D6E3BED5E450404C6F47382D883F4026327381CBF15040A424253D0C553F4002F12C4146AE50408CB8E4B853363F40D6949D7E509950408C18213CDAF03E40E65AB4006D9050409C2766BD18DA3D40B480B4FF013E4F4014BE4D7FF6673D40642B85402E6F4E40A489778027DD3D40343B3602F1EC4E400496CE8767053F400415C78157DB4E401C8BFCFA21623F40DCDF8442046C4E40FCA5457D927F3F405482FE428F4A4E40E29D60FF75884040B4CB9BC3B5784E40FE1D8A027DC240407C6308008E434E40B63E90BC73D2404094457EFD10414E405E3D997FF4114140B49E3E027F704E40E27C957CEC284140FCF6AE415F5C4E403235B401D84241404CB9A64066A34E404E50A73CBACD41400CA6457D92274F40D6066003229241404C5B2382715C4F40866649809AA0414014A0C37C798D4F40628BC1C3B4B9414044F38FBE498F4F40069700FC53EE4140EE4EB0FF3A205040A67A32FFE82342400E846401133350409221E4BCFF8F4240AEB6D4415E6D50402E3B3602F1C4424086BA0F406AA250407E78CF81E5AE4240CA793881E9F150404E70EA03C9974240722D5A80B6035140BE5510035D7742408293A641D13851407E36AB3E57AB4240FAEAAA402D5451404E8E0244C18E424096E1783E036151404A55A18158CA4240C23D0801F9895140CA880B40A3C44240E6543200548A51404A80D3BB78F742406AD993C0E6BD5140BE79AA436E3C43403E8F8AFF3BD75140BE13ECBFCE1F4340960B957F2DD051403A622D3E05F64240FED8243FE2E55140FE6393FC88F342402AFF93BF7BDB51404E8BC1C3B48942407E36AB3E57EB51406AE2E47E87564240BE0A293FA95352401E90847D3BBB4240D2A623809BBA52406A368FC3609E4240
32	Bhutan	0106000020E6100000010000000103000000010000000B00000016967840D99D56404C55A18158123C402EF38FBE49D35640BC716F7EC3143C406AE597C118EA5640949065C1C4C33B40AAB05241450757409CA86DC3284C3B40D6BEB9BF7A0457408C0C1D3BA8DC3A4046AA61BF276956400CC710001CB73A409AED7C3F35395640348C9FC6BDF93A40366EA301BC3A5640BC1FF0C000523B40C6310400C76556403C895E46B1243C40BE46CB811E815640DC34EF3845533C4016967840D99D56404C55A18158123C40
36	Chad	0106000020E61000000100000001030000000100000023000000B0C420B072002D40D80D863AAC002A4000B728B341262C40E074B0FECF292A40B02688BA0F402B40B8F292FFC96F2B40200AF5F411F02A40D0A6B1BD16EC2C4070A148F773FA2E40E425AAB706EA3040001286014BFE2F40DCB837BF615A344010F2ECF2AD672E40D457C9C7EE7E3540B013984EEBFE2D400CAC55BB2600374050CAA48636003040FC14C7815773374088290307B400384014944DB9C27F3340D0FB71FBE5FF374098D7A02FBD652F409817EFC7EDEF3640D86E2EFEB61F2F40988461C092EF3640487A19C5723B2E404855A18158623640482DCF83BB1B2D405069C537148E364028B3B5BE48402C40B868ACFD9D153640286002B7EE8E2B4010904C874E4B36407809DCBA9BB72A40B07A32FFE8D33540C82FF7C9519829402021CB8289773640081286014B3E294020D28C45D3DD3640409622F94AD82540B04D637B2DB83540383F373465472540088E3D7B2EB73540B8716F7EC39424400809C380255F34408838BA4A77372240386893C327FD3240D0C3094CA7ED2140404415FE0C0F3340A8307DAF2128214088129F3BC1963240F08FDB2F9F14204080E200FA7DFF2E40E01DC3633F1B1E40603F373465672E4078B3CEF8BEF8204020E8154F3DEA2B4068BB5F05F8462340E08C2AC3B8632C4050B29DEFA7F62340508E75711B5D2F40D0091346B3FA2340008D9AAF921F2E4010BFB9BF7A942540E0D02346CF152E4010180802642828401021CB8289272D40401077F52A7A2940B0C420B072002D40D80D863AAC002A40
37	Comoros	0106000020E6100000030000000103000000010000000400000064499D8026EE4540086DE34F54B628C0ACE3310395D54540B8A3703D0AB728C0B46E2EFEB6CF454000D3307C448428C064499D8026EE4540086DE34F54B628C0010300000001000000040000005CFB743C663E464088643909A52F28C0DCEE5701BE41464040A5660FB4C228C02C1DACFF731A464048807D74EA5228C05CFB743C663E464088643909A52F28C0010300000001000000040000003C35B401D8BA454018272F3201DF27C064431B800D9C4540B02FD978B08527C084423D7D04A44540F813950D6BC226C03C35B401D8BA454018272F3201DF27C0
38	Colombia	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
150	Christmas Island	0106000020E61000000100000001030000000100000004000000721805C1E36C5A4050791EDC9D0525C0F6CFD38041685A40686DA818E7DF24C0B2C8E880246F5A4070183E22A6C424C0721805C1E36C5A4050791EDC9D0525C0
33	Chile	0106000020E61000009200000001030000000100000004000000000000408EDF50C00000004022EA4BC0000000402AE750C0000000407CF34BC000000080E1F650C000000080B1EC4BC0000000408EDF50C00000004022EA4BC001030000000100000004000000000000409ECD50C00000000062F24BC0000000407DDA50C00000008086EA4BC000000000CECF50C0000000C0FDE94BC0000000409ECD50C00000000062F24BC0010300000001000000040000000000004075C550C0000000C070F54BC0000000C0FCCA50C0000000C0E4EF4BC000000000C6C650C000000040A6E64BC00000004075C550C0000000C070F54BC00103000000010000000400000000000000B4CA50C000000080A8E44BC00000000073CF50C00000000028E54BC00000000021CB50C0000000B03EE14BC000000000B4CA50C000000080A8E44BC0010300000001000000040000000000000028D150C00000008056DC4BC0000000F89BE350C0000000402ADB4BC0000000C0D3D650C00000008090C94BC00000000028D150C00000008056DC4BC001030000000100000004000000000000C0A1EE50C000000000EECF4BC00000004009EC50C0000000C036C04BC000000040BEE550C00000000031C54BC0000000C0A1EE50C000000000EECF4BC00103000000010000000400000000000040326C51C000000000CDB44BC000000040F17051C0000000803CAB4BC000000000CD6851C000000000F6B04BC000000040326C51C000000000CDB44BC001030000000100000004000000000000000F7F51C0000000409DAE4BC0000000C0CA8651C000000000DEA54BC0000000804D7C51C0000000C0C3A44BC0000000000F7F51C0000000409DAE4BC00103000000010000000400000000000080FBB750C00000008086AA4BC000000040B6C450C0000000C057A34BC0000000403BB850C0000000404C9D4BC000000080FBB750C00000008086AA4BC001030000000100000004000000000000C091A450C00000000072A44BC00000004012A850C00000008090994BC000000080EA9A50C0000000C0EC984BC0000000C091A450C00000000072A44BC0010300000001000000040000000000008044B450C0000000C02E8F4BC0000000809FC450C0000000405B804BC0000000C02EB750C0000000C060834BC00000008044B450C0000000C02E8F4BC00103000000010000000C000000000000F8621951C000000040CF7A4BC000000040E94351C00000004053874BC0000000C0790D51C0000000C0EBA14BC000000040AE2F51C000000000B4A24BC000000080340A51C0000000C005B34BC0000000806E0351C00000004033DB4BC0000000801B3C51C000000040D8BA4BC0000000806E3351C00000008024984BC000000040855B51C0000000C0BA944BC0000000C0254B51C00000008090C14BC000000040228251C0000000C004944BC0000000F8621951C000000040CF7A4BC001030000000100000005000000000000C0F4F150C000000080B0754BC0000000806EC350C00000004075914BC000000040190651C000000040549E4BC000000040531751C0000000C0E3784BC0000000C0F4F150C000000080B0754BC001030000000100000006000000000000808FA051C0000000C02A7C4BC0000000C0FCAE51C0000000C0F4814BC0000000C0EC9051C0000000C0DC8E4BC00000008003C151C0000000C0BB7B4BC000000080F29351C000000000CE734BC0000000808FA051C0000000C02A7C4BC00103000000010000000400000000000040C87051C000000040F1844BC000000000A57B51C00000000018734BC000000040A64A51C0000000C0AA7A4BC000000040C87051C000000040F1844BC00103000000010000000400000000000040D8C651C0000000009C6F4BC00000000062BA51C00000004054764BC0000000403ADD51C0000000C047714BC000000040D8C651C0000000009C6F4BC001030000000100000004000000000000C0FCA651C000000000CE734BC000000040B7AF51C000000000EE6F4BC000000000319951C000000000936F4BC0000000C0FCA651C000000000CE734BC001030000000100000004000000000000005A0152C0000000B03E514BC00000008097FB51C000000040535F4BC0000000407D0652C0000000C004544BC0000000005A0152C0000000B03E514BC001030000000100000004000000000000C0BB1352C000000000412F4BC000000080A71D52C0000000400A374BC000000080982252C0000000C0B22B4BC0000000C0BB1352C000000000412F4BC00103000000010000000400000000000080029251C00000008045234BC000000040B6A051C00000004096144BC000000080028E51C000000080031D4BC000000080029251C00000008045234BC001030000000100000005000000000000007BD051C000000040BE094BC0000000809FC051C000000000280D4BC00000000073C751C0000000B03E314BC0000000C0C3EC51C0000000809F144BC0000000007BD051C000000040BE094BC001030000000100000005000000000000809F1452C00000000008214BC000000040B62052C0000000C0F4194BC0000000C04E1352C0000000802C094BC0000000C03E0D52C0000000C0FC124BC0000000809F1452C00000000008214BC001030000000100000004000000000000406D4C52C0000000807F104BC0000000C01D5E52C00000000051094BC000000080C94F52C00000004096044BC0000000406D4C52C0000000807F104BC00103000000010000000500000000000080F3EA51C000000080D1F84AC00000000008FD51C0000000407D024BC00000000030F651C0000000407C2B4BC0000000007B1052C00000008076F84AC000000080F3EA51C000000080D1F84AC00103000000010000000600000000000000499C51C0000000C026EE4AC0000000402AAB51C0000000409DF64AC00000008090A151C000000040431D4BC0000000403BB851C0000000C081064BC00000008034A251C000000080C9C74AC000000000499C51C0000000C026EE4AC001030000000100000004000000000000C03E7552C0000000408ECB4AC0000000C0DC7652C00000000007BA4AC000000000006C52C0000000F0C5C24AC0000000C03E7552C0000000408ECB4AC00103000000010000000A000000000000C04F3A52C000000040F8B64AC0000000C0363852C0000000004AD74AC000000080023652C0000000C0A1BA4AC0000000C0EC0852C0000000409DE64AC0000000C0BB3752C0000000807E114BC0000000C0DC2E52C0000000407CEB4AC0000000007B4852C0000000807E014BC000000000005052C00000008086DA4AC0000000409E6552C000000040B6E04AC0000000C04F3A52C000000040F8B64AC00103000000010000000400000000000080B05D52C000000000CDBC4AC0000000C0A95F52C00000008087C94AC000000040537352C000000000EFB64AC000000080B05D52C000000000CDBC4AC00103000000010000000400000000000080448C52C0000000407DAA4AC000000080978F52C0000000805DA64AC000000000CE8352C0000000801C9F4AC000000080448C52C0000000407DAA4AC001030000000100000004000000000000C06F5A52C00000008076704AC000000000085952C000000000107A4AC000000080247052C0000000C058724AC0000000C06F5A52C00000008076704AC0010300000001000000040000000000004074AE51C00000000062724AC000000040F9B151C0000000405B704AC0000000F89BA751C00000008023694AC00000004074AE51C00000000062724AC00103000000010000000400000000000080139752C00000004075794AC000000040AEAF52C000000080DA604AC0000000C0C24552C0000000C067AD4AC000000080139752C00000004075794AC00103000000010000001D00000000000000B4BA51C000000000B45A4BC0000000805EB151C0000000C02E574BC0000000C0B2B751C0000000C0DB574BC000000000B4BA51C000000000B45A4BC000000040320052C0000000C0573B4BC0000000C05F8851C00000000042464BC00000008056B851C00000008023114BC000000080238951C0000000C0D3364BC000000080DA8C51C00000008076284BC0000000C0898351C0000000C0E41F4BC0000000C0477151C0000000405C474BC0000000C0FC7651C0000000403B244BC0000000806E4F51C00000008023394BC000000000175851C0000000C0E4574BC0000000385C4B51C0000000C0584A4BC000000080773F51C0000000004A374BC000000000CE8B51C00000008024E84AC000000040CF5651C000000040F1AC4AC000000040969C51C0000000801CAF4AC000000000729C51C0000000C0A2814AC000000000628651C0000000C0BB734AC0000000C02E9B51C000000080F3624AC000000000B47A51C000000000B5694AC000000080EA5A51C0000000C0A13A4AC000000080862751C0000000001D524AC000000080B12851C000000040E8644BC000000040B62851C0000000C002674BC0000000C0282951C000000000BE714BC000000000B4BA51C000000000B45A4BC00103000000010000000400000000000040AE7352C00000000063594AC000000080FA8452C000000080A74D4AC0000000C0806F52C0000000C0A9334AC000000040AE7352C00000000063594AC0010300000001000000040000000000004053AF52C0000000C091284AC00000000084B452C0000000805E1D4AC000000040AEA752C000000080981A4AC00000004053AF52C0000000C091284AC00103000000010000000400000000000040B77352C000000040D8324AC000000040F08552C0000000C0BA144AC0000000C0817252C000000040D0214AC000000040B77352C000000040D8324AC001030000000100000004000000000000406D8C52C0000000807E114AC000000040D77B52C0000000402A2B4AC0000000C0CA9A52C000000080E2114AC0000000406D8C52C0000000807E114AC00103000000010000000400000000000000CDB052C0000000801B184AC00000000042B252C0000000C0890F4AC0000000C026A652C0000000406C094AC000000000CDB052C0000000801B184AC00103000000010000000400000000000080139752C000000080E2094AC000000040F99952C0000000800B064AC0000000C0AA9652C0000000C02E074AC000000080139752C000000080E2094AC00103000000010000000400000000000000E7AD52C0000000402A0B4AC00000004053A352C000000070B8F649C000000000389F52C00000008086FA49C000000000E7AD52C0000000402A0B4AC00103000000010000000400000000000080766C52C000000000EF1E4AC000000040198652C0000000C01DF649C000000000287152C000000030BF084AC000000080766C52C000000000EF1E4AC0010300000001000000040000000000008045B752C000000040D0114AC000000000CEAF52C000000000BDEA49C0000000C058A652C00000008097EB49C00000008045B752C000000040D0114AC00103000000010000000400000000000040BEC552C0000000006AF349C0000000C088C452C000000080C1DE49C0000000803DBE52C0000000809FDC49C000000040BEC552C0000000006AF349C00103000000010000000400000000000040438952C000000040C7F949C00000008056A052C0000000006ADB49C000000000E78552C00000000000F049C000000040438952C000000040C7F949C001030000000100000004000000000000C0FC7252C000000080DAE849C000000000297C52C000000040DFD449C000000000C67252C00000004043DD49C0000000C0FC7252C000000080DAE849C001030000000100000004000000000000C0FDB152C0000000802CE949C00000000010BE52C0000000801C0F4AC000000040AEBB52C00000000062D249C0000000C0FDB152C0000000802CE949C00103000000010000000400000000000040858352C0000000C0DCC649C000000000297C52C00000004096E449C0000000803C8F52C000000040C7D949C000000040858352C0000000C0DCC649C001030000000100000004000000000000C004C052C0000000C0A1B249C0000000C0DBD352C0000000802CD149C00000008023CD52C0000000404BA649C0000000C004C052C0000000C0A1B249C001030000000100000004000000000000C0898752C0000000402BBA49C0000000C0BA9052C0000000C078A649C000000080F38A52C00000004096A449C0000000C0898752C0000000402BBA49C00103000000010000000400000000000080027252C0000000C089AF49C000000080867A52C00000008066A649C000000040A67252C0000000406CA149C000000080027252C0000000C089AF49C00103000000010000000400000000000000EF8252C0000000C088B049C000000000398652C000000040E89C49C0000000C0F47D52C000000000419F49C000000000EF8252C0000000C088B049C001030000000100000004000000000000C04FA252C0000000C0BBA349C0000000005AC152C000000080F2BB49C000000040CFB252C000000040CF9A49C0000000C04FA252C0000000C0BBA349C00103000000010000000400000000000040B7BF52C000000040AF9649C00000000029BC52C0000000809F8C49C0000000C0DCB652C000000000519149C000000040B7BF52C000000040AF9649C001030000000100000004000000000000C0589A52C0000000C0AA9A49C00000008098A652C0000000C0EB8949C000000000DE9D52C000000080A08349C0000000C0589A52C0000000C0AA9A49C00103000000010000000400000000000080DA9052C000000040B79F49C0000000809F9452C000000080B97549C0000000C03F8C52C000000000089949C000000080DA9052C000000040B79F49C001030000000100000006000000000000F8629952C0000000C0266E49C0000000C0F49952C0000000407C8B49C0000000C0DC9E52C000000040B77F49C0000000C01DAE52C000000040548E49C000000040BEBD52C000000080A07B49C0000000F8629952C0000000C0266E49C001030000000100000004000000000000801BAC52C000000000077249C0000000401ABD52C000000040955D49C000000000EEAF52C000000080D95949C0000000801BAC52C000000000077249C001030000000100000004000000000000F89BBF52C0000000C02D6849C0000000C088C452C0000000407C5349C000000000B4BE52C0000000C00C5549C0000000F89BBF52C0000000C02D6849C00103000000010000000400000000000080B0A952C0000000C0574B49C0000000C0E4AB52C0000000F0C54249C0000000403AA552C000000000204449C000000080B0A952C0000000C0574B49C001030000000100000004000000000000402BC652C000000040194249C0000000407DD252C000000040966449C000000000F6E052C000000040DF5449C0000000402BC652C000000040194249C001030000000100000006000000000000004A9752C000000000E63E49C0000000C05F8C52C000000040966C49C000000000F6A052C000000000D55D49C0000000801C9B52C0000000C0054349C000000080E1AA52C0000000805E3D49C0000000004A9752C000000000E63E49C0010300000001000000040000000000000041AF52C000000000004049C00000004032B052C000000000B53149C0000000C0CAA252C000000080D13049C00000000041AF52C000000000004049C001030000000100000006000000000000801CC352C0000000805E1549C0000000008BB252C000000000211349C0000000005ADD52C0000000409D2E49C00000000031C952C0000000C0891F49C00000003895D952C000000080B10449C0000000801CC352C0000000805E1549C00103000000010000000400000000000000A5D352C00000008002D648C00000000021CB52C00000008097F348C000000080E2E552C00000008056E448C000000000A5D352C00000008002D648C00103000000010000000400000000000080C1DE52C0000000800BC648C0000000C00CE552C0000000407CBB48C00000004001DF52C00000004095BD48C000000080C1DE52C0000000800BC648C001030000000100000004000000000000C0D39252C000000080C0C748C000000040D89A52C0000000405BD048C0000000C0E49B52C000000070B8B648C0000000C0D39252C000000080C0C748C00103000000010000000400000000000080EABA52C0000000C0C2A548C0000000C060CF52C0000000803C9348C0000000803DBE52C000000080FB8348C000000080EABA52C0000000C0C2A548C001030000000100000004000000000000404BD252C000000000D68C48C00000008002EA52C000000000C59B48C000000040F8D652C0000000C0267E48C0000000404BD252C000000000D68C48C0010300000001000000060000000000008002D252C0000000C0EB7148C0000000807FD052C0000000407D8A48C000000000A4D452C0000000402B7A48C00000000000E052C000000040F08548C00000000007EA52C0000000C02D7848C00000008002D252C0000000C0EB7148C0010300000001000000040000000000008045CB52C000000000F77F48C00000000000D452C000000080666648C00000004043C552C000000040D07148C00000008045CB52C000000000F77F48C00103000000010000000400000000000040AFBE52C0000000400A5F48C00000000073BF52C0000000000F5348C000000000D6B452C000000080B15448C000000040AFBE52C0000000400A5F48C0010300000001000000040000000000000007D252C0000000C04E5B48C000000000E7E952C0000000C04F6248C0000000C046D652C0000000005A5148C00000000007D252C0000000C04E5B48C00103000000010000000400000000000040B7C752C000000000B46A48C0000000C0E4CF52C000000000BD6248C0000000C091C452C000000080355148C000000040B7C752C000000000B46A48C00103000000010000000400000000000000A4D452C000000080554D48C0000000C078E652C0000000C0915848C0000000C0A2E952C000000080B03D48C000000000A4D452C000000080554D48C00103000000010000000400000000000040549A52C000000040D74348C0000000C0DB9F52C000000000183348C000000040539352C000000040E83C48C000000040549A52C000000040D74348C001030000000100000004000000000000C0258352C0000000401A3948C000000040BF8452C0000000C0DC3E48C000000000EE8F52C0000000C02D3048C0000000C0258352C0000000401A3948C001030000000100000004000000000000C0EC9052C000000000C53B48C000000080779F52C000000040F12C48C0000000F89B9352C000000080B12448C0000000C0EC9052C000000000C53B48C00103000000010000000400000000000040CF9A52C000000040012748C00000000062A252C000000000BD2A48C00000000062A652C0000000006A1348C000000040CF9A52C000000040012748C00103000000010000001000000000000000EFA652C0000000C0583A48C0000000006B9A52C0000000C0C2DD48C0000000005AB152C0000000400A0749C000000080E1BA52C0000000806ED748C0000000805EA952C00000000083AD48C00000000052C052C00000000008C148C0000000401AC152C00000000021F348C0000000C026DE52C00000004074AA48C000000080C1BA52C0000000C005AB48C000000040F1B452C000000080448C48C0000000004AC352C000000000306648C0000000801CA752C0000000802C5948C0000000F8D4C152C0000000405C3F48C0000000005AAD52C000000040223A48C0000000400AAF52C000000080C00F48C000000000EFA652C0000000C0583A48C0010300000001000000040000000000004053CF52C0000000C0A12248C00000004001CF52C0000000000F5B48C0000000C047E552C000000000180B48C00000004053CF52C0000000C0A12248C0010300000001000000040000000000004033BB52C000000080F21348C0000000C0D3C252C000000040C83848C00000000072D052C000000000630948C00000004033BB52C000000080F21348C001030000000100000004000000000000C089B352C000000080F3F247C0000000C0A9B752C000000080DA0848C00000004011D152C000000000170448C0000000C089B352C000000080F3F247C001030000000100000004000000000000402A7B52C0000000406CF147C0000000C02E7352C0000000C0A2F147C000000000EE9F52C0000000C026F647C0000000402A7B52C0000000406CF147C0010300000001000000040000000000000072C852C000000080A8EC47C0000000806ED352C0000000C0FCE247C0000000C09AC852C00000000063D947C00000000072C852C000000080A8EC47C001030000000100000004000000000000401ABD52C0000000403BE447C000000080D1C452C0000000C0E3D847C0000000C0E3BC52C0000000006BDA47C0000000401ABD52C0000000403BE447C00103000000010000000400000000000080239D52C000000040A69647C0000000C0FC9E52C0000000C0AA8A47C000000040099452C000000040098847C000000080239D52C000000040A69647C00103000000010000000400000000000080E28952C000000080149647C000000080C08B52C0000000803C8347C0000000006B7E52C000000080148647C000000080E28952C000000080149647C00103000000010000000400000000000000F67052C0000000C0051B47C000000000627A52C000000080980247C0000000C0BB6B52C000000040D00947C000000000F67052C0000000C0051B47C00103000000010000000400000000000080976B52C000000080A00347C000000000727452C0000000C0DBFF46C0000000C0CB7152C000000040D7F346C000000080976B52C000000080A00347C001030000000100000004000000000000C0CBAD52C0000000C00CED46C00000000051C552C0000000C0570B47C00000008086C652C0000000C0E4EF46C0000000C0CBAD52C0000000C00CED46C001030000000100000004000000000000C00C6D52C000000040E0EB46C000000000737B52C000000040E8FC46C000000040967852C000000000E7ED46C0000000C00C6D52C000000040E0EB46C00103000000010000000400000000000000F68052C0000000C079F546C000000040D88652C000000040E8E446C0000000C0788252C00000000042DE46C000000000F68052C0000000C079F546C001030000000100000004000000000000C02DB052C00000008098DA46C0000000801BB852C0000000402AD346C000000080A0B752C0000000008CCD46C0000000C02DB052C00000008098DA46C001030000000100000004000000000000C0B2A752C0000000C0E3E046C000000040AEAB52C00000008087D146C0000000801CA352C0000000C0EBC946C0000000C0B2A752C0000000C0E3E046C001030000000100000005000000000000402A7F52C0000000C0C3DC46C0000000400A8752C000000040E0CB46C0000000C0C38052C000000000CDC446C0000000005A7952C0000000806ECF46C0000000402A7F52C0000000C0C3DC46C001030000000100000004000000000000005A9D52C0000000C0BBE346C000000080FA9852C000000080D1B846C0000000C0708D52C0000000406CD146C0000000005A9D52C0000000C0BBE346C00103000000010000000400000000000000516952C00000008035E146C0000000800B7252C0000000C0CBD546C000000000D66C52C000000080D1B846C000000000516952C00000008035E146C00103000000010000000400000000000080238152C0000000806EB746C0000000C0367452C000000040E8BC46C000000040438952C000000040C7C946C000000080238152C0000000806EB746C0010300000001000000040000000000000049A052C0000000C00CC546C0000000007BA452C0000000C0BBC346C000000040099C52C00000000042B646C00000000049A052C0000000C00CC546C001030000000100000004000000000000C0677952C00000000093B746C0000000008C8152C0000000803CB346C000000000D67452C000000080C0AF46C0000000C0677952C00000000093B746C00103000000010000000400000000000080D99552C000000080FBB346C000000040C7A152C00000008013A746C000000040C89852C000000040DFA446C000000080D99552C000000080FBB346C001030000000100000004000000000000C0817E52C0000000803DA246C0000000C01D7252C000000080EAAA46C0000000C0A18A52C00000004012A046C0000000C0817E52C0000000803DA246C00103000000010000000400000000000000C59352C0000000C025A746C000000040439952C000000000C59346C000000000519152C0000000006A9B46C000000000C59352C0000000C025A746C00103000000010000000400000000000000307652C0000000405B8046C000000040CF6E52C0000000C068A446C000000000188F52C000000000849446C000000000307652C0000000405B8046C00103000000010000000400000000000000BD7E52C000000080027E46C000000080779752C0000000005A8146C000000000C68A52C000000000EF6E46C000000000BD7E52C000000080027E46C00103000000010000000400000000000000AC8152C000000080B06D46C000000080F28B52C000000000006846C0000000404C7D52C0000000804D6446C000000000AC8152C000000080B06D46C001030000000100000004000000000000C0CA7252C000000040857B46C0000000C0257B52C000000080347246C000000000BD7A52C0000000C00D6446C0000000C0CA7252C000000040857B46C0010300000001000000040000000000000072C452C0000000C0787646C0000000C025C752C000000080A06346C0000000C079C152C000000080566C46C00000000072C452C0000000C0787646C00103000000010000000400000000000000AC6952C000000000176C46C000000000EE6F52C000000080D16046C000000000EF6652C0000000C0DC5E46C000000000AC6952C000000000176C46C00103000000010000000400000000000000209852C000000080026E46C000000080B0A152C000000040F85E46C0000000407C9B52C000000000175C46C000000000209852C000000080026E46C001030000000100000004000000000000406C8D52C0000000C0686446C000000000399A52C000000080355146C0000000C0E47752C000000000EE5746C0000000406C8D52C0000000C0686446C00103000000010000000400000000000000289D52C000000080D15846C0000000801CAB52C000000040955546C00000008003A552C0000000405C4F46C000000000289D52C000000080D15846C00103000000010000000400000000000040BEB152C000000000005846C00000008077B352C0000000404B4646C0000000C078AE52C000000000844C46C000000040BEB152C000000000005846C00103000000010000000400000000000040B76F52C0000000C02E5F46C000000040126C52C000000080B04546C000000040BE6552C000000040D85A46C000000040B76F52C0000000C02E5F46C00103000000010000000400000000000000E69252C000000080E24946C000000000939752C000000040324446C000000040E88852C0000000C0784646C000000000E69252C000000080E24946C00103000000010000000400000000000080669A52C0000000C0A24146C0000000400AA352C000000040E93B46C000000040F08D52C000000040E93B46C000000080669A52C0000000C0A24146C00103000000010000000400000000000040438152C000000000414746C000000000498852C000000000633946C0000000C0677D52C0000000C0CB3D46C000000040438152C000000000414746C00103000000010000000400000000000000077652C000000000733B46C000000080877952C000000000932F46C0000000C0787252C000000080143646C000000000077652C000000000733B46C00103000000010000000B00000000000000422E52C0000000404B4646C0000000406D3452C0000000C0FD5146C000000000EF3E52C000000040954D46C000000080033552C000000040645846C000000080DA4852C000000040DF7446C000000040F05152C000000000527846C000000040195A52C000000000086946C000000040434D52C000000000396646C000000040BE5D52C0000000407D5246C000000040E03F52C000000040012F46C000000000422E52C0000000404B4646C00103000000010000000400000000000000176C52C000000000493846C0000000C06F7252C0000000C0E33046C000000040C76952C000000000282D46C000000000176C52C000000000493846C001030000000100000004000000000000407C7B52C0000000005A3946C000000080C18652C000000000512946C000000000937B52C000000000832D46C0000000407C7B52C0000000005A3946C001030000000100000005000000000000407C4F52C000000000B53146C0000000006A5352C0000000C0812E46C000000080FB4F52C000000080C92746C000000040CF4A52C0000000405C2F46C0000000407C4F52C000000000B53146C00103000000010000000400000000000080347652C000000080452B46C000000040547E52C000000000172446C0000000C0577352C0000000C0AA2246C000000080347652C000000080452B46C00103000000010000000400000000000080876D52C000000000EF2646C000000040B67052C0000000807F2046C000000080986A52C0000000C02D2046C000000080876D52C000000000EF2646C001030000000100000004000000000000C0AA9252C0000000F0372746C000000040F89A52C0000000C0A22146C000000040F19452C0000000C0891F46C0000000C0AA9252C0000000F0372746C001030000000100000004000000000000007B9452C000000000F61846C000000000AD9852C000000000C51346C000000040969052C0000000C0681446C0000000007B9452C000000000F61846C00103000000010000000400000000000040BF8052C0000000C05F2446C000000040128852C000000080981A46C0000000804D8452C000000000731346C000000040BF8052C0000000C05F2446C00103000000010000000400000000000000947652C000000040111946C000000040B68052C0000000402B1246C0000000C0057B52C000000080A80C46C000000000947652C000000040111946C00103000000010000000400000000000000C69252C000000000170446C000000000729452C000000080340246C0000000401A8D52C000000040740246C000000000C69252C000000000170446C001030000000100000004000000000000005A6952C000000080D11046C0000000C0A16E52C0000000C02DF845C0000000C09A6852C0000000C0470146C0000000005A6952C000000080D11046C001030000000100000004000000000000C0EB4952C000000080EA0246C0000000C03E5152C000000000DEF545C0000000C0794952C000000000B5F145C0000000C0EB4952C000000080EA0246C00103000000010000000400000000000080C17652C00000000007E245C000000000F67052C0000000C058F245C0000000400A8B52C0000000405BF045C000000080C17652C00000000007E245C001030000000100000004000000000000005AA952C00000008066CE45C000000040CFB252C000000080EAD245C00000004033B752C00000000000C845C0000000005AA952C00000008066CE45C001030000000100000004000000000000803D6652C0000000801C4F45C000000000177052C000000040014F45C0000000F89B6752C000000000FF4845C0000000803D6652C0000000801C4F45C001030000000100000004000000000000C0AA5A52C0000000F0374745C000000000DE6952C0000000C0993145C0000000404B6252C0000000C0473145C0000000C0AA5A52C0000000F0374745C001030000000100000004000000000000C0CA4652C0000000C0DB2745C000000080244C52C0000000C02D2045C0000000406D4452C000000000512145C0000000C0CA4652C0000000C0DB2745C00103000000010000000400000000000000D62052C000000040851345C0000000407C2752C000000000840C45C0000000C09A2052C000000080C90745C000000000D62052C000000040851345C00103000000010000000D00000000000080A87852C00000004064E844C000000040126052C000000080F2EB44C000000080975752C000000040122045C0000000C0056B52C000000040542E45C0000000408E6752C000000080344245C0000000807F7452C000000000F64045C000000000387352C000000080134F45C000000000EE5F52C0000000C0816645C000000080D96952C000000080777745C000000040535F52C000000040AF8E45C0000000C0FC7652C00000004033B345C000000040199A52C0000000C02E9F45C000000080A87852C00000004064E844C00103000000010000000400000000000080034152C000000040A6EE44C000000040BE4552C0000000C00DEC44C000000000F64452C000000070B8DE44C000000080034152C000000040A6EE44C00103000000010000000400000000000000382F54C000000000C5E340C000000038953154C000000040F8DE40C0000000000F2F54C0000000B03FD840C000000000382F54C000000000C5E340C001030000000100000004000000000000C070B153C000000080D2CF40C00000008077BF53C00000000083D540C000000080DAB853C0000000C04FCA40C0000000C070B153C000000080D2CF40C001030000000100000004000000000000E0724F5BC00000000010223BC000000040BF5C5BC0000000406C313BC00000008003595BC00000004011113BC0000000E0724F5BC00000000010223BC00103000000010000000400000000000080355D5AC000000000E7753AC0000000C0675D5AC000000020F8763AC0000000C0585E5AC000000080FB733AC000000080355D5AC000000000E7753AC001030000000100000004000000000000007BF853C000000080D1583AC0000000800BFA53C000000000AD583AC000000000A5F753C00000000041573AC0000000007BF853C000000080D1583AC001030000000100000004000000000000C0EC0454C0000000C0FC423AC000000000620654C000000080EA423AC000000000280554C0000000405B403AC0000000C0EC0454C0000000C0FC423AC0010300000003000000CC00000000000080F35E51C000000000B4A231C000000040964451C0000000C0F40932C000000040193A51C0000000C0260E33C000000000001C51C0000000C0266E33C000000000723051C0000000C02D6834C000000040120C51C0000000A0044C35C00000000017F850C000000080FBD336C000000080C0CB50C0000000C058D236C0000000C00DC050C000000040B60037C0000000807ED550C0000000E08B0538C000000000292451C00000000042C638C000000080861651C000000080021E39C0000000005A2551C0000000005A813AC000000000621251C0000000C04FEA3AC0000000C0E43351C0000000C0DC1E3BC0000000C0F16951C000000080A3663CC000000080028251C0000000C06F4E3DC0000000403A7551C000000040C8303EC0000000C01DA251C00000008024303FC000000040548651C000000080149640C000000080907151C000000040C8B040C000000000007451C0000000C0261E41C00000000052A451C000000040B79F41C000000000289B51C0000000C0691142C0000000C0DBCB51C000000000CE6B42C000000040BFB451C000000040B64843C000000080B0D951C0000000C0CB7543C00000000084EC51C000000040CFCA43C000000000D6FC51C0000000C0CB5D44C0000000C078EE51C0000000C05F0C45C000000000720852C000000080FA2445C0000000C0C30852C0000000802C8145C000000000E6EE51C000000040129845C000000080B8F651C000000000932F46C000000080EAC651C0000000C0154546C00000000010D251C0000000C06F6646C000000000080552C0000000407D6246C0000000000FD351C0000000008CA546C0000000C0F4F151C0000000000FD346C000000040D8EA51C000000000EF5647C0000000C02DFC51C000000040646847C00000008097F751C0000000C05F9C47C0000000000F1752C00000000029BC47C000000040542252C000000040F0F547C000000000621252C000000000C52B48C0000000801B2452C000000040F86648C0000000005A6552C000000040DFC448C0000000C0A14A52C0000000406D6049C0000000C0D31252C0000000402A5349C0000000C0A21952C000000040BEC149C0000000C046FA51C00000008077FF49C0000000C0E47F51C0000000C089FF49C0000000C0451C51C0000000005B304AC000000040B65051C0000000006B1A4AC000000080F2B351C0000000C0C25D4AC0000000C04FBE51C000000040B6E04AC00000000039D251C00000004075F14AC0000000C00C1D52C0000000C060B34AC00000004053F751C0000000C05F9C4AC000000080760052C00000004012C84AC00000008065F351C00000004019C24AC000000080EACA51C0000000806E674AC0000000C0602352C00000008090894AC000000040120C52C0000000C089974AC000000000DE2952C00000004075A94AC0000000409E1952C00000000028C54AC000000040F04D52C000000040959D4AC000000000312D52C00000000083A54AC000000080C13252C0000000C0D3964AC0000000C0CB2952C000000040CF924AC000000000F73B52C000000080A78D4AC000000080553D52C0000000C0C26D4AC0000000800B2E52C0000000C0805F4AC0000000006BDE51C00000004011514AC0000000C0253352C0000000C015454AC000000080873952C00000004012504AC000000000382B52C00000008056544AC0000000C05F4052C000000080556D4AC000000000C63E52C00000008076884AC000000040DF5C52C000000080DA804AC0000000400A4F52C000000080E2714AC0000000C0046452C00000004095654AC000000000A43852C0000000C0FD414AC000000000296C52C000000000CD5C4AC0000000000F6352C000000080FA444AC0000000404B6E52C0000000402A034AC000000000F65452C0000000809F1C4AC000000080453F52C000000040C8084AC0000000402A3752C000000040D0214AC000000080B12C52C000000000DEFD49C000000000842452C0000000406D284AC000000080903952C000000000B43A4AC0000000006A1F52C000000080D1284AC000000080021E52C00000008003E549C000000080974F52C0000000402ABB49C0000000C0E42352C0000000C00DE449C000000080025252C0000000C01DCE49C0000000C0253B52C0000000C081EE49C0000000402A4F52C000000040850B4AC000000040BF5852C000000040E9D349C0000000C0265252C000000040D7134AC000000000E66252C0000000F037074AC0000000008C5D52C000000000F7D749C000000040F97952C000000040AECF49C0000000403A7952C0000000405CAF49C0000000C0466652C0000000C025CF49C0000000008C6D52C000000000729449C0000000C02D9052C0000000406D7849C0000000F8D46152C000000000735B49C0000000C03F6452C0000000006A3349C000000000188352C0000000C0EB6949C000000080C19252C000000080B93D49C0000000809F7852C000000080FA4449C00000004064AC52C000000000071A49C0000000006A7752C0000000409E2549C000000040D79752C000000000E6FE48C000000000A47852C0000000C0E30849C000000080D19452C00000000049D048C0000000C0996D52C0000000C0ECE048C0000000C0258752C0000000C079BD48C0000000F8627552C0000000C0BB8348C000000000EE9752C000000070B8B648C000000040C89C52C000000000F76748C0000000C0E48352C000000000E65E48C0000000409E9952C000000040A64E48C0000000C0FC8252C0000000C01D4648C0000000005A8152C000000040F13448C000000080E2A952C0000000000F0348C0000000006A6352C000000080771F48C0000000008C5152C0000000402A0B48C000000000DE6952C0000000C0A9F347C000000040224E52C000000080240048C000000000076E52C000000080A0C347C000000000CE7B52C0000000C068EC47C00000008077AF52C000000080A0DB47C0000000C0A18252C0000000801CCF47C000000000DEA152C00000004009B847C000000000CE7B52C0000000809F8447C000000000F69052C0000000408D6447C0000000C0E3C052C000000040096047C0000000804DBC52C000000000523847C000000000E7E952C0000000C0EB6147C0000000C06FDA52C0000000C0897747C0000000C0EBED52C000000000D65C47C0000000801C9752C00000004043E546C000000080038952C0000000C025E746C0000000805D7E52C000000000200C47C0000000005A8552C000000080D21747C000000080F29352C0000000C0E41F47C000000000A59F52C0000000405B1847C000000040D09552C000000040192247C0000000C02E8352C000000000081947C000000040A67652C000000000722C47C0000000807F7852C000000000101247C000000000287152C000000080C12647C000000040AE7F52C0000000C0DB4747C0000000F8D47552C0000000C0604B47C0000000803C5B52C000000080870947C0000000C0366C52C000000080DA2847C000000040746A52C00000004096FC46C0000000C0A94B52C0000000C070D546C000000038956552C000000000CEE346C000000000FF6052C0000000803DBA46C000000040F13452C00000008014B646C0000000C09A5C52C00000000084A446C000000040115952C000000000837D46C0000000C01E4952C0000000C0E37846C000000000083152C0000000406D6046C0000000004A2752C000000000843C46C000000080865252C000000000621246C000000040223652C0000000006AE345C000000000734752C00000000049B845C0000000C0B22F52C000000000308645C000000000183752C000000080874945C0000000803D2252C000000000934745C0000000803D3652C000000040D72345C000000040F81A52C0000000C0FD3945C0000000409E1D52C0000000804DFC44C000000040013752C00000000017F444C0000000C06F1652C00000004085D344C000000040D71352C000000080C9B744C0000000C0912452C00000008098DA44C000000040963C52C000000000DEBD44C000000000084D52C0000000C070E544C0000000C0047052C0000000C09AE044C0000000407C5F52C0000000C0AAC244C0000000F89B7752C0000000C0C2BD44C000000040AE7F52C000000000297C44C0000000803D4E52C0000000C015B543C0000000802C6952C000000000B49A42C000000000294C52C000000000AC9142C00000000052DC51C0000000C0EB5140C00000008003ED51C0000000C0FCC23EC0000000406BD251C0000000409EE53DC0000000F862E151C00000000052F83CC0000000404BBA51C000000000389F3BC000000040BF9C51C0000000805E5D39C000000000089951C0000000C0DB8F37C000000040D7A751C0000000C0267E37C0000000006A8351C000000080F76C35C000000080F39951C0000000403A5932C000000040DF7C51C0000000C0263E32C000000080FB5F51C0000000005A8131C000000080F35E51C000000000B4A231C00400000000000000728452C000000040C80047C000000080868A52C0000000807E1147C0000000809F8452C000000000840C47C000000000728452C000000040C80047C00400000000000080A85852C000000070B85E4AC000000000FF5452C00000008087594AC0000000C0795952C0000000C0C25D4AC000000080A85852C000000070B85E4AC0
34	Cayman Islands	0106000020E610000003000000010300000001000000040000003ACEFBFF384654C00429EB37134F334014ABCDFFAB5954C09C74B0FECF4933405891D101495054C01C83DC45985A33403ACEFBFF384654C00429EB37134F334001030000000100000004000000A4CE6A813D0654C0D440F33977A73340FAF63C7FDA0454C074069B3A8FB2334018B7D100DEFD53C0040341800CB53340A4CE6A813D0654C0D440F33977A7334001030000000100000004000000D0DCD1FF72F753C06C37177FDBAF33403ECBBA7F2CF953C0C43C80457EB13340A8B9A3FFE5EE53C02C861DC6A4BF3340D0DCD1FF72F753C06C37177FDBAF3340
39	Costa Rica	0106000020E61000000200000001030000000100000006000000EC9925016A4755C03051BD35B02524403AD13C80454B55C038F2ECF2AD2724406EEBA7FFAC4C55C050E2AC889A382440F296E4805D4A55C0D0955D30B83E24406E1E87C1FC4655C0E0AC33BE2F362440EC9925016A4755C03051BD35B0252440010300000001000000170000002647C8409E4555C0200D36751E052640D6E5948098FA54C0082C9D0FCF6A25409C7422C154E954C0889BC58B85D92540A244847F11A454C068687748312023406AF46A80D2BB54C05845B9347EF122407C9F38807EAD54C038F52D73BADC2140B2C2F4BD86B954C0C00AB77C240D204014B7D100DED554C0400C04013274214058492BBEA1D254C0F8EB6AF294BD20406AF12900C6EE54C0E889592F862A2140A8BCE47FF2E754C020AB24B20F12224078785DBF602755C040FBAF73D32623407C785DBF602F55C0586002B7EEEE23401284F23E8E4F55C028E92972886824405A492BBEA14E55C0A0035ABA822D2440323BC43F6C3955C0001B4982709D2340EA66463F1A4955C080B60F79CB2D234016A20A7F866A55C020B4E73235D123409429ADBF257755C040240C0396BC2440869CF7FF716855C010261B0FB640254078751C3F547A55C0D05758703FC825409853C900506C55C0C000A777F12626402647C8409E4555C0200D36751E052640
43	Cook Islands	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
44	Cyprus	0106000020E61000000100000001030000000100000007000000F46393FC88D340402E35423F53AD4140846308008E4B41402A172AFF5AD84140D4FA5B02F0F540407E992842EAA24140B46BED7DAA0A41405634D6FECE7A4140ACBCE47FF2834040B22E6EA3014841402CE78BBD17234040AA68ACFD9D854140F46393FC88D340402E35423F53AD4140
45	Denmark	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
46	Djibouti	0106000020E6100000010000000103000000010000000A000000FCFCBE7FF36E454050530438BD2B2740CCB8A981E69F454068B8ACC266F026402C35B401D87845400089B48D3F012640DC031F8315E544409023F3C81F04264084A2EBC20FEA44408814AE47E17A2740844B00FE29334540307D5A457FF028401421CB82898F4540A86BED7DAA6A2940B49ECC3FFAB44540286893C3271D28405C465C001A414540703579CA6A222740FCFCBE7FF36E454050530438BD2B2740
47	Dominica	0106000020E610000001000000010300000001000000040000007CA279008BAE4EC0789E077767652E4078B74082E2B94EC058DF6B088E432F407C7B9E3F6DA04EC08888450C3BEC2E407CA279008BAE4EC0789E077767652E40
48	Dominican Republic	0106000020E610000003000000010300000001000000040000001AC3D50110E251C054D026874F8A3140323BC43F6CE151C084035ABA829D3140A48905BEA2DD51C0941A3048FA9431401AC3D50110E251C054D026874F8A3140010300000001000000040000002E508BC1C32451C0CCA9F23D23213240BC559E40D82E51C0948D2441B81E3240566AF6402B3251C04CB81E85EB3132402E508BC1C32451C0CCA9F23D2321324001030000000100000012000000E86987BF26B251C06CB3CEF8BED8334046BC75FEED7B51C0A415E0BBCDAB3340786F9A3E3B7051C01C068200194A3340508B4F01304E51C0ACECF483BA5C33407A7B9E3F6D6851C0F425AAB7061A33402E4A09C1AA2E51C0AC7A32FFE8F3324078B4FF01D61451C07C96E7C1DD9D3240A492C83EC81C51C054E78BBD175B32407C7B9E3F6D7851C0BC4D637B2D783240CEEB1681B1A051C02CD8463CD93132402C0B26FE28AC51C0EC28EB37136F3240EA66463F1AC551C00488BB7A154D3240B861A2410ADB51C00C068200199A314044E9D2BF24F151C0ACD45E44DB093240982CEE3F320052C0B474B0FECF9932402453CC41D0ED51C08417EFC7EDBF3240F090628044F051C044895E46B1B43340E86987BF26B251C06CB3CEF8BED83340
49	Ecuador	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
50	Egypt	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
51	Ireland	0106000020E6100000040000000103000000010000000400000000000040125023C0000000D0719C4A40000000000F7323C0000000904FA24A40000000C0585223C000000010D7A34A4000000040125023C0000000D0719C4A400103000000010000000400000000000080A7ED23C0000000D061024B4000000000F6E823C00000009036F04A4000000080878924C0000000D0CCFC4A4000000080A7ED23C0000000D061024B400103000000010000000400000000000080870921C0000000D0697B4B4000000040091821C00000005087814B40000000402AFB20C000000010537F4B4000000080870921C0000000D0697B4B40010300000002000000250000000000008024A01DC0000000D0067A4B40000000C0A25120C00000009091384B4000000000DF3C1EC0000000903F104B4000000000931F1CC00000009079354B4000000000621119C000000050C70C4B40000000805E0D18C0000000D0F5784A4000000000C77119C000000050B8164A400000008098FA1BC00000001032244A40000000C0E47722C0000000D082BD4940000000808FA223C0000000D007B9494000000080341223C00000001000E0494000000040D74324C000000050F2CB494000000040AE2723C0000000D0A4EF4940000000005CAD24C0000000D036E4494000000080FB8323C00000009005134A4000000080F2EB24C00000001053174A40000000C0FCA221C0000000D030554A40000000806EDF23C00000009025474A4000000080D9E121C000000010D0A14A4000000000075A24C00000001032B44A40000000806E1F23C0000000500BEE4A400000008090E123C000000010F8EE4A40000000C0579323C00000009091F84A4000000000210324C000000090041C4B4000000040B73F24C000000050560C4B4000000040753924C000000090701D4B40000000807EF120C0000000D00E234B4000000000305621C000000090BA2C4B40000000406D6020C0000000101A514B4000000000079A21C00000009088584B40000000808FA220C000000010F08D4B400000008047A11EC0000000D020A34B4000000000BEB91EC0000000D062794B400000008057931DC00000009091B04B400000000007BA1BC0000000D02F9E4B400000000091021DC00000005009894B400000008024A01DC0000000D0067A4B400400000000000040B7DF20C000000090E3784B40000000C091E020C000000090467A4B400000004064E820C0000000503D7A4B4000000040B7DF20C000000090E3784B40
52	Equatorial Guinea	0106000020E6100000030000000103000000010000000400000000301004C8901640C00F8B187698F7BFC0EC832C0B761640C0CC9541B581F7BF804F95EF19891640802EA2ED98BAF6BF00301004C8901640C00F8B187698F7BF01030000000100000007000000A032384A5E0D2440C02B7FBE2D58014070B7088CF5AD2640E0F755B950590140A0E4D4CE30B5264080C6866EF607F03FA08905BEA29B2340C054ABAFAE0AF03F90129F3BC1B6224080C0D2F9F0ACF23F4024F0879F9F2340809BADBCE4BF0240A032384A5E0D2440C02B7FBE2D58014001030000000100000005000000E01F990E9DB621404077F17EDCFE0B4060D6A88768E4204000AC24B20F320A40A0EA56CF495F2140E0717495EEEE0D40E01EA33CF3EA21402060200890A10D40E01F990E9DB621404077F17EDCFE0B40
53	Estonia	0106000020E61000000600000001030000000100000004000000B8ED26F8A6FD374036D505BCCC0C4D4020085740A1F237403235B401D8124D40C06D50FBAD0538403ED13C8045124D40B8ED26F8A6FD374036D505BCCC0C4D4001030000000100000006000000C0ED26F8A6FD3640B2BF97C2834C4D4040ED0DBE305537402A02D53F88384D4000FE0E4581FE3540CEE506431DF64C40B8E7A4F78D3336400AA304FD85124D40003C1405FAD435400ECADFBDA3404D40C0ED26F8A6FD3640B2BF97C2834C4D4001030000000100000004000000F81A4982705D37405E16BEBED6434D40408FE046CA0E37409296E7C1DD4D4D40C8191879593F37406679C9FFE4554D40F81A4982705D37405E16BEBED6434D400103000000010000000400000070BB5F05F8463740AAB05241457B4D40407B4B395F1C3740CEE847C329834D40A80DC00644643740766F0C01C07F4D4070BB5F05F8463740AAB05241457B4D40010300000001000000040000003039D384EDBF36400E00000000804D40F0420246970B3740B283F57F0E6B4D404834D6FECE0A36402AD5777E51784D403039D384EDBF36400E00000000804D400103000000010000001000000050D2C43BC0C73940B29E3E027FD04D4050431B800D043C40CEEEC9C342BD4D405094BDA59C2B3C403A7AFCDEA6A74D4090A99F37156D3B403AEACC3D24684D40E0F06778B3D23B40E258FB3BDBEF4C40C82E35423F5F3B4092C3D2C08FC44C4088992842EA823A408236AB3E57C34C40C8622AFD844B3940AED11DC4CE0A4D4000E57E87A2503840B6E68EFE97EF4C40D031AEB8388E3840FED8243FE2294D4008A304FD85BA3740A6BC5642772F4D403899D53BDC7E3740CEB56801DA584D409021E4BCFFDF37405EDA1B7C61624D40F04CF73AA97B37402E0B98C0AD674D4030145B41D3763740A6B915C26A9A4D4050D2C43BC0C73940B29E3E027FD04D40
54	Eritrea	0106000020E610000003000000010300000001000000040000008C4B00FE290B4440C84B546F0DB42F40FCCC203EB0354440C8116DC7D4252F40346893C327FD4340E8285C8FC2352F408C4B00FE290B4440C84B546F0DB42F40010300000001000000040000007C60C77F810E44401C1286014B0E30402C1A6B7F67FD43404C6C06B820033040DC7954FCDF034440FC170802641830407C60C77F810E44401C1286014B0E3040010300000001000000140000008448BF7D1D6643402C6E15C440A7314064F5F23B4DDC4340E8DE52CE172B2E408493A641D1F043402883DC4598FA2E407C96E7C1DD154440481E8A027DF22D40B49509BFD4954440B8703D0AD7432D401421CB82898F4540A86BED7DAA6A2940844B00FE29334540307D5A457FF02840ACCB2901311D4440F028EB3713E32C4074B5C01E13834340482AC764714F2D40E4C1FA3F87394340F8285C8FC2D52C4064888043A8F4424048D6A88768C42D408430293E3EC9424000D655815A342C40DCB5F63E55A54240683F373465E72C407CDFA3FE7A45424018A391CF2B862C40D4EF517FBD384240C0F02F82C64C2E4044232E008D7C4240841A3048FA443040ACBC5642777F424084992842EA123140746D533C2EB64240BC10AB3FC2083140CCF71A82E34C434074696E85B0FE31408448BF7D1D6643402C6E15C440A73140
55	El Salvador	0106000020E6100000020000000103000000010000000400000040BC75FEEDEB55C000AD33BE2F562A40548B4F0130EE55C0C0DB114E0B562A40323201BF46EE55C09076BF0AF06D2A4040BC75FEEDEB55C000AD33BE2F562A40010300000001000000090000006E0F4240BE5556C0000341800CD52C408469183E221E56C0A81B62BCE6B52B40022159C004F055C078A148F773BA2B402E4DD87E32F455C07083F8C08ECF2A40022159C004FC55C0100AF5F411502A40283E05C0782256C088FDD7B969632A40546AF6402B8656C0D09E20B1DD7D2B4074336ABE4A5656C010ECA4BE2CDD2C406E0F4240BE5556C0000341800CD52C40
56	Ethiopia	0106000020E610000001000000010300000001000000270000007CDFA3FE7A45424018A391CF2B862C40DCB5F63E55A54240683F373465E72C408430293E3EC9424000D655815A342C4064888043A8F4424048D6A88768C42D40E4C1FA3F87394340F8285C8FC2D52C4074B5C01E13834340482AC764714F2D40ACCB2901311D4440F028EB3713E32C40844B00FE29334540307D5A457FF0284084A2EBC20FEA44408814AE47E17A2740DC031F8315E544409023F3C81F0426402C35B401D87845400089B48D3F01264084397AFCDE544540B0703D0AD743254034232E008D6C4540001E8A027D7224405CF833BC5901464058B08D78B2032240DCC1FA3F87814740C0656B7D910020401CC022BF7EFE4740A05E0D501A0220404C8BC1C3B4794640C0B0A6B2289C13405437177FDBD74540207497C4599113408C352383DCF34440E0648C0FB3D70F40DCFA5B02F0954440C0D7A3703D8A0F406CD383825264444050431CEBE2261140FCE769C020C3434000A243E048400B403420ED7F800F4340609AD024B1E40C40D4031F831585424040666B7D91801140FC17080264F84140C02BBB60707D1240ACAAD0402CE94140208ECC237F5015403C29B000A6A64140805B94D9208315402C6BD443345A414000ED832C0BB61A402C6211C30EDB4040603465A71FA41E40AC77F17EDC7E4040E05417F032B31F402C172AFF5AA04040382C9D0FCFEA2040DCBB783F6E0F41404021CB82892721408C87A2409F244140102DCF83BB1B2540E4A6B1BD164C41405048FAB48AC625402C29B000A66E4140982FF7C9517825408C5A457F688C4140303F373465A727409CF04BFDBCD9414028C078060D5529402C2FA4C343124240D894BBCFF16929407CDFA3FE7A45424018A391CF2B862C40
57	Austria	0106000020E61000000100000001030000000100000019000000F02B9D0FCFAA2B40D282177D05634840F015A4198B662D4066CA87A06A4A4840D050A4FB390D2E40AAB915C26A8248406010CAFB38F23040CA10397D3D4F48401883DC45982A314032266F809901484068B60F79CB0D31405A34D6FECEDA47400815C7815773304056F833BC59D9474090129F3BC1B63040AA68ACFD9DC5474040CF83BBB38230408218213CDA8047409087A2409F1C3040B25626FC526F474060C554FA09172D407AA86DC328344740B036548CF36F2B40625B3FFD67434740C03E3C4B90E12840129D82FC6C584740D05CA8FC6B4128408E4E417E368047403076C3B645F12440BE22BF7E886F4740707B6649803223408AABCABE2B884740C051BAF42F11234012A8FE4124A3474070B7EBA529222340960B957F2DC5474060B3CEF8BE5824408E4B00FE29A34740B0716F7EC3F42440929065C1C4CB474000013274EC302640064BE7C3B3B2474070E2AC889A7829408E8461C092D7474020E9297288082A400A0C040132BC474090F41439448429405E37177FDB0F4840F02B9D0FCFAA2B40D282177D05634840
58	Czech Republic	0106000020E61000000100000001030000000100000012000000F015A4198B662D4066CA87A06A4A4840F02B9D0FCFAA2B40D282177D0563484090F755B9505929406AFB743C66B6484080027FF8F92F2840C670E7C248294940F0C43BC0939E2C40B677F17EDC864940506552431BA82D40D276137CD36E49400021CB82895730407E87A2409F54494020895E46B134304082AEEFC34136494030F6D03E56A430408696E7C1DD0D4940A8656B7D910031407A9065C1C41B4940A87A32FFE8E33040524F1F813F384940D05D4BC807B93140D67C957CEC284940F817080264A83140B29509BFD40D4940889065C1C4933240FA0241800CF54840D0D90242EBD93240A6AD11C138C248406010CAFB38F23040CA10397D3D4F4840D050A4FB390D2E40AAB915C26A824840F015A4198B662D4066CA87A06A4A4840
59	French Guiana	0106000020E6100000010000000103000000010000000C0000009011178046BF4AC040827005144A1640582250FD83244AC07021E4BCFFBF13405067B5C01E054AC0A0253960575311400418963FDFEC49C030977153039D1240E8A2E8818FD749C020EF1EA0FB2210407C9CF7FF71744AC0E0D153E410910140B870E7C2484D4BC0000EF8FC30A20240ACC8E88024004BC080BDA59C2F960B405067B5C01E3D4BC0C0CDFE40B9FD124054198D7C5E154BC0802CB649456315405C91D10149F84AC0C0934E2498FA16409011178046BF4AC040827005144A1640
60	Finland	0106000020E61000001800000001030000000100000004000000000000A067D53640000000D06AFA4D40000000608F12374000000010BEF94D4000000060E1EA364000000090FCF24D40000000A067D53640000000D06AFA4D4001030000000100000004000000000000E05A7036400000005077FF4D4000000020195A36400000009091084E4000000020C87036400000009047094E40000000E05A7036400000005077FF4D4001030000000100000004000000000000201A993540000000108D0C4E40000000203B7C3540000000D0930E4E4000000060D2A7354000000010E9134E40000000201A993540000000108D0C4E400103000000010000000400000000000020B7BF3540000000D0410E4E40000000A02EB73540000000506E174E40000000A0A1E2354000000010AF164E4000000020B7BF3540000000D0410E4E4001030000000100000004000000000000E08B65354000000090DC164E40000000A0A1623540000000900D144E4000000060B14435400000001012184E40000000E08B65354000000090DC164E4001030000000100000004000000000000A0360036400000009091104E40000000E0FFEF354000000090C2154E40000000E0920F364000000010191A4E40000000A0360036400000009091104E4001030000000100000004000000000000A03ED93940000000D007194E40000000A080CF394000000010221A4E40000000E0FFDF394000000090051B4E40000000A03ED93940000000D007194E4001030000000100000005000000000000E00ED3364000000090151D4E40000000E02E7836400000001000004E40000000E02073364000000050F21B4E40000000A07896364000000090EB194E40000000E00ED3364000000090151D4E400103000000010000000400000000000060023E3640000000902E174E4000000060C037364000000050FB1B4E40000000A0604B364000000050D21F4E4000000060023E3640000000902E174E4001030000000100000004000000000000E09B573640000000103B244E40000000A0A2113640000000D061224E40000000A09A1836400000005065274E40000000E09B573640000000103B244E4001030000000100000004000000000000202262364000000010E8244E40000000604553364000000010D82A4E4000000020197A3640000000106C294E40000000202262364000000010E8244E40010300000001000000040000000000006097FB3540000000507E294E40000000603DCA354000000010AE2F4E4000000060B8CE354000000050973B4E400000006097FB3540000000507E294E4001030000000100000005000000000000206DC0354000000050C93F4E40000000E037AF354000000090F4394E4000000060E1BA35400000005098424E40000000E069C3354000000050E1424E40000000206DC0354000000050C93F4E4001030000000100000004000000000000A0BB7B35400000005098424E4000000060B86E3540000000D01F3C4E40000000E06A523540000000D082454E40000000A0BB7B35400000005098424E4001030000000100000004000000000000203254354000000010953D4E40000000209D463540000000D0303D4E4000000020193A354000000050B8464E40000000203254354000000010953D4E4001030000000100000004000000000000A04F4A3540000000505D4E4E40000000E0064A354000000090DB474E40000000A0D336354000000010534F4E40000000A04F4A3540000000505D4E4E400103000000010000000400000000000020D7533540000000D048704E400000002011413540000000D0BC7A4E40000000E0725B35400000005002764E4000000020D7533540000000D048704E4001030000000100000004000000000000208D1435400000009004A44F40000000605E6D35400000005035994F40000000E0373F35400000005086924F40000000208D1435400000009004A44F4001030000000100000004000000000000204B2E364000000090F4A14F4000000020740A3640000000D049A74F40000000A0473136400000005035A94F40000000204B2E364000000090F4A14F4001030000000100000004000000000000E0C55235400000005003A54F40000000A0603B3540000000D0ABA94F40000000609061354000000090A9AB4F40000000E0C55235400000005003A54F4001030000000100000004000000000000E0A4DF36400000005066E64F4000000020E0AB364000000050B0E54F40000000605DCE3640000000903FF04F40000000E0A4DF36400000005066E64F4001030000000100000004000000000000E028BC3840000000C8713C5040000000203A8D38400000008899415040000000E0F5083940000000884F425040000000E028BC3840000000C8713C504001030000000100000004000000000000205476384000000088E3705040000000A0DB6F3840000000084371504000000020C880384000000088F4715040000000205476384000000088E37050400103000000030000003C00000000000020742A3C40000000C8617A5140000000A0152D3D4000000048A868514000000020BFC83C4000000088464A51400000006014F53C40000000C84D435140000000E0936E3C400000008867395140000000E00FD23C40000000480B365140000000A01E753C40000000480B225140000000607EB13C40000000C8A30C51400000002053073E400000004876EC50400000002033133D400000004855B95040000000A058223E40000000C8066E5040000000A0A2D13D4000000008D0695040000000A0FCA23D4000000048653B504000000060FB933E40000000082B0E5040000000204BFE3D40000000902EDF4F4000000020C4963F40000000900B754F4000000020CECE3B4000000090F0454E40000000E0497F3A400000005035394E4000000020BFA83A4000000050E1524E400000002085EB3940000000D0EE1E4E40000000A0E3E83640000000100AE74D40000000209D563740000000508F024E40000000A0DBDF364000000090A1124E40000000E04116374000000090682C4E40000000204B0E3740000000103A2D4E40000000E0ABA93640000000D0711C4E40000000203393364000000050F31A4E40000000207D723640000000D0491F4E4000000060D9A13640000000102B324E40000000E0CD5B354000000090A9534E40000000A005AB35400000005002C64E40000000A091103540000000505D4E4F40000000E0A4AF35400000001033834F40000000606E7F354000000050E19A4F4000000020545636400000009005A34F4000000060243036400000005045BB4F40000000A0A2513740000000D0C5F24F40000000A0E4573840000000C88221504000000020CF8A3840000000085C335040000000207D723940000000081A3D5040000000E0924F394000000008B6605040000000A04EAB3840000000C8E6695040000000206DB03840000000C85979504000000020C12A384000000008197450400000002075A9374000000048FB935040000000A0FD013840000000483CB35040000000A058923740000000C806CA5040000000208DC4374000000088A1DA5040000000605D6E374000000088CBDD50400000006086AA37400000004844FC5040000000A025CF3540000000C883245140000000E0B794344000000008DC435140000000202252354000000008DF54514000000020F9653640000000C8822D5140000000A0F4F937400000008847355140000000E056EF3840000000082C25514000000020D8C23940000000884E3F51400000002022F23940000000C8176B51400000002033733A4000000088577B514000000020742A3C40000000C8617A514004000000000000605EAD394000000050141E4E40000000E0A48F3940000000D006224E40000000201A99394000000050981A4E40000000605EAD394000000050141E4E400400000000000020B1B4374000000010AFF64D40000000E0CF89374000000050EAFA4D4000000060B85E374000000050A8F44D4000000020B1B4374000000010AFF64D40
99	Lao People's Democratic Republic	0106000020E6100000010000000103000000010000002D0000009AFF907EFBE25A40B8B67EFACF6A2D4026085740A1B65A40D8E847C3299B2C40D2A623809BA25A4068A9BEF38B322D40FEC3961E4D805A40805985CD00BF2C403AA79201A0835A40D8B0A6B228DC2B403E9ECF807A4D5A4068390A1005B32C407E54C37E4F625A40E094490D6D202D407E93A641D1685A4018F86EF3C6512F40D2D38041D22F5A401C6E15C440873040C63D0801F92D5A408418213CDA803140CE94D6DF12FF59404C55A181585232409A1ADA006CD95940CCF44BC45B6F32407E6F0C01C0AB5940CCD90242EBD131405E9D9CA1B885594054323A2009373240FEEA71DF6A4A5940DC52793BC2753140E61E12BEF73A5940A4ABAE43359131403E80457EFD515940FC38D384ED8F3340F24EB0FF3A205940A4F27684D3863340BA28B34126255940145BD07B632834407E758E01D90559408C30293E3E593440823F6EBF7C4959403C83DC459892354016A27C410B52594064499D80262E354042984D8061725940E45B3CBCE7243540B2716F7EC3645940A4A17F828B3536403E8F8AFF3B6F5940C40A7F86377F3640AE80B4FF01895940CCDCD1FF7265364096F3FE3F4EAB59405CBC9179E4A73540123FFF3D78BE5940D47344BE4BBD3540FABA0CFFE9CA594064B3CEF8BED834407E39ECBE63EC59405C4F1F813FA83440960E0F61FC065A40A4073E062BFA34402EED0DBE30295A40EC5D4BC807A934406E9DF17D71185A40C4F92AF9D8713440AE6BED7DAA3E5A400C94BF7B470134406EAF3E1EFA285A407C0C1D3BA89C3340FAB73D4162025A40BCF529C764B13340868159A148F8594054C763062A4B3340E6395B40684C5A405CE09D7C7AA43240166F9D7FBB4B5A40B468ACFD9D553240A67A32FFE8A35A40AC0A7F8637FF304022179CC1DFAB5A40E4EEC9C34275304052103CBEBDDD5A40FC2B2CB81F143040428F8AFF3BCB5A40B8669DF17D912F40BEE00CFE7EEC5A40986BED7DAA8A2E409AFF907EFBE25A40B8B67EFACF6A2D40
100	Lebanon	0106000020E610000001000000010300000001000000060000004456293DD3CF414012DBDD03749F4040543A58FFE78C41400EDFA63FFB8B4040ACBF97C283FC4140AE984A3FE1524140AC984A3FE13A42405A73B9C1505141405C16BEBED64F42402AF04E3E3D1A41404456293DD3CF414012DBDD03749F4040
61	Fiji	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
62	Falkland Islands (Malvinas)	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
63	Micronesia, Federated States of	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
64	French Polynesia	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
101	Latvia	0106000020E61000000100000001030000000100000012000000E046753A901135407A6F0C01C0374C40E0CDFE40B90D3540AA83F57F0E6B4C40F82CCF83BBBB354032D8463CD9C94C40F8907EFB3A9C36407E93A641D1E04C40D82E6D382CC937407E2DE8BD317C4C40E83730B9516838408218213CDAA04C4000E57E87A2503840B6E68EFE97EF4C40C8622AFD844B3940AED11DC4CE0A4D4088992842EA823A408236AB3E57C34C40C82E35423F5F3B4092C3D2C08FC44C40685B238271DC3B40FA298E03AFA64C4058E960FD9FB33B405625034015754C40585ED6C4022B3C408EAE0B3F38134C40E89CD843FB9C3A40269947FE60D64B40180000000000394026B7ED7BD4254C4080C93846B2233640B6AD11C138364C40A0B1683A3B0D3540EA57E542E5094C40E046753A901135407A6F0C01C0374C40
65	France	0106000020E61000000A00000001030000000100000004000000C0B3CEF8BEF82240628E0244C14E4540805A99F04BFD2240925182FE424D454000B937BF61EA22405A55A18158524540C0B3CEF8BEF82240628E0244C14E45400103000000010000000800000060895E46B1E4224026DB87BCE5564540A09885764E1B2340E2F19881CA0E454060240C03965C22400A2A8E03AFAE4440F04B546F0D942140D6BB783F6EC7444030FBAF73D32621405A465C001A314540805FE97C78962240A65FE97C78564540F0716F7EC3B422405601F73C7F80454060895E46B1E4224026DB87BCE55645400103000000010000000400000000EE3D5C721CF3BFDE0F238447E94640801D4E603A6DF6BFBA5FE97C78064740002FA2ED98BAF3BFAADDAF027CFB464000EE3D5C721CF3BFDE0F238447E946400103000000010000000400000000F5BA45602CF4BF86423D7D0414474000B58D3F51D9F8BF8E5704FF5B1F47400002ECA35397F7BF262F3201BF20474000F5BA45602CF4BF86423D7D0414474001030000000100000004000000806AED7DAA2A02C03A2F3201BF58474080FDD2A23EE902C05AF833BC5959474000AD47E17A1403C086397AFCDE5C4740806AED7DAA2A02C03A2F3201BF5847400103000000010000000400000000E370E6579301C03E6BD44334824740005C8FC2F52801C026DEC83CF2734740809CF3531C4702C0BAE67283A182474000E370E6579301C03E6BD443348247400103000000010000000400000080C645B5888808C02A6E15C440A7474000EB1A2D07BA09C08E8D2441B8A647404015DBA4A2110AC02EEACC3D24B0474080C645B5888808C02A6E15C440A7474001030000000100000004000000801E85EB513814C0D2066003223A4840A0137CD3F48914C0AA6BED7DAA3A4840403201BF464214C0BA9509BFD43D4840801E85EB513814C0D2066003223A48400103000000010000000400000000758D96039D0CC036DB87BCE56648404022A81ABD9A0CC07E21E4BCFF67484040CC9541B5810CC03220ED7F8067484000758D96039D0CC036DB87BCE56648400103000000010000004500000040951282555504405E2B137EA98B4940605C8FC2F5A81040D20CE2033B2449404048A5D8D19810406E2DCC423BFD4840004A9BAA7B541340A6E331039515494060704221027E134036E44A3D0BE64840E05E0CE5443B1740CA707500C4C54840C05E46B1DC72194036923D42CDBA4840C0B0E07EC07320407E5A2904727B484000301004C8501E40C25626FC520F4840402235ED625A1E4046959A3DD0CA4740408FC70C54F61B405A0ABABDA4BF4740009F20B1DDDD17406234D6FECE1A4740C0A8C5E0612A1B407E8461C092374740A0EDB5A0F7261C403AF38FBE49F7464080F1113125321B40F67B9BFEECE34640C0B950F9D7821C402AE109BDFEA04640A0798D5DA27A1A4002068200198E46402095490D6D201C40B6B915C26A6A464020D48041D2E71B40B259677C5F24464040C422861DA61E408E96E7C1DD15464020F52D73BA1C1E402E3B3602F1E44540E0723106D6C11D40F67B7F83F6E045402006820019AA1D40B2E67283A1E245406090F469158D1D40DAD38041D2DF454040471FF301911D40CEA6954220DD45404020B75F3EA91840AA5FE97C7886454080F2052D242014402E6E15C440C7454080DAFD2AC0B70F4086CC07043AC54540404C72C0AEA60840D6F71A82E3884540C0C57762D66B09402E594E42E9374540006BC020E993FB3F7EABAE43354145408011AAD4EC81FC3F46FBCA83F448454080A5A7C82122F73F060341800C4D454000F0E2FDB8FDE1BF8A423D7D04644540002B93E1787EFCBFDE8558FD11AE45400068C020E993F0BFAADA6E826F56464000870E812301F4BF32D505BCCC54464000E6F7FD9B57F1BF524F1F813FC8464000F2BA45602CE1BFBAE67283A1724640003C9CC074DAE8BFD282177D05BB4640003C9CC074DAF3BFAE74B0FECFD94640003556629E15F1BF36F6D03E56F4464080A17F828BD5F1BF46404CC285284740C0A339B2F20B01C03A14E97E4E6B474000D56CE525BFFFBF825A457F68844740405B5837DE5D01C07E4E417E36904740C09EE925C61201C00AC79E3D97A347400016080264A8FBBFDAFD9C82FC9A4740C0B7E7F9D30600C08E18213CDAA8474000A8C0C9365002C0D2C43BC0939E474000FCA5457D5204C0CE7FD6FCF8A54740C0CEF9298EE302C0A6E0F08288C04740C03656629E9505C0AEC2D84290D14740803ADD79E2D908C00ABEDBBC71BC4740207592AD2E7711C00EDC65BFEEE647402002B9C491E712C062EB19C231054840C0B3C9E193BE10C066FB743C66264840E00F2219721C13C086ABAE433541484000C2BE9D44C409C0E2BB783F6E6F484080573508737B05C07E4E417E3640484080A9ED26F8E6F5BFD6B837BF61524840808F8B6A1111FFBF4E888043A8DC484000EB1A2D073AF4BF868461C092D7484080FCA5457DD2F1BF528E0244C1AE48400016F92EA52EDB3FAA74B0FECFB94840005871C79BFCB23F5E793BC269C3484000368DEDB560F73F2A38F581E40F4940000200000000FA3F3A172AFF5A70494040951282555504405E2B137EA98B4940
66	Gambia	0106000020E61000000100000001030000000100000010000000D876A1B94EBB30C0F0B628B341E62A4000DCF3FC693330C07018213CDA802A4050A01683872930C0A86ABB09BED92A40F016D68D77972EC0102DCF83BBFB2A40A0389CF9D52430C018E9297288E82A4078E15CC30C6530C0180F45813EA92A400054C6BFCF9030C02069C537142E2B40A0415F7AFB232EC0C8AD65321CA72B4020529ACDE3982BC0F009F5F411D02A404077BAF3C4B32CC0A06ABB09BE792A40E004508C2C392EC070C1E10511312B40D0963AC8EB912EC0C06E2EFEB6BF2A4080583508739B2FC0E0AA24B20FB22A4030A35703949E2FC008F86EF3C6512A40A86A494739C030C048062B4EB51E2A40D876A1B94EBB30C0F0B628B341E62A40
67	Gabon	0106000020E6100000020000000103000000010000000400000000000040FB03224000000000A491E8BF00000040B1E42140000000001011E5BF000000C06903224000000000182AE3BF00000040FB03224000000000A491E8BF01030000000200000023000000000000C0160C29400000000045440240000000C078962A4000000000134F014000000040A25F2A4000000000428FF33F00000040B6602C40000000002243F63F0000004075F92C40000000004C3CED3F000000C058B22B4000000000106CC9BF0000004087092D40000000004C7EE3BF000000C004DC2C40000000004444FEBF00000040BF382C4000000000C7F103C0000000C041862B40000000000BB600C0000000C02EF72A4000000000008003C0000000C0C5002A4000000000FEF002C0000000C0CC4C294000000000F628FDBF000000C0C3F4284000000000269E02C000000040F925274000000000AAAA02C0000000C006DA27400000000076180DC0000000C06FFE264000000000390E0CC0000000C00448264000000000F7660FC0000000C0D3662340000000007F9003C000000040D842244000000000F62804C0000000C0053B2340000000006A0303C00000004053F721400000000026BFF3BF000000401C07234000000000F28BF9BF00000040856B214000000000FC83E4BF000000401C072240000000009C36EABF00000040BF9822400000000060C9D7BF000000C0EBB1224000000000583CD73F000000C09BD723400000000030B7C73F000000C0729B2240000000001CE8E03F00000040333323400000000088CADE3F0000004023212340000000003475EF3F000000C0A29B234000000000AE0AF03F000000C030B5264000000000F607F03F000000C0F5AD26400000000051590140000000C0160C294000000000454402400400000000000040E01B2340000000008890D13F00000040C116234000000000783DD23F000000407C132340000000005855D13F00000040E01B2340000000008890D13F
68	Georgia	0106000020E61000000100000001030000000100000012000000CCC4AD8218C644400E3C3080F03345402499D53BDCB64440F2FC3042785E4540AC776341610044403EC269C18BB04540AC1D37FC6E2044401AA2EE0390CA45407C724D81CC6C45408AFD497CEE964540340ED940BAF44540FE083543AA4A45409CA70183A47746406673B9C1506145408CF37002D3394740F2D286C3D2F24440DC3AE3FBE21847405A70EA03C9D744405452D2C3D05847407EDF313CF6A7444004093543AA424740AE98BC01668644408484D38217AB46405A4CDE0033BB44403CDA71C3EF82464082A301BC05A644402C7DE882FABA4540A65C8C81758E4440D4D90242EB69454026BA2EFCE0CA4440847214200AC444406A94675E0EC34440D4D3F20357E34440424F9143C4EB4440CCC4AD8218C644400E3C3080F0334540
69	Ghana	0106000020E6100000010000000103000000010000001D00000000F4599E0777E43F20E7FC14C761174000241631EC30E53FE0E3A25A4404174000360F60915FD03FF0A4A2B1F6071740005F44DB3175E9BFA013B35E0CD5144080EB884336D0F9BF10B6F63E55151440C0C0C8CB9A7800C0C059677C5FEC1240002DE92807D308C040C3D50110571440C05E7AFB73D108C070C381902C7014404003745FCE6C07C0005C9198A066144080B91457951D06C010D253E41051164080EFA1444BFE09C030AB24B20F721A40C0A9ED26F8E603C090CDE50643652040404ED367077C05C05850C3B7B0F62240805A9A5B21AC06C0F8B9BE0F070126400033A14962C9E3BFD8D03FC1C5D22540007817B6662BC3BF286002B7EE462640006A4293C492D73F385A80B6D584244000A8703D0AD7CB3F0806820019EA224000D911876CA0E13F18EFAB72A1D22240003402F1BA7ED83FA87878CF8185214000D35D126745E73F58A7CAF78CA4204000CDCCCCCCCCE03F2079E75086CA1B4080804754A82EF33F70F9D687F5661840004B72C0AE26E63F2070422102FE16400098E4805D4DE43FD03C0FEECECA1740007C53910A63E03FD0113125923818400014100533A6CA3F90EFFD0DDA5B184000F29716F549DF3FA0FBAA5CA82C184000F4599E0777E43F20E7FC14C7611740
70	Grenada	0106000020E61000000300000001030000000100000004000000F0E7F7FD9BDF4EC0F8955D30B8FE274078751C3F54CE4EC0B88EC70C547628400CDF347D76D04EC058E2AC889A182840F0E7F7FD9BDF4EC0F8955D30B8FE274001030000000100000004000000ACCE6A813DCA4EC0A05626FC5297284000DCF3FC69CB4EC040E2AC889A98284074E49D4319CA4EC0589E077767A52840ACCE6A813DCA4EC0A05626FC52972840010300000001000000040000004C552FBFD3B64EC0D05758703FE82840F8E7F7FD9BBF4EC0586C06B820E3284000E8F7FD9BB74EC0506002B7EE0E29404C552FBFD3B64EC0D05758703FE82840
71	Greenland	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
72	Germany	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
73	Guam	0106000020E610000001000000010300000001000000040000007B6CCB80B31662400051DB8651782A40DDFD2AC0F71462400807B47405DB2A40A780B4FF011C624060AD4CF8A54E2B407B6CCB80B31662400051DB8651782A40
102	Belarus	0106000020E61000000100000001030000000100000019000000E89CD843FB9C3A40269947FE60D64B40585ED6C4022B3C408EAE0B3F38134C40B804FD851EED3E4086C6850321CD4B409809DCBA9B073F405A0438BD8B854B4008857AFA08C83E40AEE3310395654B40B88636001BD83F405E4F1F813F084B4028C9E53FA4C33F40CE8E8D40BCE64A40AC77F17EDC5E4040B2B0524145BB4A4038F6D03E56443F40E2E847C329834A40E8CABDC0ACC83F402EB7ED7BD40D4A4028FD4CBD6EF13E407E5A290472094A40988EC877298D3E4072D05E7D3CA04940004AB6BA9CC63940CEEB884336F8494038809BC58B653840525E64027EF149402815713AC99A37409EA17F828BC3494020FF93BF7BA33740D68BDAFD2A0A4A4038C286A7572A37401639B69E21244A408018213CDAF0374056EFE2FDB85D4A4030E0F3C308813740BEEFDFBC38F94A40F05D4BC807C93940A64412BD8C144B4090A86DC3288C39406207793D982A4B40583D997FF4C939405E58E201656F4B40D0F92AF9D8D13A40FEDEA63FFBA34B4020895E46B1743A40A64DD53DB2AB4B40E89CD843FB9C3A40269947FE60D64B40
103	Lithuania	0106000020E61000000200000001030000000100000005000000009A417C600B3540EE73D2FBC6A94B40B0A432C51CFC3440C6DA8AFD65A34B400097E4805DF134407E309B00C3A44B4050C554FA09173540FAC9518028DC4B40009A417C600B3540EE73D2FBC6A94B400103000000010000000F000000180000000000394026B7ED7BD4254C40E89CD843FB9C3A40269947FE60D64B4020895E46B1743A40A64DD53DB2AB4B40D0F92AF9D8D13A40FEDEA63FFBA34B40583D997FF4C939405E58E201656F4B4090A86DC3288C39406207793D982A4B40F05D4BC807C93940A64412BD8C144B4030E0F3C308813740BEEFDFBC38F94A40B06A65C22FC9364066855B3E922E4B40200B98C0ADD736405634D6FECE724B4038FC523F6F6E35405E4F1F813FA04B403845813E91433540E61890BDDE9F4B40A0B1683A3B0D3540EA57E542E5094C4080C93846B2233640B6AD11C138364C40180000000000394026B7ED7BD4254C40
104	Liberia	0106000020E6100000010000000103000000010000000E000000D04F38BBB59C25C0F0263108AC9C1940009D0FCF12FC26C080AAD55757B51B4020E4D87A868824C0D83CD68C0CFA2040A06B09F9A0F722C0F0EFA5F0A0B12040E096C80567F822C0100C923EAD721D4000F1BA7EC13622C02023DA8EA9CB1C40A049F086345221C070E17A14AEC71E4050A8E0F082F020C090B515FBCB3E1E40607D3CF4DD9D20C0B045B9347E711B4060A2B1F6773621C0B0ACC5A700081A40C023D5777EB11DC0404B3B35975B1740C0025DFB021A1EC00055DFF945691140102DB1321A4922C04084F068E3381440D04F38BBB59C25C0F0263108AC9C1940
105	Slovakia	0106000020E6100000010000000103000000010000000C00000098D711876C403140564CDE00330348401883DC45982A314032266F80990148406010CAFB38F23040CA10397D3D4F4840D0D90242EBD93240A6AD11C138C248401873F4F8BD7933402AD505BCCCCC4840306211C30E133440AADA6E826F964840B8DA6E826F9E35405637177FDBB74840B077F17EDC8E3640D28BDAFD2A8A4840A83D25E7C4263640EACC04C3B934484050465C001AA934402A6552431B48484038D2C43BC0A7324056465C001AE1474098D711876C403140564CDE0033034840
74	Greece	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
75	Guatemala	0106000020E61000000100000001030000000100000011000000B6490C022BA856C0284278B471DC2B401CA88C7F9FD856C0E8E4D4CE30F52B409C53573ECB0F57C098D2DF4BE1192D402A4A09C1AAEE56C0644CDE00331330405891D101499C56C05C28D2FD9C163040C27FBA81029A56C01C83DC45986A3040F8FFFFFFFFDB56C0ECCDFE40B93D3140FC1D1840F8BE56C0CC46753A90413140BE378600E0BE56C0BC65DD3F16D23140682409C2154956C0FC264D83A2D13140FED5E3BED54D56C088A0DE8C9AC72F402A3201BF463A56C018C2FA3F87C92F406A0F4240BE0D56C0D8A16131EA722F40B4C876BE9F4956C058C1374D9F252E4074336ABE4A5656C010ECA4BE2CDD2C40546AF6402B8656C0D09E20B1DD7D2B40B6490C022BA856C0284278B471DC2B40
76	Guinea	0106000020E61000000100000001030000000100000027000000602B2FF99F342BC0E0AE97A60878234090EA1F4432542DC0C84B546F0DF42440C0976C3CD8622DC0D0AA24B20F1226404001124DA0082EC048740AF2B3E92540F04C4A41B75F2DC0881A3048FA042740F0CDE0EF176B2BC0782975C9386E2740E08AE07F2BF12BC0E896C9703C4F28400001158E206D2BC02054FEB5BC5A294090D007CBD8B028C04844BFB67E9A2840A0054B7501BF26C07851F4C0C7D02840D01C588E90A126C0F865A208A90B28409029577897DB25C088B2D30FEA722840000F61FC344E25C0F83AFE0B04C9274080CEA44DD5A524C0606589CE32732840901D5377656723C0A881E673EE0E2840A0643909A54F22C090737E8AE3F8284010FA27B8581121C0C05582C5E1FC2640106420CF2EB720C0204278B4719C2640902094F7715C21C0C06DFC89CAEE2540F0DC2571569420C018634337FB032640E04ECB0F5CE51FC030B709F7CA54244030A01683874920C0607497C45911234060C8409E5DEE1EC0D07F828B152D2240E04F8BC1C3D41FC0A894490D6DA02140E0BE7E880D961EC0F090F0BDBFC12040A07C23BA676520C0101286014BFE2040407092E68FC91FC008A0C37C7909204050A8E0F082F020C090B515FBCB3E1E40A049F086345221C070E17A14AEC71E4000F1BA7EC13622C02023DA8EA9CB1C40E096C80567F822C0100C923EAD721D40A06B09F9A0F722C0F0EFA5F0A0B1204020E4D87A868824C0D83CD68C0CFA2040E0D2307C446425C0C0737E8AE398204080A04D0E9F2425C0A02172FA7A1E2240A0942BBCCB6D26C010965D30B8FE234030A0168387E928C000FBAF73D3C62340A0BDA4315A972AC058971B0C75102240602B2FF99F342BC0E0AE97A608782340
77	Guyana	0106000020E610000002000000010300000001000000040000000069FF03AC394DC03060E97C78961B40C8187442E8344DC07094490D6DE01B40D0A02FBDFD294DC020C87C40A0D31B400069FF03AC394DC03060E97C78961B400103000000010000001C0000002002637D03E54DC070AD4CF8A5AE2040542250FD833C4DC080884A2366661D40ACAD9FFEB3524DC0D0FE092E56B419405091D10149284DC0900C040132941B405825917D90994CC060C554FA0997184030F20703CF9F4CC070E7FC14C7F115407CB74082E2A94CC0A0438CD7BC1A1440488B4F0130F64CC0D0921CB0AB491340A8C266800B064DC080E9297288081040DCCD8C7E34D24CC0A03CDD79E2D90A4058A3570394A64CC040EB51B81E050B405C3123BC3D3C4CC040AFC1FBAA1CFF3F4825917D90A94CC0C022A81ABD9AFF3FA8D1AB014A674DC080C1098508F8F23F2C3201BF46D24DC080F0AB72A1B2FB3F9807CC43A6FE4DC0402B89EC838C0540AC92C83EC8C84DC0A0AB24B20F320F40003FE3C281D64DC0503AE7A7388E114030776682E1124EC040B81E85EB111240A086C43D960C4EC030E3A7716FDE144064FD9FC37C5D4EC060033DD4B6D1144080B74082E2B14EC050F6285C8FC21740206893C327914EC06054E0641BD81A40D89DEE3CF1244EC060944E24983A1C40DC2137C30D5C4EC090D6A88768241E40F468FF03ACE94DC0B0737E8AE3782040F4F0BA7EC1FE4DC0F0AA24B20F1221402002637D03E54DC070AD4CF8A5AE2040
78	Haiti	0106000020E61000000400000001030000000100000004000000000000406C6552C0000000E0930E324000000080B86A52C000000020A60E324000000000316D52C0000000A0F4193240000000406C6552C0000000E0930E32400103000000010000000400000000000040323452C000000060EAB2324000000040335352C0000000605EED3240000000C0DC3652C0000000A0C2D5324000000040323452C000000060EAB232400103000000020000000E000000000000801C2B52C0000000A0AAEA33400000008044F051C000000060B1B4334000000040D0ED51C0000000E0EDBF324000000040320052C000000020D0993240000000C024F151C000000060DB093240000000C0BA5852C0000000E00E433240000000406D7852C0000000E0D405324000000040969C52C0000000608957324000000000289152C00000002074AA324000000080661652C000000060C087324000000000383352C00000006076083340000000404B2E52C0000000E07A74334000000040C75D52C00000002012B03340000000801C2B52C0000000A0AAEA33400400000000000040536F52C0000000E08B95324000000040C76D52C0000000A0DB9F324000000080137352C0000000E0ED9F324000000040536F52C0000000E08B95324001030000000100000004000000000000C0362852C000000060A8FC334000000080353D52C0000000A0810E344000000000F73352C0000000E09B173440000000C0362852C000000060A8FC3340
79	Honduras	0106000020E610000008000000010300000001000000040000006E15C440D7E755C01052D66F267E2A4020560DC2DCEA55C080DC2A88818E2A409435B1C057E755C0201E8A027D922A406E15C440D7E755C01052D66F267E2A4001030000000100000004000000108733BF9AE455C0F0F42D73BABC2A402A2FC03E3AE555C0687A19C5729B2A408669183E22EA55C0B0D58F4DF2AB2A40108733BF9AE455C0F0F42D73BABC2A40010300000001000000170000009AF90E7EE27555C034CF83BBB3023040B85B2041F11055C0B85758703FA82F40F8F0BA7EC1F654C0C8622AFD84EB2E40D2D64FFF590D55C068AA0B7899192F40BC7C7901F60455C0C87A32FFE8B32E407A3C2D3F70C854C0003B55BE67FC2D409A35B1C057CF54C098C554FA09F72D40B2B9A3FFE51E55C0507156444D3C2D4040C2F7FE063A55C0505FD042029E2D40ACD7BB3FDE6E55C0A0656B7D91A82B401AC09481038155C0C00F5EBBB4212C40CA940F41D5B055C060F9BB77D4802B4072DFA3FE7AAC55C0E87C410B09982A40A4D1AB014AD355C060880E8123F929403ED7BE805ED955C0985DDA7058D22A402E4DD87E32F455C07083F8C08ECF2A40022159C004F055C078A148F773BA2B408469183E221E56C0A81B62BCE6B52B406E0F4240BE5556C0000341800CD52C4074336ABE4A5656C010ECA4BE2CDD2C40B4C876BE9F4956C058C1374D9F252E406A0F4240BE0D56C0D8A16131EA722F409AF90E7EE27555C034CF83BBB302304001030000000100000004000000C043183F8DB855C0F4AC33BE2F16304042DD408177BF55C00C9700FC531630405264744012B855C00409C380251F3040C043183F8DB855C0F4AC33BE2F1630400103000000010000000400000068D921FE61A655C07C15E0BBCD4B30402A11A8FE419A55C054DEC83CF26B3040FEF63C7FDA9055C0B459677C5F6C304068D921FE61A655C07C15E0BBCD4B304001030000000100000004000000EE9C6681767C55C0147CB779E36830402A47C8409E7955C084AD4CF8A57E3040787EDFBF797555C0B46E2EFEB67F3040EE9C6681767C55C0147CB779E3683040010300000001000000040000009644F64196FC54C03CD2C43BC06731405A880E8123FD54C08C1EA33CF36A3140809CF7FF71FC54C0E425AAB7066A31409644F64196FC54C03CD2C43BC067314001030000000100000004000000323201BF46FA54C0147CB779E3683140A8D1AB014AFB54C0B46BED7DAA6A3140A4CE6A813DFA54C074C763062A6B3140323201BF46FA54C0147CB779E3683140
80	Croatia	0106000020E610000013000000010300000001000000040000000000006065E7304000000010F15C4540000000205BD03040000000904F624540000000A091F0304000000090586245400000006065E7304000000010F15C45400103000000010000000400000000000060B8BE31400000009091584540000000A05852314000000010DF644540000000E041663140000000901D66454000000060B8BE3140000000909158454001030000000100000004000000000000E00FD2304000000050E17A454000000020012F31400000001095754540000000E00FA2304000000010957D4540000000E00FD2304000000050E17A454001030000000100000006000000000000E0834C314000000090E3804540000000205CA6314000000050CD714540000000609F743240000000106D484540000000A0D18032400000005087394540000000201101314000000010F9854540000000E0834C314000000090E380454001030000000100000004000000000000605535304000000010D882454000000020F10C30400000001012884540000000607F4030400000009047894540000000605535304000000010D882454001030000000100000004000000000000A0E18F3040000000908C9D454000000060A93031400000009022904540000000A0805F304000000050DA984540000000A0E18F3040000000908C9D454001030000000100000004000000000000E006DA30400000001074A24540000000E09B6730400000005034AA454000000020C8C03040000000906FAE4540000000E006DA30400000001074A245400103000000010000000400000000000060FB6330400000005098AA4540000000E0C532304000000050B1B44540000000208E5330400000001074B2454000000060FB6330400000005098AA454001030000000100000004000000000000C0FF5F2F4000000010BFD04540000000409D362F400000005066D64540000000C00E532F40000000103AD54540000000C0FF5F2F4000000010BFD0454001030000000100000004000000000000C059B12E400000009089E74540000000C0DAC02E400000009051E345400000004033732E4000000050C0EF4540000000C059B12E400000009089E745400103000000010000000400000000000040B1E42E400000005090F14540000000C08B852E4000000050DA004640000000C0FEC02E4000000010E9FB454000000040B1E42E400000005090F1454001030000000100000004000000000000C048802E400000001022024640000000C0FF1F2E40000000D01F144640000000C0717C2E4000000090CA064640000000C048802E40000000102202464001030000000100000004000000000000C0E6B52D40000000906F16464000000040E9732E400000009057F345400000004066462E40000000D0BCF24540000000C0E6B52D40000000906F164640010300000001000000040000000000004064AD2D4000000030044E4640000000C02E772D40000000D059594640000000406E7F2E4000000090F42946400000004064AD2D4000000030044E464001030000000100000004000000000000403C0B2D4000000050B13C4640000000C028BC2C40000000108E4B4640000000C0CCAC2C4000000050EA5A4640000000403C0B2D4000000050B13C46400103000000010000000400000000000040BE832D4000000070E1664640000000C005BB2D4000000010745A4640000000C089512D40000000F0B965464000000040BE832D4000000070E166464001030000000100000006000000000000C0FFE82C4000000010717446400000004096FC2C40000000109E4D46400000004099962C40000000B02074464000000040F1CC2C40000000D027754640000000406CA12C400000005066964640000000C0FFE82C40000000107174464001030000000100000004000000000000C0FC822D40000000507F7846400000004097DB2C40000000D0068A4640000000C00D142D4000000010A69E4640000000C0FC822D40000000507F78464001030000000100000016000000000000608F923040000000D0D53C4740000000A09D9B304000000050F53C4740000000A060AB314000000050E1EA46400000006028D1324000000010DCF44640000000A0F6FA3240000000D076B04640000000E0836C334000000010E89C4640000000202B0A3340000000D0416E4640000000607F40324000000010C7914640000000C0C5922F400000005002964640000000609F2430400000005087194640000000601A94314000000050CF784540000000E06AE230400000005097B34540000000C006FA2F400000009091C04540000000C02EF72C4000000050D2A74640000000C0E6952C400000009099A94640000000C05FCC2B40000000D020634640000000C0F82E2B4000000050A8BD464000000040E9332D40000000906FD64640000000C052592E400000005081B646400000004043652F40000000900DEC4640000000C0374F2F40000000D0161C4740000000608F923040000000D0D53C4740
81	Hungary	0106000020E61000000100000001030000000100000013000000A82D043928D132406E361D01DCF44640089A417C60AB3140A6984A3FE1EA46408827D87F9D9B3040269F573CF53C47409087A2409F1C3040B25626FC526F474040CF83BBB38230408218213CDA80474090129F3BC1B63040AA68ACFD9DC547400815C7815773304056F833BC59D9474068B60F79CB0D31405A34D6FECEDA47401883DC45982A314032266F809901484098D711876C403140564CDE003303484038D2C43BC0A7324056465C001AE1474050465C001AA934402A6552431B484840A83D25E7C4263640EACC04C3B93448408854FCDF11E53640AE5CE15D2EFA4740D83730B951083640DA7954FCDFC34740B050A4FB392D3540B29509BFD4254740F0A90EB919BA3440323E05C078164740A0780778D24234407E6CCB80B30E4740A82D043928D132406E361D01DCF44640
82	Iceland	0106000020E6100000010000000103000000010000003C000000F0D2307C44242EC02BED0DBE30895040B093F947DF3C2DC03DC8EBC1A47F5040203CF6B358B22DC05334D6FECE6E5040203883BF5FAC2CC06B06F1811D725040204487C091202DC0BF2B82FFAD5F5040B044A0FA07392BC0E58711C2A3605040B0415F7AFB232BC07B6649809A50504080D68A36C7112CC029172AFF5A4C5040204D4A41B7FF2AC0E55AB4006D445040902FD978B0052DC03D8386FE09335040202A70B20D142DC03F80457EFD195040C08827BB99D92DC0573A58FFE7105040E0D2307C44C42EC067D311C0CD175040D80FB1C1C2B532C07EA2EBC20FB24F4048AC1A84B90D35C02E5C8FC2F5F84F40787B9E3F6DB036C07EA52C431CE74F40D82137C30DB436C0A9AAD0402C055040A0A46B26DF5C35C0AB9883A0A3185040B0CE6A813D1A36C0A9A78FC01F145040F8800706108235C05573B9C150295040680BEBC6BB2B36C0FF0241800C1D5040D82D3BC43F6836C063DF15C1FF335040C010397D3D0F38C0E721533E0439504028DA5548F9D535C0EB3C2AFEEF415040284D4A41B78F36C067DCD440F34A5040D0976C3CD8B235C02B2F3201BF5C5040D812F241CF8A38C05537177FDB5F50404810CAFB38CE37C0553D997FF4615040A0C5A700181B38C0D3C77C40A0735040C81BB5C2F43937C0BDFE243E776F5040D082A5BA80DF37C0BDFE243E77775040D006EE409D3637C029266F8099755040800569C6A2D137C067D65240DA805040D01EF642015F37C0FF08C380257F50405897530262AA37C095E7FA3E1C87504080ED60C43E7937C0252F3201BF8C504020CB10C7BA6C36C029F04E3E3D765040885AD3BCE3F836C0BD490C022B8E504088E7DEC3256F36C0D9A9F23D239150404891D101493037C0D1B837BF619650400800000000F036C017967840D99D5040F08C0B07426635C0D3EE5701BE81504058975302629A35C095E1783E037D5040303E05C0785635C0FFDB65BFEE6E5040F08348861CC735C095E1783E037150402847C8409E1535C0D9AC33BE2F4A504058198D7C5EED34C0FDCC203EB0655040C833BDC4587234C0BF2B82FFAD5F504008EB387EA86C34C05573B9C150855040F0740305DE2D34C0D7B2B5BE4888504048A69883A07333C0291DACFF736E5040A8415F7AFB7333C06BC70DBF9B835040E091EA3BBFC832C0E94EB0FF3A8C504020CE5147C71132C0A9AAD0402C69504000EB387EA84C32C0E54B6F7F2E8B5040C82D3BC43F9830C0AB9509BFD4855040088448861C8730C0BD0166BE83A05040B0BD874B8EC32EC0D5A9F23D2389504050B4AB90F26B2DC02920ED7F80975040F0D2307C44242EC02BED0DBE30895040
83	India	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
106	Liechtenstein	0106000020E61000000100000001030000000100000004000000C051BAF42F11234012A8FE4124A34740707B6649803223408AABCABE2B88474070F1F09E03F3224096F63FC05A874740C051BAF42F11234012A8FE4124A34740
107	Libyan Arab Jamahiriya	0106000020E6100000010000000103000000010000002300000020809BC58BE523402C6211C30ED33B40201808026488234084035ABA826D3D40204B3B35979B22404CD367075C1F3E405083A279001323407C82A8FB003C3E407032384A5E6D244044E78BBD17BB3E40606211C30E932440940F5EBBB4B13F4090069B3A8F222740826649809A3840402018247D5A0D2740BE196EC0E7954040F0311F10E8542E40DA82177D05334040200473F4F8852F4024CF83BBB3623F40D057C9C7EE5E31404C3A58FFE7143F4000938D075B0033402CF6D03E56443E40089C5088800F34407C1EA33CF3DA3E40A868ACFD9D153440560ABABDA4174040E828EB37139F35402E20ED7F8077404038D505BCCC1C37402A5C8FC2F5504040C8B3AF3C483F3740F2C9C342AD1B404078F755B950F93840CC3730B951F83F40C0F27684D3263940AC68ACFD9DA53F40683A58FFE7B4384064C763062A2B3E40D8BB783F6EFF3840AC6E2EFEB63F3D406076FA415D00394084F9F202ECFF354050CAA48636003940ECCF4543C6FF334070CAA48636003840347D5A457F00344088290307B400384014944DB9C27F334050CAA48636003040FC14C78157733740B013984EEBFE2D400CAC55BB26003740902FF7C951782C40AC50A4FB399D3640C05FE97C78162B405CC763062A2B3740C0A44E4013F927409489CDC7B5853740D051D66F261E2740F41A4982704D3840D0A9F23D2381244024E78BBD179B3840E0D58F4DF2CB22402C6E15C440273A40001286014BBE2340CCC77C40A0833A4020809BC58BE523402C6211C30ED33B40
84	Iran (Islamic Republic of)	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
85	Israel	0106000020E61000000200000001030000000100000004000000140F45813EA14140F4C1FA3F87C93F408C4E417E36A041402473F4F8BDC93F406437177FDB9F41400429EB3713CF3F40140F45813EA14140F4C1FA3F87C93F400103000000010000000D0000004456293DD3CF414012DBDD03749F40402C6211C30ED34140AA6E2EFEB65740409CECF483BAC641406A1BB8037532404084A86DC328A44140DA8BDAFD2A424040DC0F2384477141400C0C040132643F403C0E677E35BD4140D4949D7E507F3F40FC5D11FC6F7D4140CCB1F677B68B3D40CC8B4CC0AF7341406CC4B0C3987C3D40A490F3FE3F2241403C3E213B6F373F40CCD03FC1C52A4140041E8A027D423F404C137D3ECA3E4140E44659BF99983F40543A58FFE78C41400EDFA63FFB8B40404456293DD3CF414012DBDD03749F4040
86	Italy	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
87	Cote d'Ivoire	0106000020E61000000300000001030000000100000004000000C05E7AFB73D108C070C381902C701440002DE92807D308C040C3D50110571440806F067FBF5809C0107D410B09781440C05E7AFB73D108C070C381902C70144001030000000100000004000000C0703B342C2613C060191EFB59AC1440C0F97DFFE69510C0A0ED7E15E01B15408085E63A8D0410C05040321D3AED1440C0703B342C2613C060191EFB59AC144001030000000100000020000000C0703B342C2613C060191EFB59AC1440801D5377654715C0B059677C5FEC1440E0D6DCD1FF0214C080BB41B456841440C0025DFB021A1EC00055DFF945691140C023D5777EB11DC0404B3B35975B174060A2B1F6773621C0B0ACC5A700081A40607D3CF4DD9D20C0B045B9347E711B4050A8E0F082F020C090B515FBCB3E1E40407092E68FC91FC008A0C37C79092040A07C23BA676520C0101286014BFE2040E0BE7E880D961EC0F090F0BDBFC12040E04F8BC1C3D41FC0A894490D6DA0214060C8409E5DEE1EC0D07F828B152D224030A01683874920C0607497C459112340E04ECB0F5CE51FC030B709F7CA542440C01A2B31CF8A1EC060809BC58BE524404077BAF3C4F31BC0E0622AFD844B2440A01FB75F3EF918C02860747973782540408940F50F7218C078CDE50643652440404DF38E531416C04852280B5FDF24408052B3075AD112C0889E0777676523400016DBA4A2110DC010CBBDC0ACE82340404ED367077C05C05850C3B7B0F62240C0A9ED26F8E603C090CDE5064365204080EFA1444BFE09C030AB24B20F721A4080B91457951D06C010D253E4105116404003745FCE6C07C0005C9198A0661440806F3D0AD72309C020E2AC889A78154080F2C473B6600AC0D084F068E378144040C2BE9D440410C0609F1B9AB2031540806CE34F54760EC030666B7D91801540C0703B342C2613C060191EFB59AC1440
88	Iraq	0106000020E6100000010000000103000000010000002200000054F86C1D1CE646403A9E4143FF7441400CF7CABC55B34640B21AF67B62FD40402CF38FBE491747405A73B9C150A14040D4CDFE40B90D47405A16BEBED67B4040FCA5457D92B747408E992842EA3240402C29B000A6EE47406C5B238271CC3F40FCB48AFED0D84740D4B2B5BE48003F405C888043A8044840ECF44BC45BFF3E407CA86DC32804484084CFBA46CB7D3E40AC9509BFD44548401C11532289F63D40A4A17F828B454840347288B839ED3D40A4CB9BC3B5384840FC1A498270ED3D4074931804561448402C8C9FC6BD093E402C508BC1C3F847409CE1067C7E043E405C2B85402EF74740E45147C7D5043E40ACCEDC43C2954740449C16BCE8033E402C5FD042024647400C4F5AB8AC1A3D4054E63C635F5C4640F4D03FC1C5323D40B4984A3FE10A45409C45F0BF951C3F405C3A58FFE7344440ECD03FC1C5F23F40C45BE7DF2E9943407663B323D5134040A48C2AC3B86543403A950C0055B04040AC9E3E027F8044404A6A6803B0354140246893C327A544405A7FBDC2822D4240FCFF71C2842D4540CA8B4CC0AF8D42400CEEEBC039654540120F45813EB142408478CF81E50E4640A29E3E027FA84240846649809A2846405A2EC6C03A7C4240F472D87DC7644640CEE847C3299342407C7B1002F2B34640E676137CD3FE41408C5A457F682C4740866649809AE841407C3C2D3F70FD46402635B401D8CA41401CDB6B41EF154740E2006C40848E414054F86C1D1CE646403A9E4143FF744140
108	Madagascar	0106000020E61000000400000001030000000100000004000000000000D0B3EA484000000020F81631C00000009026EE4840000000C0F4E930C0000000D05901494000000040BEB930C0000000D0B3EA484000000020F81631C001030000000100000006000000000000D01F9C47400000000093DF2EC000000050989A4740000000C06FDE2EC0000000D0AB99474000000080E1DA2EC000000010749A47400000004053D72EC0000000D0169C47400000008077D72EC0000000D01F9C47400000000093DF2EC00103000000010000000400000000000010D72B4840000000400BD62AC0000000904F1A48400000004064C82AC0000000900424484000000080B1642AC000000010D72B4840000000400BD62AC00103000000020000002400000000000050B0AD4840000000C0812E28C000000010BFF848400000004032142AC0000000908037494000000000F6282FC0000000901D164940000000409EF52FC000000090DCEE4840000000C070DD2EC0000000101AD14840000000C0701D2FC000000010F1E44840000000408DD430C0000000D0079147400000004095ED38C0000000107C9B4640000000409D9639C00000005034024640000000403BFC38C0000000D0939E454000000000524836C00000001012C04540000000C0795535C000000050B93D46400000004064F833C0000000D0F6F7454000000000BD7A31C0000000D0C53A464000000000382F30C00000009060134740000000C03F682FC000000090153D474000000040A6EE2FC0000000904E2B4740000000C0DB3F2FC0000000903E79474000000000D5652EC000000010CF7A474000000080B91D2FC0000000909F9C4740000000409DE52EC0000000B0299E4740000000406AD32EC000000010548E474000000000729C2EC0000000507787474000000080B85E2EC0000000503DBA4740000000809F542DC000000010AFB64740000000C09A382EC0000000F0D7E747400000000031352DC0000000903600484000000000F7872DC00000005087D947400000004053D72CC0000000D02F06484000000000A54F2CC000000010E0F34740000000005A312BC000000090C324484000000080B99D2BC000000010AF5E484000000000BDDA2AC000000010CF7A484000000080FAA429C0000000D08B5D4840000000404BDE28C000000050B0AD4840000000C0812E28C004000000000000505ECD484000000040B64029C00000005044CC484000000000523829C0000000D016CC4840000000004A3F29C0000000505ECD484000000040B64029C0
109	Martinique	0106000020E61000000100000001030000000100000004000000548B4F01306E4EC0902975C938CE2C4000D9B27C5D964EC0C8D8D0CDFEC02D40807B9E3F6D784EC0789885764E7B2D40548B4F01306E4EC0902975C938CE2C40
89	Japan	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
90	Jamaica	0106000020E61000000100000001030000000100000006000000869CF7FF714853C034E109BDFEE0314098FC4FFEEE6E53C0FC0E45813ED931406C0F4240BE9553C03CD505BCCC5C3240D4DF12807F3C53C08C1A3048FA643240EA6987BF260E53C0CC40F33977E73140869CF7FF714853C034E109BDFEE03140
91	Jordan	0106000020E6100000010000000103000000010000000E0000002C6211C30E7B4140AC59677C5F5C3D40FC5D11FC6F7D4140CCB1F677B68B3D403C0E677E35BD4140D4949D7E507F3F409CECF483BAC641406A1BB803753240402C6211C30ED34140AA6E2EFEB6574040DCAF743E3C6B424026EACC3D24284040A48C2AC3B86543403A950C0055B04040C45BE7DF2E9943407663B323D5134040D4CABDC0AC804240BC5CA8FC6B813F407CC9C6832D0043404CC1E10511813E402C172AFF5AC04240AC656B7D91003E40DC09A1832E5F4240D43A71395EDD3D402C5C8FC2F508424004938D075B303D402C6211C30E7B4140AC59677C5F5C3D40
92	Kenya	0106000020E61000000200000001030000000100000004000000948AE3C0AB914440E076F17EDCFE00C004274D83A279444040CEF9298E6301C08CC9C6832D884440E07F643A745A00C0948AE3C0AB914440E076F17EDCFE00C00103000000010000001A000000FC17080264F84140C02BBB60707D1240D4031F831585424040666B7D918011403420ED7F800F4340609AD024B1E40C40FCE769C020C3434000A243E048400B406CD383825264444050431CEBE2261140DCFA5B02F0954440C0D7A3703D8A0F408C352383DCF34440E0648C0FB3D70F40E4B2B5BE487E4440C0F3A8F8BFA306400CD3A23EC97F44408096766A2EB7EBBFEC7B0DC171C7444080DE516342CCFABF44172AFF5AA8444000C83B873254FFBFDC06600322724440604C3107412700C00C15C781577B4440401281EA1F6402C00C1B4982706D4440A0CEF9298EE301C07C8AE3C0AB51444040666666666604C00C1286014B1E444020DC2A88814E05C07C1E87C1FC99434030404B57B0AD12C00CC45DBD8ACE424060C745B588080CC02C6893C327CD42408038BA4A77F707C034327381CBF5404080A6CAF78C04F0BFACA78FC01FF440400024A8C5E061BA3F0C0F45813E81414080412D060F53FE3F3414E97E4E3B414000282F32015F0D408C8461C092FF4040D03465A71FE410400CCD203EB0314140F0D66B7A50701240FC17080264F84140C02BBB60707D1240
93	Kyrgyzstan	0106000020E61000000100000001030000000100000020000000B29ECC3FFA0E54402269A9BC1D194540A6AAD0402C855340228D2782388544400E7BA180ED37534092D21742CE814440EE482EFF21165340E2334B02D42C4440EE66B8019FEC524012F4893C492644401A9F3BC1FEE45240667C0A80F1524440B283F57F0EB752400A008E3D7B42444042C8EBC1A47F5240DA9AADBCE405444096DE37BEF669524076AF05BD37BA4340A67A32FFE80F52404AC5C6BC8E984340FEF02C4146DE51409A8026C286CF4340BA162D40DBBF514042D47D0052B343406AA6B4FE965351408224253D0CC54340BE07E8BE9C625140FAB48AFED010444026179CC1DF9F51400E84640113F443404ED74CBED9BE5140C6D3F203571F4440E65DF58079ED51400AEB387EA81244400E846401134B524032569BFF576944406EC18BBE820C52402A35B401D8804440D270033E3FEC51406A4F3BFC35C7444066D0D03FC1DA5140E2EBA4BE2C8F444062BEBC00FB8B5140EA66B8019FC34440FECC203EB0D1514012812381061945404E2844C021BE51400E2769FE982045406EDCD440F3CA5140FE7E4E417E584540D6D38041D2EF5140C6B81B446B694540865182FE426152405ECD018239344540AAB6D4415E655240F23C2AFEEF84454056137D3ECA9252409E2FA182C39B4540EA60360186EA52409EF63FC05A674540D69D60FF75CC534092352383DC654540B29ECC3FFA0E54402269A9BC1D194540
94	Korea, Democratic People's Republic of	0106000020E610000002000000010300000001000000040000004E499D8026365F40560ABABDA4BF4340623A58FFE7385F40627FBDC282CD434066B2B8FFC83B5F407E96E7C1DDCD43404E499D8026365F40560ABABDA4BF434001030000000100000022000000F99CF4BE715460403244F9821634454089B48D3F51566040FED89601672545403B984D8061366040DE82177D05D344407F6CCB80B33660402EF04E3E3D6A4440E67B0DC171E05F400E0FB743C3DC434042AA61BF27D95F405E8BC1C3B49943407B483140A20B6040A602D2FE07504340D5A3E2FF8E0260402EBD6F7CED274340FAE12021CAC65F4042D505BCCC244340AEE3BF4010AC5F40C6EF517FBDEA42406ACD8FBFB4655F4026FF93BF7B034340D697DEFE5C6E5F407E45F0BF95F44240561C40BFEF555F40621C40BFEFD542400E72DEFFC7605F40DAC1FA3F87F14240AEBF5E61C13E5F40069700FC53F642403EAA61BF27515F40CE949D7E5009434072A3737E8A2A5F40AE41D13C800F434066A6B4FE963F5F408AB130444E4B4340B274B0FECF695F403250FD8348504340524C1762F5485F40E6FA5B02F06543405A0DFB3DB15C5F40E273D2FBC6C943402A179CC1DF475F4006F46DC152C7434036C8EBC1A42F5F4052FEB5BC72E34340CEAC6C1FF2275F4082A86DC328CC4340AE7A32FFE8175F402E207BBDFB0B4440EE45ED7E15815F40564CDE003373444036FC523F6FBA5F408A1B62BCE6E54440DB1E8480FC046040B27D737FF5B0444003D9243FE2016040129D82FC6C004540D3C77C40A01D6040FEE769C0200345401572DEFFC7366040D2B56801DA3845405D828C800A3D6040A25016BEBE804540E315C1FF56536040D6BE2B82FF354540F99CF4BE715460403244F98216344540
110	Mongolia	0106000020E61000000100000001030000000100000031000000D27344BE4BC156408684285FD04C4740AE716F7EC38456408A5D86FF74F14740A674B0FECF2956406258E2016517484082336ABE4AFE554042D8463CD949484002F4FBFECDF55540C2672442239648406ACA4E3FA8145740B6B393C1516849402A266F8099915740DAF71A82E348494072CA4E3FA8A85740FEE769C020034940AA74B0FECF555840B280B4FF01DE48406EA3737E8A925840AA68ACFD9D254940B29ECC3FFA7458403AEACC3D248049401663997E89BB5840D6B837BF61124A40A680B4FF018E5940866CCB80B3AA49406EAF3E1EFA945940DE7C957CEC484940F6E12021CABA5940AE380EBC5A28494026FC523F6FAA5A407E36AB3E572B49407E42AF3F89FE5A40EAD39CBCC8F84840B25016BEBEFC5A4056137D3ECAD648407E87A2409F245B408A6CCB80B3AA4840123FFF3D78B25B400AE869C020934840AE74B0FECF455C400EA986FD9ECC48400E33349E08945C40BA59677C5F244940DAC1FA3F872D5D402AB41EBE4CEA4840CEB8A981E6E55C400ECD203EB0F5474052F564FED1575D4022EA3E00A9D347402ED236FE44735D405EF833BC590148407A21567F84A25D40E654320054FF4740FEAE08FEB7EE5D400EC18EFF029547401E5D177E70F95D40B65FE97C785647406ADCD440F35A5D40AEA10DC0064A4740EA5DF58079255D409296E7C1DD254740824B395FECEC5C40866CCB80B3BA46407E78CF81E5A25C407A758E01D9B1464002D6E3BED5685C405A58E201655F4640D2D03FC1C5FE5B40022DCF83BB8B4640EE1E12BEF7DA5B40AA7D737FF5304640D6B5F63E55FD5B407E6649809AD845407E2DE8BD319C5B407E6308008E634540C2438A0112545B403641B8020A374540669D2ADF33DE5A40AAC85A43A93B45401272DEFFC7405A40AEB915C26ACA4440EA5DF5807935594052137D3ECA564540C60166BE831858402E0516C0945D45406EC18BBE82D55740BE6BED7DAA024640AE6BED7DAADA5740BA68ACFD9D25464096FF024180635740FEA204FD857A46402A1A6B7F67B956400A18080264A046403EC8EBC1A4AB56402E6BD44334CA4640D27344BE4BC156408684285FD04C4740
111	Montserrat	0106000020E610000001000000010300000001000000040000007C5D143DF0154FC0A4F5B704E0AB3040AC743E3C4B1E4FC07CAEEFC341B63040A8B6627FD9194FC0DCB2B5BE48D030407C5D143DF0154FC0A4F5B704E0AB3040
112	The former Yugoslav Republic of Macedonia	0106000020E61000000100000001030000000100000008000000386BD44334D234402AF6D03E5674444058499D80267E3440D2B837BF61AA4440185932C7F296344066FAEC80EBF0444088035ABA825D36407E5D86FF74294540809065C1C4033740A2C2D84290E14440D00166BE83EF3640721283C0CAAB444078F12900C6FB3440FE84ECBC8D6D4440386BD44334D234402AF6D03E56744440
151	United States Minor Outlying Islands	0106000020E61000000700000001030000000100000004000000FCEAAA40AD0064C0007B7EDFBF79D9BF0B630B418E0164C000B0D826158DD8BF2D4487C0910064C000DEC5FB71FBD7BFFCEAAA40AD0064C0007B7EDFBF79D9BF010300000001000000040000006F067FBF980E66C000E0326E6AA0CB3FDF1E8480FC0E66C000CC393FC571CC3F1AA20A7F860E66C0000C228B34F1CC3F6F067FBF980E66C000E0326E6AA0CB3F01030000000100000004000000E64EB0FF3A1466C080BE1DE1B460E93F1AA88C7F9F1466C0006965C22F75E93FFCE42840941466C080101D024702EA3FE64EB0FF3A1466C080BE1DE1B460E93F010300000001000000040000001AAE0E80B83065C0B4A4C00298BA3040291A6B7F673165C06C8061F9F3B93040B0E07EC0033165C05C9DB98784BB30401AAE0E80B83065C0B4A4C00298BA304001030000000100000004000000156C5CFFAED464402421CB8289473340773C2D3F70D364404469C537144E33404B25034015D46440AC08707A17533340156C5CFFAED464402421CB828947334001030000000100000004000000158DB5BFB32A66C01C4AED45B4313C40983270404B2A66C0FC298E03AF363C4020EA3E00292A66C0CC16838769333C40158DB5BFB32A66C01C4AED45B4313C400103000000010000000400000040DAFF006B2C66C0C4B1F677B62F3C40BC3D0801792C66C0549A780778363C407C5D86FF742B66C0AC8636001B383C4040DAFF006B2C66C0C4B1F677B62F3C40
95	Kiribati	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
96	Korea, Republic of	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
97	Kuwait	0106000020E610000004000000010300000001000000040000009C98BC01662E4840F44D9A0645733D40648BC1C3B431484054CDE50643653D40342922C32A224840A4F8F884EC703D409C98BC01662E4840F44D9A0645733D4001030000000100000004000000FC0EB743C31C48406C4F1F813F983D40ACDDAF027C1348404C98A3C7EFFD3D40345FD042022E48407C8D2441B8BE3D40FC0EB743C31C48406C4F1F813F983D4001030000000100000005000000B4A78FC01F044840D4D38041D2F73D4064465C001A014840A410018750F93D404C732B84D504484094D2FBC6D7023E40141286014B0E4840143D4679E6053E40B4A78FC01F044840D4D38041D2F73D400103000000010000000B0000005C2B85402EF74740E45147C7D5043E402C508BC1C3F847409CE1067C7E043E40AC3B4F3C67154840A4E33103958D3D408C81204086DA474074CAA48636603D409CC85A43A9034840EC50DB8651583D4004F46DC152354840DC420246978B3C40ECEAAA402DD84740CC5E7D3CF4893C4044BA2EFCE0BA4740CC58FB3BDBFF3C402C5FD042024647400C4F5AB8AC1A3D40ACCEDC43C2954740449C16BCE8033E405C2B85402EF74740E45147C7D5043E40
98	Kazakhstan	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
113	Mali	0106000020E6100000010000000103000000010000003700000010FA27B8581121C0C05582C5E1FC2640A0643909A54F22C090737E8AE3F82840901D5377656723C0A881E673EE0E284080CEA44DD5A524C0606589CE32732840000F61FC344E25C0F83AFE0B04C927409029577897DB25C088B2D30FEA722840D01C588E90A126C0F865A208A90B2840A0054B7501BF26C07851F4C0C7D02840E01C588E90C126C0485DC136E2F929402039B5334C1D28C0C0ED974F56542B40A0F63FC05A7D28C0181B81785D872D40004C18CDCAAE27C0405DC136E2B92D404086FF7403FD26C0A81EA33CF34A2F40008B8A389DCC25C000965D30B8362E40208FE046CA6E25C0884C50C3B7E02E4080FCA5457DD222C0782CB64945E32E40205E9ECE15AD22C0189CDF30D1682F40101B2B31CFAA22C0482FDE8FDBFF2E40E0891F63EEFA15C0E88CD47B2AFF2E4080A3703D0A5715C0E45A0A48FB53304000B29C84D26716C05CC2137AFD813040C0FECD8B134F1AC0F44E0647C9FF384080C87729753913C0AC01BC051200394000FC5580EFB6F23F1C6F0F42401A35400048E17A14AEF23FD4CDFE40B9BD3440803D4162BBBBFC3FDC57C9C7EE4E3440C05A99F04BDD094064C2137AFDD1334040D48041D2A70A405C3D997FF4F9324040D8D5E429FB104024809BC58B253340A014AE47E1FA10402CED0DBE30A5324060D47B2AA7CD1040D45147C7D5643040C0CD55F31C310C4068FEEDB25FB72E40800000000000F53FE0D03FC1C5922E4000C47E880D16CE3F803BFBCA83D42D40004450357A35E7BFF0B837BF612A2E4000E10CFE7EB1FFBF406211C30EF32C40C0F61E2E390E00C0D0E1934E24602C40C088450C3BCC03C0C85417F032932C4040C745B5880807C028861DC6A44F2B4040C2F5285C0F0AC020895E46B1642B40C0361AC05B800BC0F8B2D1393F552A40408FE046CAB60FC0C07C7901F6012B40C0D571FC505911C0001286014B3E2A40A051B81E85AB11C0E83E5585069A2840E0E7F7FD9B1715C0F009F5F411B02740404DF38E531416C04852280B5FDF2440408940F50F7218C078CDE50643652440A01FB75F3EF918C028607479737825404077BAF3C4F31BC0E0622AFD844B2440C01A2B31CF8A1EC060809BC58BE52440E04ECB0F5CE51FC030B709F7CA542440F0DC2571569420C018634337FB032640902094F7715C21C0C06DFC89CAEE2540106420CF2EB720C0204278B4719C264010FA27B8581121C0C05582C5E1FC2640
114	Morocco	0106000020E6100000010000000103000000010000001C000000605298F7381B22C08684EFFD0D5E404020C972124A5F1BC0D2B837BF61024140A095253ACBAC17C0C6CE86FC33E5414080D0EAE40C9515C0F212807F4AF541400061DF4E226215C00A2DCF83BBEB414080C745B588C812C0FACF61BEBC9A414080E270E6579307C0D606600322AA414000AAED26F86607C0DE06600322A24140007397C4595107C0D682177D05A34140807C0A80F1AC01C0CEFD9C82FC8A4140809F4D0E9FF4FBBF520ABABDA45F41400059FE7C5BB0FABFA65CA8FC6BA1404000E49D43192AF0BF86457EFD10414040808B31B08EE3F2BF52499D80260E404040508BC1C3D406C02E14E97E4E0B404080A339B2F28B0EC074A2EBC20FB23F4000DCF3FC69030DC07C00193A76F83E40E08B683BA6AE13C07CA2EBC20F823E40804C3107412716C054C554FA09E73D40E0550DC2DC7E1CC03C6211C30EA33D402047C8409E5521C0AC68ACFD9DB53C4040941282555521C0B46BED7DAAAA3B40A026FA7C94592AC044CE6DC2BDAA3B404068757286EA26C0AC68ACFD9D553C408008AA46AF4624C0ACE33103956D3D4060B29C84D24723C0A4FE7A85052B3E4070F0A1444B9E23C05C55A18158723F40605298F7381B22C08684EFFD0D5E4040
115	Mauritius	0106000020E61000000300000001030000000100000004000000E40F238447C94C4044A69883A08334C05C40DAFF00A74C40846055BDFC7234C0AC9B8BBFEDCF4C40442250FD83FC33C0E40F238447C94C4044A69883A08334C001030000000100000004000000342CF180B2BB4F40243883BF5FBC33C08CA2EBC20FAA4F40D09DEE3CF1BC33C0D482177D05BB4F40B04F72874DAC33C0342CF180B2BB4F40243883BF5FBC33C0010300000001000000040000005C4F1F813F484C40187024D060CB24C00CC11C3D7E414C40B823D5777EB124C0E4EE5701BE414C402061DF4E22A224C05C4F1F813F484C40187024D060CB24C0
116	Mauritania	0106000020E6100000020000000103000000010000000400000060F964C5706D30C094812040869A3340C00FB1C1C27530C0546C06B820B33340302C7FBE2D5830C074B60F79CBDD334060F964C5706D30C094812040869A33400103000000010000001F000000A008AA46AFA61AC064C1E10511213A4080C87729753913C0AC01BC0512003940C0FECD8B134F1AC0F44E0647C9FF384000B29C84D26716C05CC2137AFD81304080A3703D0A5715C0E45A0A48FB533040E0891F63EEFA15C0E88CD47B2AFF2E40101B2B31CFAA22C0482FDE8FDBFF2E40205E9ECE15AD22C0189CDF30D1682F4080FCA5457DD222C0782CB64945E32E40208FE046CA6E25C0884C50C3B7E02E40008B8A389DCC25C000965D30B8362E404086FF7403FD26C0A81EA33CF34A2F40004C18CDCAAE27C0405DC136E2B92D40A0F63FC05A7D28C0181B81785D872D40700E2C47C8B02CC0BCDDAF027CA33040D89AADBCE44730C0140341800C85304020C98FF8158730C0DC9D7C7A6C0F304080E49D43190A30C0F4B837BF61BA3140606055BDFC8230C0B4073E062B5A3340103201BF463230C064465C001A3934409058350873EB30C044F911BF622935407099B67F650D31C0A409DCBA9BC33440B8415F7AFBF330C06428D2FD9C563540B075E107E77B2FC0A4C2BCC799563540001E6CB1DBFF29C0F43FC1C58A56354010FA7DFFE6352AC08C87A2409FE43640E0D02170240028C044F6D03E567437403091D101490028C01C00000000003A40E075A6D0795521C0C401BC0512003A406099B67F655521C02CD461855B4A3B40A008AA46AFA61AC064C1E10511213A40
117	Malta	0106000020E61000000200000001030000000100000004000000202FDE8FDB1F2D4032E109BDFEE841407021E4BCFFBF2C40D2BEB9BF7AEC414040AE65321CA72C404E5260014CFD4140202FDE8FDB1F2D4032E109BDFEE8414001030000000100000004000000405C8FC2F5882C40865D86FF7401424060F52D73BA5C2C400ED3A23EC907424080AD4CF8A5AE2C402AF6D03E56044240405C8FC2F5882C40865D86FF74014240
118	Oman	0106000020E610000005000000010300000001000000040000007C9C69C2F6EF4B4034CC423BA77D3140DC06600322EA4B40A4FA96395D7E31402CE44A3D0BEE4B407CF41439448431407C9C69C2F6EF4B4034CC423BA77D3140010300000001000000040000002CE78BBD17034C403CDEC83CF27B31405C82FE428FFA4B404C3A58FFE78431400CDFA63FFB0B4C407C9065C1C48331402CE78BBD17034C403CDEC83CF27B314001030000000100000004000000E47954FCDF6B4D40A4F8F884EC7034408C4B00FE29534D40DCAF743E3C2B34407C4B00FE29734D40CC5CA8FC6BB13440E47954FCDF6B4D40A4F8F884EC7034400103000000010000001700000034D505BCCC044C40FC928D075BF03840DCB5F63E550D4C40F4A6B1BD16BC3840FC11F8C3CF2F4C40844A5CC7B8FA3840E488997D1E954C40AC01BC0512F03740445FD042024E4D409CA2EBC20FA237405C37177FDBE74D40F425AAB7063A3640B4A10DC006424D403CF911BF62693440CCFD9C82FC1A4D403CD505BCCC9C3440DC8BDAFD2AEA4C40FC847AFA083834402CDB87BCE5E64C40D44D637B2DF83240BC8EFF0241684C400CBEF73768BF32408CCC07043A2D4C40FC08C38025EF3140AC9B8BBFEDB74B40240C040132D43140E488997D1E854B40A4716F7EC30431402C29B000A68E4A40AC9658198DA43040249C16BCE8FF494054742502D5FF3240FCFFFFFFFF7F4B400C00000000003440845182FE42D54B409417EFC7EDFF354014C11C3D7E994B40446C06B820B336406473B9C150C14B40F45D4BC807F937408C4B00FE29034C40B4DDAF027C1338408C9065C1C4E34B4024938D075B90384034D505BCCC044C40FC928D075BF0384001030000000100000005000000AC80ED60C42E4C40B459D93EE4613A408481204086224C40FCC308E1D1A23940F4ABE46377174C405C3DEE5BADA739400C4EB6813B0A4C4064F58079C8103A40AC80ED60C42E4C40B459D93EE4613A40
119	Maldives	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
126	Niger	0106000020E61000000100000001030000000100000024000000A014AE47E1FA10402CED0DBE30A5324040D8D5E429FB104024809BC58B253340A021E4BCFF3F17402C6BD44334723340603BA759A0CD1D40F4F7C43A55DA3440C0A44E4013F927409489CDC7B5853740C05FE97C78162B405CC763062A2B3740902FF7C951782C40AC50A4FB399D3640B013984EEBFE2D400CAC55BB2600374010F2ECF2AD672E40D457C9C7EE7E3540001286014BFE2F40DCB837BF615A344070A148F773FA2E40E425AAB706EA3040200AF5F411F02A40D0A6B1BD16EC2C40B02688BA0F402B40B8F292FFC96F2B40D0DE52CE17EB2840E0CF0D4DD9212A40F0D03FC1C572254080116DC7D4C52A40505E9ECE15452340D854A4C2D89A2940C0F5285C8F421F40E08FDB2F9FB42A40203E4162BBBB1B4018C53BC093FE294040A3755435B11940C81B62BCE6352B40405EBC1FB77F1740C86E2EFEB67F2B4060B81E85EB911040200C040132F42A40002FA699EED50C40A8554ACFF4622740002C0E677EB50640E064E3C116CB284040FAF02C4106034090289831057B284000166A4DF32E0340807D586FD4CA274040713D0AD723014058DF6B088E632940002A931ADA40F93F80069B3A8F4229400009698D41A7EF3FA84D637B2D182A4000B7B06EBCBBEF3F181286014BBE2A4080A435069D90F43F30035C902DB32A4000D15D126745E33FF017080264682B4000C47E880D16CE3F803BFBCA83D42D40800000000000F53FE0D03FC1C5922E40C0CD55F31C310C4068FEEDB25FB72E4060D47B2AA7CD1040D45147C7D5643040A014AE47E1FA10402CED0DBE30A53240
120	Mexico	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
121	Malaysia	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
122	Mozambique	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
123	Malawi	0106000020E61000000300000001030000000100000004000000D4CDFE40B95D414060DF4DB7EC3028C05C888043A85C4140780E2C47C81028C0846649809A604140200F27309D1628C0D4CDFE40B95D414060DF4DB7EC3028C0010300000001000000040000005C37177FDB4F414048AF5B04C61228C0446893C3274D4140B8A23EC91D0628C004CADFBDA35041408855F487660628C05C37177FDB4F414048AF5B04C61228C001030000000100000017000000140F45813E9140404886FF7403FD22C004274D83A2294140006420CF2E7723C054103CBEBD7B4140085DA5BBEB2427C03CEACC3D2450414080D9CBB6D32627C0DC00DE0209304140A0355B79C94F28C06401F73C7F484140F0CFEFFB37AF2AC00C1286014BF64140E07C23BA67C52DC04C4F1F813FE841406001857AFA0430C01C93A98251914140806CE7FBA98D30C094094E7D20A5414000F7AE415F2231C0642E54FEB5204140103883BF5FCC2FC0ACDDAF027C4B4140680E2C47C8902EC02C35B401D842414080677A89B1242DC07C457EFD10D14040E0DC257156142DC0849CF7FF719C40402815FE0C6F062CC034DB87BCE5564040183E05C078362BC0DCFA5B02F0854040D8D362F0303529C07C96E7C1DDC54040005B5D4E09B828C0DCFD9C82FCA240403824EEB1F44928C0DC8558FD11A0404058E28E37F9C525C0AC59D93EE4D94040980E80B8AB1F25C07C1893FE5E78404028B9A64066CF22C0140F45813E9140404886FF7403FD22C0
124	New Caledonia	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
125	Niue	0106000020E61000000100000001030000000100000004000000168733BF9A3C65C038B43A39432533C03674B33FD03D65C07CF41439440433C020EA3E00293A65C05CBC9179E4F732C0168733BF9A3C65C038B43A39432533C0
127	Aruba	0106000020E61000000100000001030000000100000004000000EA9C6681767851C0F01D8A027DD22840FEF3FBFECD8351C018E6E8F17B1329406C21C841098451C0C8CF0D4DD9412940EA9C6681767851C0F01D8A027DD22840
128	Anguilla	0106000020E610000001000000010300000001000000040000007C7EDFBF79954FC0F4058200192A3240280B26FE287C4FC0CC488446B04532402C08E57D1C7F4FC0AC073E062B3A32407C7EDFBF79954FC0F4058200192A3240
131	Northern Mariana Islands	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
132	Faroe Islands	0106000020E6100000080000000103000000010000000400000000000000019F1AC000000050D9B14E4000000080E2D91BC0000000D040CF4E4000000000D5E51AC0000000D062C94E4000000000019F1AC000000050D9B14E400103000000010000000400000000000080AA6A1AC0000000502CE94E4000000000E09B1AC00000005013DF4E400000000022A21BC0000000D0CDF34E4000000080AA6A1AC0000000502CE94E400103000000010000000400000000000080EA321CC0000000D0AC084F400000008081CE1CC0000000D061024F400000008070BD1DC000000090F4114F4000000080EA321CC0000000D0AC084F400103000000010000000400000000000000E9D31AC0000000D0FFF74E4000000080CBED1CC00000005014164F4000000080E4D71CC0000000D071244F4000000000E9D31AC0000000D0FFF74E40010300000001000000040000000000008047A11AC000000010D70B4F4000000080B93D1CC00000005024284F400000008089671AC00000005035194F400000008047A11AC000000010D70B4F400103000000010000000400000000000080E17A1AC000000090671D4F40000000004BBE1AC0000000105C1F4F400000000022E21AC0000000D06A2A4F4000000080E17A1AC000000090671D4F400103000000010000000400000000000080A8AC19C00000009089174F40000000803D4A1AC0000000D0171B4F4000000000304C1AC0000000D0C82C4F4000000080A8AC19C00000009089174F400103000000010000000400000000000080DB9F19C00000009068244F4000000000CEEB19C0000000901D264F40000000805D2E1AC00000005087314F4000000080DB9F19C00000009068244F40
133	Andorra	0106000020E610000001000000010300000001000000040000008011AAD4EC81FC3F46FBCA83F4484540006BC020E993FB3F7EABAE433541454080A5A7C82122F73F060341800C4D45408011AAD4EC81FC3F46FBCA83F4484540
134	Gibraltar	0106000020E610000001000000010300000001000000040000004000E143895615C0B2D11DC4CE144240C01A12F7585A15C0E2361AC05B0E424040CCB392566C15C0AA1A683EE71442404000E143895615C0B2D11DC4CE144240
135	Isle of Man	0106000020E61000000100000001030000000100000004000000E00F2219721C13C07EA52C431C074B40204A09C1AA6A11C0FA230C0396344B40E069C020E99311C05E37177FDB174B40E00F2219721C13C07EA52C431C074B40
136	Luxembourg	0106000020E61000000100000001030000000100000006000000804B55DAE21A1840D22AFA4333174940807FD8D2A38918405676FA415D104940C05512D907191A402E20ED7F80E74840C05E46B1DC72194036923D42CDBA4840E05E0CE5443B1740CA707500C4C54840804B55DAE21A1840D22AFA4333174940
137	Macau	0106000020E61000000100000001030000000100000004000000AAA10DC006625C40AC5AEF37DA3136402AFF93BF7B635C40F4E0287975363640A6478C9E5B635C40B477F17EDC2E3640AAA10DC006625C40AC5AEF37DA313640
138	Monaco	0106000020E61000000100000001030000000100000005000000E0723106D6C11D40F67B7F83F6E0454040471FF301911D40CEA6954220DD45406090F469158D1D40DAD38041D2DF45402006820019AA1D40B2E67283A1E24540E0723106D6C11D40F67B7F83F6E04540
139	Palestine	0106000020E61000000200000001030000000100000005000000CCD03FC1C52A4140041E8A027D423F40A490F3FE3F2241403C3E213B6F373F40FC2CCF83BB1B4140FCD03FC1C5523F404C137D3ECA3E4140E44659BF99983F40CCD03FC1C52A4140041E8A027D423F400103000000020000000500000084A86DC328A44140DA8BDAFD2A4240409CECF483BAC641406A1BB803753240403C0E677E35BD4140D4949D7E507F3F40DC0F2384477141400C0C040132643F4084A86DC328A44140DA8BDAFD2A424040040000008C4E417E36A041402473F4F8BDC93F40140F45813EA14140F4C1FA3F87C93F406437177FDB9F41400429EB3713CF3F408C4E417E36A041402473F4F8BDC93F40
140	Montenegro	0106000020E610000001000000010300000001000000090000009087A2409F743240FE9C82FC6C484540584CDE0033B332405A2E54FEB5A04540C807043A933A3340B2EC10FFB0C1454080F755B950593440825D86FF74714540A02E19C7481234405E7347FFCB474540E0B5F63E55A533407EA52C431C4F4540D06A813D265E334022ABCDFFABEC44401072C284D1803240CEC1FA3F873945409087A2409F743240FE9C82FC6C484540
141	Mayotte	0106000020E610000002000000010300000001000000040000007CA86DC328A44640700BEBC6BB9B29C02C266F8099A14640487138F3AB8929C0DC0CE2033BA4464038747973B87E29C07CA86DC328A44640700BEBC6BB9B29C00103000000010000000400000044F04E3E3D9A464090402D060FB329C0DCBEB9BF7A8C4640D891EA3BBFF829C004068200198A464018333333335329C044F04E3E3D9A464090402D060FB329C0
142	Åland Islands	0106000020E61000000500000001030000000100000004000000D0FB3905F9353440121B498270FD4D40F04E0647C9FF3340A2A44E4013074E4070A7CAF78C3434402EEACC3D24084E40D0FB3905F9353440121B498270FD4D400103000000010000000400000068CDE50643453440925704FF5B074E40108E3D7B2E373440AE74B0FECF114E406034D6FECE4A3440CE00DE0209104E4068CDE50643453440925704FF5B074E4001030000000100000004000000C050A4FB39AD3340D2A6B1BD16144E4030CF83BBB3823340BADA6E826F164E4010068200199A33402E2F3201BF204E40C050A4FB39AD3340D2A6B1BD16144E4001030000000100000004000000F8488446B0653440265C8FC2F5184E40F8CDFE40B95D3440363E7782FD214E40A0F8F884EC7034400E18080264204E40F8488446B0653440265C8FC2F5184E4001030000000100000005000000D0488446B0153440FED5E3BED52C4E4070C554FA0947344036E78BBD17234E4010274D83A2F1334002A0C37C79054E40B0FB3905F9A533408618213CDA204E40D0488446B0153440FED5E3BED52C4E40
143	Norfolk Island	0106000020E610000001000000010300000001000000040000000F786000E1FE644020508BC1C3143DC0534CDE0033FD64409C52B3075A013DC00F7BA180EDFF6440A855F48766063DC00F786000E1FE644020508BC1C3143DC0
144	Cocos (Keeling) Islands	0106000020E610000002000000010300000001000000040000008260C77F813A5840489E0777676528C0B610AB3FC23958401077D844666628C06EA3737E8A3A5840D0942BBCCB4D28C08260C77F813A5840489E0777676528C001030000000100000004000000DA8E1B7E37375840C0B4C4CA686428C0E67B0DC171345840D8A57F492A5B28C0EE39E97DE3345840680F5EBBB44128C0DA8E1B7E37375840C0B4C4CA686428C0
145	Antarctica	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
146	Bouvet Island	0106000020E61000000100000001030000000100000004000000401381EA1FE40A405A8E90813C3B4BC080B5FB5580EF0A40012A1C412A334BC080E3A7716FDE0B405840683D7C334BC0401381EA1FE40A405A8E90813C3B4BC0
147	French Southern and Antarctic Lands	0106000020E61000000F000000010300000001000000040000000000008804745140000000C0CAD648C000000088C37051400000008056D448C000000048E172514000000040D8D248C00000008804745140000000C0CAD648C0010300000001000000040000000000008881325140000000404BAE48C0000000883E29514000000080FBAB48C0000000884E3351400000000007AA48C00000008881325140000000404BAE48C00103000000010000000400000000000088D366514000000080989A48C0000000881D625140000000802C9948C0000000C8696B514000000080979348C000000088D366514000000080989A48C00103000000010000000400000000000008F1505140000000C0A98B48C000000048D94D514000000000CE7B48C0000000C89B57514000000040757148C000000008F1505140000000C0A98B48C00103000000010000000400000000000008BE495140000000C0787E48C0000000C8384E514000000040956D48C000000008854F5140000000803D7248C000000008BE495140000000C0787E48C001030000000100000004000000000000486E5F514000000000FF7048C000000048B959514000000040CF6A48C0000000081A615140000000C01D6E48C0000000486E5F514000000000FF7048C00103000000030000000E000000000000081240514000000080146648C0000000080944514000000040538F48C000000008A646514000000080777F48C0000000C8E64D514000000040129048C0000000C8CD67514000000000317D48C00000004814525140000000C0DB9748C0000000084C65514000000040F8A648C000000088BA945140000000C0818648C00000004844A45140000000405C9F48C000000008957151400000004074B248C0000000083B9051400000008076D848C0000000482C695140000000C02DC048C0000000C80E335140000000C068DC48C0000000081240514000000080146648C00400000000000048E2795140000000C015BD48C000000048D1745140000000C081B648C000000088F475514000000040CFBA48C000000048E2795140000000C015BD48C00400000000000088C38051400000008035C948C000000048F37A514000000000ACC148C000000088797551400000000008C148C000000088C38051400000008035C948C001030000000100000004000000000000483C2B5140000000006B5248C000000088CA26514000000080E25148C000000088CA2A514000000040645048C0000000483C2B5140000000006B5248C001030000000100000004000000000000C80E33514000000070B84E48C0000000C86132514000000080E24948C000000008C834514000000000084948C0000000C80E33514000000070B84E48C0010300000001000000040000000000009091204A40000000808F3A47C0000000904E0B4A40000000809F3447C000000090EC204A4000000040643047C00000009091204A40000000808F3A47C00103000000010000000400000000000090E3E8494000000000103A47C0000000D072D34940000000C0E42F47C000000010D7E34940000000C0A92B47C000000090E3E8494000000000103A47C00103000000010000000400000000000010D822494000000080D11047C000000010A616494000000000000847C0000000D00E234940000000C0810647C000000010D822494000000080D11047C00103000000010000000400000000000048E2615340000000C06F5E43C000000048FB5F534000000040955D43C0000000086460534000000040195A43C000000048E2615340000000C06F5E43C0010300000001000000040000000000004877635340000000408EF342C000000008F85E534000000080EAEA42C0000000087C635340000000C047E942C00000004877635340000000408EF342C001030000000100000004000000000000D0FE60454000000040331331C0000000504D5C454000000000390E31C000000090E3604540000000004A0F31C0000000D0FE60454000000040331331C0
148	Heard Island and McDonald Islands	0106000020E61000000100000001030000000100000004000000D2C1FA3F8771524036FE0B0401904AC05276FA415D5E5240FFF63C7FDA984AC05240DAFF004F5240593D27BD6F7E4AC0D2C1FA3F8771524036FE0B0401904AC0
231	Palau	0106000020E61000000700000001030000000100000004000000A38FF980408760401016E0BBCD2B1540A14A0680AA86604090D5AD9E933E1540B5D7BB3F5E87604050944E24983A1540A38FF980408760401016E0BBCD2B154001030000000100000004000000C373B68050C56040E09ACB0D868A1B405B9D634076C46040308A778027BD1B402B266F8099C56040C0AA24B20FB21B40C373B68050C56040E09ACB0D868A1B4001030000000100000004000000139337C0CCC860404079E750860A1C401DD2A8C049C7604030F75AD07BF31B40553A58FFE7C86040F0E8297288481C40139337C0CCC860404079E750860A1C40010300000001000000040000009F44847F91CC604020861DC6A48F1C40031555BF52CB604010B8239C16AC1C4019AE0E8038CC6040602E1A321EC51C409F44847F91CC604020861DC6A48F1C40010300000001000000040000002F65E08016CC60402097715303DD1C40F9C08EFF02CB6040206AC020E9131D401BC3633F0BCE6040F0FCDCD0941D1D402F65E08016CC60402097715303DD1C4001030000000100000004000000DD03ADC010CF6040E008E1D1C6711D4061A3E5408FD06040E09BFD81723B1D405B76887F58CE6040E069C020E9531D40DD03ADC010CF6040E008E1D1C6711D40010300000001000000040000008BBD50C0F6D1604090E733A0DE7C1D4045C2F7FE86CF6040A0874F3A91C01D4009336DFF4AD46040F00D315EF3EA1E408BBD50C0F6D1604090E733A0DE7C1D40
152	Vanuatu	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
153	Nigeria	0106000020E61000000300000001030000000100000004000000A0DBF81395DD1D4020A5A2B1F6C71140C0AB1F9BE4571D408051BD35B0C511400022DFA5D4A51D40B0989EB0C4F31140A0DBF81395DD1D4020A5A2B1F6C7114001030000000100000004000000408ECC237FD01C40C051BD35B085114080313D6189E71C4060AE47E17A141240C0E3A25A44441D4000713D0AD7E31140408ECC237FD01C40C051BD35B08511400103000000010000002F000000405EBC1FB77F1740C86E2EFEB67F2B4040A3755435B11940C81B62BCE6352B40203E4162BBBB1B4018C53BC093FE2940C0F5285C8F421F40E08FDB2F9FB42A40505E9ECE15452340D854A4C2D89A2940F0D03FC1C572254080116DC7D4C52A40D0DE52CE17EB2840E0CF0D4DD9212A40B02688BA0F402B40B8F292FFC96F2B4000B728B341262C40E074B0FECF292A40B0F755B950592C40D0DE52CE17CB2840F0B837BF614A2D40F094490D6D602840A01EA33CF34A2D4028FBAF73D3262740D05A99F04B9D2B4008240C03961C2640E07C410B0998294008068200198A2140A0C2137AFD812840F8003274ECD0204080A148F773BA2740F0012D5DC1561C40602975C938AE2640A0FDD7B969C31940C014AE47E13A254030B728B341461C40E05626FC52972340104391EEE7341B401007B47405BB214060416491265E1740209A7B48F82E2140201F4DF5643E134000E5D4CE30B51E401082C8224DFC1140E0F0D8CF62491C4070634337FB031340803C0FEECE4A1C40206893C327BD114000F855B950D91B40802A8E03AFE612404051BD35B0051C4090D026874F7A1140C01D8A027D121B40F0F755B950191340001B3048FA641B40609AD024B1641140C0DB2F9FACE81A402052B81E856B124080FBAF73D3C61A4030B81E85EB511140006CED7DAA6A18406046B41D53171140C07E6E68CACE154030A3755435B11340C03E3C4B9061154020B81E85EB5115408020B248138F1640E01A3048FA24164000403734650715409070422102BE1540A0A9F23D23011640807A19C5727B1640C0D576137CB314408032384A5E4D164060A148F7731A1240904069A85138194000EE7E15E01B0B40C0F30016F9C5194040E6D4CE30750E4030D576137C731A40800B60CAC0C10540601956F14676194080301004C8500640B05FE97C7816224040F6285C8FC2084078FA96395D2E224080A4703D0AD70E40C8622AFD842B2540002FA699EED50C40A8554ACFF462274060B81E85EB911040200C040132F42A40405EBC1FB77F1740C86E2EFEB67F2B40
154	Netherlands	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
160	New Zealand	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
155	Norway	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
156	Nepal	0106000020E61000000100000001030000000100000018000000365F97E13F84544004821DFF05EA3B40E6637781920354403CE44A3D0BD63C401687A5811F185440A4A70183A4BF3D401AA88C7F9F415440ECD66B7A50343E408654C37E4F4E5440A4E67283A1023E406ADCD440F35A54402C085740A1623E402AFC523F6F865440A409DCBA9B573E40EE57738060E354400CA6457D922F3D403EA79201A007554094069B3A8F423D4052137D3ECA1E5540A445F0BF95BC3C40FAC95180284C55407CBAF3C4739A3C402A145B41D3465540B40A7F86374F3C40BE490C022B6E5540E440F33977473C40BE3AC780EC80554054C2137AFDE13B407E6F0C01C08B5540CC5E7D3CF4293C403E9ECF807A9C5540C419C40776E83B40127BA180EDAB55403C0ED940BA1C3C4092D5E6FF55CC5540D4F06778B3D23B405E880E8123095640A489CDC7B5DD3B403E7D04FEF0005640CC3A71395E5D3A4066D0D03FC176554074C2137AFD913A40961ADA006C095540A4992842EA823B409A08C6C1A5D25440AC5FE97C78563B40365F97E13F84544004821DFF05EA3B40
157	Nauru	0106000020E61000000100000001030000000100000004000000136F9D7FBBDD64408037C478CDABE1BFBF310400C7DD644000664293C492DFBFD3CABDC0ACDE644080B941B45634E0BF136F9D7FBBDD64408037C478CDABE1BF
158	Suriname	0106000020E610000001000000010300000001000000130000009877634161904BC0E09D0AB8E74917408457923CD7034BC0508B6D52D148174054198D7C5E154BC0802CB649456315405067B5C01E3D4BC0C0CDFE40B9FD1240ACC8E88024004BC080BDA59C2F960B40B870E7C2484D4BC0000EF8FC30A202404CA69883A0FB4BC0E07C789620430440A08F87BEBBF34BC00079280AF449FE3F5C3123BC3D3C4CC040AFC1FBAA1CFF3F58A3570394A64CC040EB51B81E050B40DCCD8C7E34D24CC0A03CDD79E2D90A40A8C266800B064DC080E9297288081040488B4F0130F64CC0D0921CB0AB4913407CB74082E2A94CC0A0438CD7BC1A144030F20703CF9F4CC070E7FC14C7F11540549DD5027B7C4CC010C64FE3DEFC17404CE9D2BF24F34BC0E0AE97A608B01640D4C4C9FD0EEB4BC0D0C77C40A0D317409877634161904BC0E09D0AB8E7491740
159	Nicaragua	0106000020E61000000500000001030000000100000004000000C24659BF99ED54C0F8230C0396BC2740B8559E40D8EE54C080DC2A8881CE27406CEEE87FB9ED54C0285DC136E2F92740C24659BF99ED54C0F8230C0396BC274001030000000100000004000000940854FF20C354C0D089592F864A28405A4C6C3EAEC354C0185FD042025E28403CD7BE805EC154C0201286014B5E2840940854FF20C354C0D089592F864A2840010300000001000000040000006A0F4240BEBD54C010A26131EA9228409AFC4FFEEEBE54C0E0B2B5BE48A02840546AF6402BBE54C0C021E4BCFF9F28406A0F4240BEBD54C010A26131EA92284001030000000100000004000000E86305BF0DB054C0F0E4D4CE30B52C407CA279008BB254C08821E4BCFFBF2C4000FDBE7FF3AE54C0E05FE97C78D62C40E86305BF0DB054C0F0E4D4CE30B52C40010300000001000000150000009A35B1C057CF54C098C554FA09F72D407A3C2D3F70C854C0003B55BE67FC2D40061E1840F8DA54C030F52D73BA9C2D4016BD5301F7CB54C090116DC7D4A52C403ED13C8045E354C0102A8E03AFE62A40ACB9A3FFE5DE54C0D06DFC89CACE2840AE8C463EAFE654C050DF6B088EA32940322FC03E3AF554C0182FDE8FDBBF27409C7422C154E954C0889BC58B85D92540D6E5948098FA54C0082C9D0FCF6A25402647C8409E4555C0200D36751E0526409853C900506C55C0C000A777F126264038D47D0052EC55C0406211C30ED32940A4D1AB014AD355C060880E8123F9294072DFA3FE7AAC55C0E87C410B09982A40CA940F41D5B055C060F9BB77D4802B401AC09481038155C0C00F5EBBB4212C40ACD7BB3FDE6E55C0A0656B7D91A82B4040C2F7FE063A55C0505FD042029E2D40B2B9A3FFE51E55C0507156444D3C2D409A35B1C057CF54C098C554FA09F72D40
161	Paraguay	0106000020E610000001000000010300000001000000130000000433DFC14F2A4BC0C04CA25EF0AD38C0AC0A293FA94C4BC0905016BEBE9239C09CD72D0263594BC02CB1F9B836703AC0208C2D0439DE4BC0FC63AF777F703BC09838F240644D4DC0586A12BC21513BC02C53CC41D0C94CC0F0EA387EA88C39C09892C83EC8E04CC0D4307C444C2D39C0ACBF2500FF804EC02CB1F9B836D037C0081B65FD66524FC098EA3BBF283D36C0D8A3703D0ADF4EC08CEB51B81EA533C004D3307C448C4DC000D671FC505933C084785DBF60134DC0B8415F7AFBD333C0A8D4EC8156144DC078E5CFB7052B34C004B2D7BB3FE84CC0EC71C284D1F834C0BC0776FC17FE4CC0CCE369F9811736C024508BC1C3EC4BC0D01BB5C2F44936C0C8EB1681B1B44BC0B0389CF9D5F437C02C86AB0320344BC02C4A09C1AAEA37C00433DFC14F2A4BC0C04CA25EF0AD38C0
162	Peru	0106000020E6100000010000000103000000010000003A00000082785DBF60AD53C0F0804067D25612C0BC4659BF999553C000BF9B6ED9610BC07872DBBE472A53C0602CCF83BB9304C080B1BE81C9E352C0C0A239B2F28BF8BF72543541D4CD52C000D7B45208E4EEBF88CC237F30E852C00010E0F42EDEBBBF923270404BD252C000909CDA19A6BEBF6AEEE87FB9B152C0000AF6ED2422CABF80A279008B8E52C040C51858C771F0BF00E8F7FD9B6352C080707495EEEEF5BF7C9CF7FF713852C0E06E10AD150D04C068EBA7FFACEC51C0E07B0A80F12C01C0C43D963E749251C000D7A3703D0A04C042D47D00528451C0E05EB2F1600B06C0E6758BC058AE51C0A0828769DF3C0EC07A30293E3E7D51C000170D198FF210C014C0948103B151C0F0F97DFFE69510C010A20A7F863652C0005EBC1FB77F14C042BC75FEED4752C040137CD3F4C919C064E8667FA06F52C0D08FBDDEFD811BC064EBA7FFAC8052C000A8C5E0612A1EC0FEED79FEB43D52C0F816D68D77F721C05A880E81234D52C0A05B76887FD022C0D6DCD1FF721752C09046AF0628FD22C0260E677E350952C00014950D6B0224C0900854FF20D351C01830F2B226FE23C0661B4641F0A051C0884F73F222DB22C0147B2FBE68A851C098677A89B10426C09C776341616451C068F9D687F5E625C030293E3E212B51C0E0C798BB960029C0F096E4805D3E51C03039B5334CBD29C0D6E59480983651C088E28E37F9652CC0D4DCD1FF725751C008F3C98AE19A2DC028508BC1C34851C0487D3CF4DD7D2EC0EE60C43E015B51C0A82094F7713C2FC080A8FB00A43451C02CA2B437F85630C002E8F7FD9B6751C030A2B437F83631C092FF907EFB5F51C0AC52B3075A8131C00218963FDF7C51C0D427B9C3263E32C0FCFCBE7FF39951C0282FC03E3A5932C06E15C440D7DF51C02CA5F5B7044C31C0BE61A2410AC352C0C0A8C0C936F02EC0A88F87BEBBFB52C088DF4DB7EC502DC0280E677E351953C000F4FBFECDCB2BC0148733BF9A0C53C0408B4F0130D62AC0D60FB1C1C26953C00847C8409E9526C09635B1C057BF53C070EA1F44327420C0ACB9A3FFE5FE53C0F05C8AABCA0E1BC0806C59BE2E4B54C0D091EA3BBF5818C01AB14F00C53754C0F0CB9A58E09B16C07EA279008B5254C0100AD7A3703D11C080B1BE81C91554C04093347F4C0B0BC02853CC41D00954C0A0A83121E6120FC0FEF97DFFE61D54C0609A8F6B43E50FC06C1B4641F01D54C0802A52616CC111C05646EA3D95E953C050B6F1272ABB11C03280B74082C353C0406325E6590914C082785DBF60AD53C0F0804067D25612C0
163	Pakistan	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
164	Poland	0106000020E6100000010000000103000000010000002A000000D0D90242EBD93240A6AD11C138C24840889065C1C4933240FA0241800CF54840F817080264A83140B29509BFD40D4940D05D4BC807B93140D67C957CEC284940A87A32FFE8E33040524F1F813F384940A8656B7D910031407A9065C1C41B494030F6D03E56A430408696E7C1DD0D494020895E46B134304082AEEFC3413649400021CB82895730407E87A2409F544940506552431BA82D40D276137CD36E494020EFAB72A1122E4032232E008DA4494010A26131EA322D4006301004C8E8494000D48041D2472D40D20F238447494A40005A677C5F4C2C40AADA6E826F6E4A4020CA6DFB1E8D2C406EDFA3FE7AD94A4070A148F7733A2D405A01F73C7FE84A40300AF5F411702C40224DBC033CEF4A4060E6E8F17B732C40AE77F17EDCF64A40E8AF743E3CEB3140AA74B0FECF694B406831957EC255324026E78BBD176B4B40001B498270BD3240A66E2EFEB6574B4030D2C43BC06732407EA52C431C5F4B4038ED0DBE30953240AE6E2EFEB6374B4060C422861DD632407ECC07043A2D4B409027F4FA93A033408A93347F4C3B4B40082A8E03AFA633404E55A181583A4B40083F5585063A3340822766BD182A4B40F8AE97A608CC3340B62E6EA301384B40B06A65C22FC9364066855B3E922E4B4030E0F3C308813740BEEFDFBC38F94A408018213CDAF0374056EFE2FDB85D4A4038C286A7572A37401639B69E21244A4020FF93BF7BA33740D68BDAFD2A0A4A402815713AC99A37409EA17F828BC34940E04334BA831C3840A6656B7D9148494098336ABE4AAE3640DA0F238447C9484018D6E3BED5E23640AE59677C5F804840B077F17EDC8E3640D28BDAFD2A8A4840B8DA6E826F9E35405637177FDBB74840306211C30E133440AADA6E826F9648401873F4F8BD7933402AD505BCCCCC4840D0D90242EBD93240A6AD11C138C24840
165	Panama	0106000020E61000001000000001030000000100000004000000000000F8D47154C000000080051B1D40000000400A7354C00000008041E71C4000000040647454C000000080F6281D40000000F8D47154C000000080051B1D4001030000000100000004000000000000802C4D54C00000008058F21D4000000080FB4F54C0000000800DF41D40000000C0264254C00000008088481E40000000802C4D54C00000008058F21D400103000000010000000400000000000080906954C00000008063891D4000000080F27754C000000080E6F61D40000000408D7054C00000008063891E4000000080906954C00000008063891D400103000000010000000400000000000040A64654C00000008001DF1E40000000008C4954C00000008077F71E4000000080F24754C0000000801A091F4000000040A64654C00000008001DF1E400103000000010000000400000000000000944A54C000000080864A1F40000000801C4B54C000000080B0451F4000000040544A54C000000080DD5D1F4000000000944A54C000000080864A1F4001030000000100000004000000000000C0CB9554C0000000C0CC2C204000000000739754C0000000C0822D204000000080769454C000000040F9452040000000C0CB9554C0000000C0CC2C20400103000000010000000400000000000080A78D54C0000000C01E65204000000000E69254C0000000C020632040000000C00D9454C0000000401270204000000080A78D54C0000000C01E65204001030000000100000005000000000000C0479554C0000000C09B772040000000F8D49954C0000000409081204000000000839554C0000000C0C2952040000000801B9454C0000000C0178B2040000000C0479554C0000000C09B7720400103000000010000000400000000000040D8C653C000000040F8662040000000803DC653C0000000404B9E20400000000093C353C000000040B680204000000040D8C653C000000040F866204001030000000100000004000000000000C0E3C453C0000000404CBD20400000004053C753C0000000409FD4204000000080DAC453C00000004035D12040000000C0E3C453C0000000404CBD204001030000000100000004000000000000407DB653C0000000C0C4932040000000F862BD53C0000000409E9520400000004075BD53C000000040FAE42040000000407DB653C0000000C0C49320400103000000010000000400000000000000F68054C000000040B6402240000000C0258354C000000040D049224000000000EF8254C0000000C04F5A224000000000F68054C000000040B64022400103000000010000000400000000000040118554C0000000C0A291224000000000F78754C0000000403C8B224000000080358D54C0000000C058B2224000000040118554C0000000C0A291224001030000000100000004000000000000805D8E54C00000004085AB224000000040AF8E54C0000000C0CCAC224000000000628E54C0000000C07AB42240000000805D8E54C00000004085AB224001030000000100000004000000000000C04E8F54C0000000401AA9224000000000209454C00000004075D92240000000C0889054C0000000C0BBDB2240000000C04E8F54C0000000401AA9224001030000000200000023000000000000C0A2DD53C000000040D8222340000000C0468253C0000000C0C275224000000080775753C0000000C099592140000000C0CB4D53C000000080B7BF1F40000000C0BA6453C000000080E2191E4000000080C96F53C0000000808EE31E4000000040F17853C00000008062EA1C4000000040B79B53C000000040981A204000000080769053C0000000403234204000000040E88853C0000000C0CACE204000000000DE7153C0000000405C4F204000000080E18653C0000000C062E92040000000C0819A53C0000000C036B02040000000C0A1BE53C0000000401A492240000000C04F1E54C000000040F16C2040000000C057FF53C0000000807F101E40000000C0BB1B54C0000000804FFA1C4000000000383B54C00000008000001D4000000040B74354C0000000804B7E1F4000000080724B54C000000080836B1F4000000040F04D54C000000080CB6D1E4000000000CE5F54C00000008060CB1E4000000080456F54C0000000403353204000000000498C54C0000000408E63204000000000629254C0000000406DA020400000000030AE54C0000000C06AA22040000000B886B954C0000000C0240D2040000000807EAD54C0000000C0BADC214000000080D2BB54C0000000407EF122400000008011A454C00000004031202340000000402A8F54C0000000C0DCFE2140000000C03F7454C000000040FBE32140000000C0917854C0000000C050592240000000408D4C54C0000000C0808F2140000000C0A2DD53C000000040D822234004000000000000402A7F53C0000000C0047C2040000000C0807F53C0000000C04880204000000040328053C0000000C091802040000000402A7F53C0000000C0047C2040
166	Portugal	0106000020E61000000800000001030000000100000004000000000000803D1A31C0000000D062694040000000C02EB730C000000050236140400000008090F130C00000009099514040000000803D1A31C0000000D06269404001030000000100000004000000000000802C4930C0000000900D8C4040000000008B6630C000000010F1844040000000C0575330C0000000D0D48D4040000000802C4930C0000000900D8C40400103000000010000000400000000000040320439C0000000D01F7C4240000000C0573339C0000000D02F7E4240000000C01D1639C0000000900583424000000040320439C0000000D01F7C424001030000000100000004000000000000C0C29539C000000010D0E94240000000805EDD39C000000010DFEC4240000000005A2139C000000090E4E74240000000C0C29539C000000010D0E94240010300000001000000040000000000000020243CC0000000D09539434000000000AC093CC0000000D01634434000000080A88C3CC0000000107C4343400000000020243CC0000000D095394340010300000001000000040000000000000042163BC000000050D1504340000000808F623BC0000000D0B461434000000080DA103BC000000010D06143400000000042163BC000000050D150434001030000000100000004000000000000C02E373FC0000000103AAD434000000080C1363FC000000010CFC24340000000C0801F3FC00000001075B94340000000C02E373FC0000000103AAD43400103000000010000001400000000000080D16820C0000000D0F6EF4440000000006D601AC0000000D00FFA444000000000B7BF18C00000005034CA44400000000007BA1BC0000000904F82444000000080A2111CC00000005066D643400000000049211EC000000090AFD5434000000000B5D11BC0000000906083434000000080D1481DC0000000508739434000000000B5C11BC000000090CA16434000000000ACC91DC00000005087D942400000000038BA1DC00000009068A04240000000C005FB21C000000050F382424000000040BF5821C000000050FA344340000000C0265E22C000000050B93543400000004009F821C0000000D0507943400000004009F822C000000050E15A4340000000C0585221C0000000D0F6574440000000C0717D21C000000090EBF94440000000C0066720C0000000108D13454000000080D16820C0000000D0F6EF4440
181	Lesotho	0106000020E6100000010000000103000000010000000800000018C45DBD8A903B4050CA4E3FA8673EC060B950F9D7023B4074E8103812A03DC008301004C8903C40FC868906299C3CC0F81186014B6E3D401C35423F53473DC0E0AF743E3C2B3D40CC1BB5C2F4E93DC0602E54FEB5603C40F4332E1C08293EC090BD50C076143C40CC21C50089A63EC018C45DBD8A903B4050CA4E3FA8673EC0
182	Botswana	0106000020E6100000010000000103000000010000001B00000090A6D0798DF53A409823B9FC87C037C00818080264D83A40D88EA9BBB24338C0E028EB3713DF394044A3570394BE38C0101E8A027D82394000E275FD82AD39C0E8D9ACFA5CAD384004D80E46ECD339C050EFAA07CC03374020CB10C7BA4C39C0383F8D7BF39F3640C8601A868F1C3AC06034D6FECEAA3540CC307C444CDD3AC0E0BEB9BF7AA43440A8415F7AFBD33AC0C06E2EFEB6CF34407469183E22E239C0703123BC3D003440C41858C7F1C338C00809C38025FF33408872DBBE470136C0087FF8F9EFFD34400CD0EFFB37FF35C02093C5FD47FE3440947DC9C6835132C0506117450F4C3740D87B7F83F6FE31C028231285969D3740AC4D637B2D7C32C028D505BCCC5C3840D0976C3CD8F231C0700C01C0B14339404437894160CD31C088812040862A3A40048448861C8733C0D03730B951383B404C1F0F7D771734C01823128596493B402CAAB706B67E34C0E8A63FFB91B63B40D4A50D87A58134C050431B800D043C4020D714C8EC9035C0009C5088800F3D409C4F72874DCC35C0A808C6C1A55F3D40546C21C8413136C0D059677C5F4C3C4020A5F5B7049C36C090A6D0798DF53A409823B9FC87C037C0
183	Senegal	0106000020E6100000010000000103000000010000002200000030BC5983F72531C070B8E4B8533A2D4050A01683878931C0386C06B820832D4008F73C7FDAE030C0B05417F032732E4020C98FF8158730C0DC9D7C7A6C0F3040D89AADBCE44730C0140341800C853040700E2C47C8B02CC0BCDDAF027CA33040A0F63FC05A7D28C0181B81785D872D402039B5334C1D28C0C0ED974F56542B40E01C588E90C126C0485DC136E2F92940A0054B7501BF26C07851F4C0C7D0284090D007CBD8B028C04844BFB67E9A28400001158E206D2BC02054FEB5BC5A294030A9D903AD082DC0A0BEA085045C2940C80C54C6BFB730C0A0C24A0515A52840F88C0B07429630C028634337FB43294010C85EEFFE402FC09017EFC7ED0F294090D00836AEC72EC010356090F4A9294030ABE80FCD4C2FC0284278B4711C2940C82478431A9930C0F8B5F63E559529404825917D90C130C0908B868C47212940A86A494739C030C048062B4EB51E2A4030A35703949E2FC008F86EF3C6512A4080583508739B2FC0E0AA24B20FB22A40D0963AC8EB912EC0C06E2EFEB6BF2A40E004508C2C392EC070C1E10511312B404077BAF3C4B32CC0A06ABB09BE792A4020529ACDE3982BC0F009F5F411D02A40A0415F7AFB232EC0C8AD65321CA72B400054C6BFCF9030C02069C537142E2B40B0AA5E7EA77D30C0E089592F86EA2B40A0D1AB014ABF30C0403F373465E72B40D09DEE3CF15C30C0200341800C552C40D006EE409DC630C04877D84466062C4030BC5983F72531C070B8E4B8533A2D40
167	Papua New Guinea	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
168	Guinea-Bissau	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
169	Qatar	0106000020E610000001000000010300000001000000070000004C5E9D6340C24940B4CB457C27623940FC1186014BCE4940ACE67283A10239406CA3737E8A9B4940A47A1684F29E38401C3526C45C6A4940AC1C93C5FDBF3840FC1A4982708549407C0C1D3BA80C3A40542E54FEB5C84940B4E0F08288E839404C5E9D6340C24940B4CB457C27623940
170	Reunion	0106000020E61000000100000001030000000100000004000000AC984A3FE1DA4B40D082A5BA80FF34C0FC1186014BD64B40244D4A41B75F35C0ACA78FC01F9C4B40F88348861C0735C0AC984A3FE1DA4B40D082A5BA80FF34C0
171	Romania	0106000020E6100000010000000103000000010000001A000000F0A90EB919BA3440323E05C078164740B050A4FB392D3540B29509BFD4254740D83730B951083640DA7954FCDFC347408854FCDF11E53640AE5CE15D2EFA4740209A417C60EB384032E78BBD17DB4740A81F46088FA23A40B2DAFCBFEA20484080C6F7C5A51E3C4032C93A1C5D6D474070DF15C1FF363C406E39D0436DB9464028B8AE9811AA3D40F218575C1C9B4640F82D01F8A78C3D40767E5182FE684640F8544E7B4ADE3C409ECB9BC3B57846409896917A4F953C40FA0B76C3B6DF4540F8B0A54753093B4072361D01DC12464070CADC7C236E394016EDF1423AD045402069C537142E38405A0ABABDA4D74540A001BC0512E03640D2F4D901D7EB454000904C874E0B3740DEEE5701BE09464098592F8672AE364076309B00C31C4640B06186C6137536404A4C50C3B73C464078F01307D0C33640462234828D474640B06BED7DAA7A364082992842EA5A464000A0C37C79253640DAB5F63E553D46404862BB7B80663540767B1002F2634640B0DDAF027C833540FA14C78157934640A0780778D24234407E6CCB80B30E4740F0A90EB919BA3440323E05C078164740
172	Republic of Moldova	0106000020E6100000010000000103000000010000000B00000080C6F7C5A51E3C4032C93A1C5D6D4740A81F46088FA23A40B2DAFCBFEA204840C05CA8FC6BC13B40DA73D2FBC6394840D017B5FB55243D40866C3D4338FE4740A80A7F86372F3D40AECB9BC3B5B84740584CDE0033F33D40D6EB8843366847401898A3C7EF1D3E40F6F9EFC16B314740E007043A93FE3C400AEEEBC0393D474080D66EBBD0F83C40CEB56801DA00474070DF15C1FF363C406E39D0436DB9464080C6F7C5A51E3C4032C93A1C5D6D4740
184	Slovenia	0106000020E61000000100000001030000000100000010000000B036548CF36F2B40625B3FFD6743474060C554FA09172D407AA86DC3283447409087A2409F1C3040B25626FC526F47408827D87F9D9B3040269F573CF53C474088069B3A8F923040FED5E3BED53C474090F1D3B8374F2F40DEA6B1BD161C474080CDE50643652F404E431B800DEC4640400D198F52592E40FE81AB3C81B64640A07A32FFE8332D40A6DA6E826FD646409078978BF82E2B4072CA4E3FA8BD46408020B248136F2B4056F5F23B4DCC46401020990E9DD62B402A266F8099D1464030295C8FC2F52A40AE5CA8FC6B0147400020990E9D562B40868D2441B8164740A023F3C81FC42A4032E44A3D0B264740B036548CF36F2B40625B3FFD67434740
185	Sierra Leone	0106000020E61000000200000001030000000100000004000000C09DEE3CF10C29C0C06ABB09BEB91D4030B29C84D2E729C030F30016F9451E40D08B683BA62E29C040931CB0AB891E40C09DEE3CF10C29C0C06ABB09BEB91D4001030000000100000010000000A0942BBCCB6D26C010965D30B8FE234080A04D0E9F2425C0A02172FA7A1E2240E0D2307C446425C0C0737E8AE398204020E4D87A868824C0D83CD68C0CFA2040009D0FCF12FC26C080AAD55757B51B40001B2B31CFEA29C0A099999999991F4070C404357C932AC0705FD04202FE2040C0AE42CA4F1A2AC030F52D73BABC204050CA8635953D2AC0F059677C5FEC2040E040464085CB29C0E8C64ACCB3222140506EF7729F542AC000C2FA3F87092140508FC2F5287C2AC0C014AE47E19A2140C08EA9BBB2432AC078F755B950B92140A0BDA4315A972AC058971B0C7510224030A0168387E928C000FBAF73D3C62340A0942BBCCB6D26C010965D30B8FE2340
186	Singapore	0106000020E610000001000000010300000001000000040000005258E20165FF5940009E5DBEF521F63FFAC08EFF02E95940806D5166830CF53FEA69F981ABED5940006AF7AB00DFF63F5258E20165FF5940009E5DBEF521F63F
187	Somalia	0106000020E6100000010000000103000000010000001D0000002C35B401D87845400089B48D3F012640CCB8A981E69F454068B8ACC266F02640D4C77C40A023464058CDE50643E52440D4FD9C82FC724640A85626FC52D72440CC0F238447E14640C8E1934E24C025405CF833BC59394740F0251B0FB66025402C6211C30EB34740E0B0A6B2285C26407C1EA33CF30A494060C422861D062740FC1D8A027D624940D8B5F63E55F52740ACDDAF027CA34940A059677C5FAC2740A474B0FECF814940D8C64ACCB3E224408493A641D1B44940A84E5DF92CE724405C34D6FECE72494078B08D78B2A32440DCA3703D0A6B494048BE124889DD2240D48BDAFD2AFA47402007B47405DB1140FCD8243FE201474080963FDF166C0340FCC35DBD8ABE454080D9EDB3CACCE43FEC7B0DC171C7444080DE516342CCFABF0CD3A23EC97F44408096766A2EB7EBBFE4B2B5BE487E4440C0F3A8F8BFA306408C352383DCF34440E0648C0FB3D70F405437177FDBD74540207497C4599113404C8BC1C3B4794640C0B0A6B2289C13401CC022BF7EFE4740A05E0D501A022040DCC1FA3F87814740C0656B7D910020405CF833BC5901464058B08D78B203224034232E008D6C4540001E8A027D72244084397AFCDE544540B0703D0AD74325402C35B401D87845400089B48D3F012640
245	South Georgia South Sandwich Islands	0106000020E6100000090000000103000000010000000400000000DCF3FC69533BC0B08C463EAFB64DC0B84F72874D4C3BC0A9014A438DBC4DC0D08827BB99693BC0F6E7F7FD9BB74DC000DCF3FC69533BC0B08C463EAFB64DC001030000000100000004000000A0CB290131953AC0D2BE47FDF5884DC0B0CE6A813DAA3AC0A6F204C24E834DC06891D10149803AC0504FADBEBA844DC0A0CB290131953AC0D2BE47FDF5884DC0010300000001000000040000006007077B133F3AC02D0B26FE28344DC0304D4A41B73F3AC07F36397CD23F4DC00067F0F78B753AC0A68C463EAF364DC06007077B133F3AC02D0B26FE28344DC001030000000100000004000000E068FF03AC693AC0509A94826EE74CC0A04A22FB20833AC0A7AD9FFEB3E24CC0B823D5777E713AC007D0EFFB37DF4CC0E068FF03AC693AC0509A94826EE74CC001030000000100000004000000680D897B2CA93AC0D2C4C9FD0E8B4CC0E869317898BA3AC07963963D09884CC0E87DC68503AD3AC008D0EFFB37874CC0680D897B2CA93AC0D2C4C9FD0E8B4CC001030000000100000004000000E0F3FBFECD1B3BC08657923CD75B4CC0B02FD978B0353BC0A092C83EC8584CC058880E8123213BC02E35423F53574CC0E0F3FBFECD1B3BC08657923CD75B4CC001030000000100000004000000D079E2395B903BC07CC0030308294CC0D88827BB99993BC07CBDC282FB234CC008EB387EA88C3BC0AAC5A70018234CC0D079E2395B903BC07CC0030308294CC001030000000100000004000000D89DEE3CF18442C0769F38807E414BC0ACAD9FFEB38A42C0AF8905BEA2414BC0DCE253008C8D42C0DAD30E7F4D3C4BC0D89DEE3CF18442C0769F38807E414BC001030000000100000008000000003620425CBF42C0CED64FFF59014BC00818963FDF2442C079E49D4319224BC0200B26FE28E441C0D3A02FBDFD614BC05C552FBFD30E42C05025917D90714BC0F8EA387EA8B442C0FFB759BC58224BC09807CC43A69E42C02AFCE07CEA124BC0806F9A3E3B0443C03111A8FE41064BC0003620425CBF42C0CED64FFF59014BC0
173	Philippines	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
174	Puerto Rico	0106000020E61000000400000001030000000100000004000000C637143E5BF850C0A459677C5F0C324012A54BFF92FB50C0F4A6B1BD161C3240528B4F0130F650C0CC622AFD841B3240C637143E5BF850C0A459677C5F0C324001030000000100000004000000EA6F09C03F5C50C08CA52C431C17324054880E81236550C0DC3A71395E1D32403CD13C80455350C094116DC7D4253240EA6F09C03F5C50C08CA52C431C173240010300000001000000040000009441B5C1894F50C0DC3A71395E4D32402447C8409E5150C024DB87BCE546324082AB3C81B05550C05CB3CEF8BE5832409441B5C1894F50C0DC3A71395E4D32400103000000010000000500000078B1BE81C9BF50C01494BF7B47813240D8E59480986650C0AC622AFD843B324090FF907EFBCB50C0948D2441B8EE31409602D2FE07D150C0CC31AEB8385E324078B1BE81C9BF50C01494BF7B47813240
175	Russia	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
176	Rwanda	0106000020E6100000010000000103000000010000000A000000789065C1C4F33D404049D74CBE7902C0A874B0FECFD93D40206AC020E91306C088AEEFC341063D4080E4D4CE30F505C0081286014BDE3C40C0D38041D22703C08893A641D1983D40C0F5BA45602CF6BF68AA0B7899F93D4040A75CE15D6EF7BF287A19C5727B3E40C0982B836A03F1BF583A58FFE7E43E4080ED7E15E09B00C0E8D03FC1C5923E408023D5777E3103C0789065C1C4F33D404049D74CBE7902C0
177	Saudi Arabia	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
178	Saint Kitts and Nevis	0106000020E61000000200000001030000000100000004000000FCF0BA7EC1464FC0246552431B183140F4E7F7FD9B4F4FC0E44334BA831C314024508BC1C34C4FC0041E8A027D323140FCF0BA7EC1464FC0246552431B183140010300000001000000040000001853CC41D0594FC08CAEEFC3415631407063963D09504FC09CE0F0828838314058A35703946E4FC0F457C9C7EE5E31401853CC41D0594FC08CAEEFC341563140
179	Seychelles	0106000020E610000007000000010300000001000000040000002CDB87BCE53E4740203201BF468223C02C3B3602F13C47406086FF74037D23C07C457EFD10414740C882A5BA806F23C02CDB87BCE53E4740203201BF468223C0010300000001000000040000005CF833BC59414740588E90813CCB22C0441DACFF73224740005E9ECE15ED22C0DC066003221A4740C01D537765C722C05CF833BC59414740588E90813CCB22C001030000000100000004000000AC9ECC3FFA34474020A8A78FC0B722C04C793BC2692347404092037635B122C03C29B000A6364740C082A5BA80AF22C0AC9ECC3FFA34474020A8A78FC0B722C0010300000001000000040000009CA78FC01F244C4010CFF41263891CC0640ABABDA41F4C40307B0F971CC71CC0742B137EA9234C40C023D5777E711CC09CA78FC01F244C4010CFF41263891CC001030000000100000004000000B4BF97C283C44B40E010548D5E0D13C02CEACC3D24B04B40403201BF468212C0DCD03FC1C5BA4B40B05D85949F3412C0B4BF97C283C44B40E010548D5E0D13C0010300000001000000040000002C20ED7F809F4B40607B0F971C0712C01448A643A79D4B40301B2B31CFCA11C03C6BD44334A24B40701E4E603AED11C02C20ED7F809F4B40607B0F971C0712C0010300000001000000040000002C14E97E4EE34B404078EC67B16411C07C9C69C2F6D74B4080666666662611C0CCD03FC1C5E24B40B039B01C214311C02C14E97E4EE34B404078EC67B16411C0
180	South Africa	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
188	Spain	0106000020E61000000F0000000103000000010000000400000000000000ACE931C0000000E08BC53B400000008097FB31C00000002033A33B40000000C0A92B32C0000000A0BABC3B4000000000ACE931C0000000E08BC53B4001030000000100000004000000000000C0BB1B2FC0000000607EC13B4000000040AE672FC0000000E0F6273C40000000402ABB2EC0000000A0A1023C40000000C0BB1B2FC0000000607EC13B400103000000010000000400000000000000CD2C31C00000006056043C4000000080235131C0000000E0162C3C4000000040191A31C0000000207D223C4000000000CD2C31C00000006056043C400103000000010000000500000000000040535730C0000000A0CA5E3C4000000040E0AB30C000000060F2FB3B4000000000ACE930C00000006065573C40000000C02D2830C0000000207D923C4000000040535730C0000000A0CA5E3C4001030000000100000004000000000000C089A72CC000000020E00B3C40000000404CBD2BC0000000205BC03C40000000C09AD82BC000000060C93F3C40000000C089A72CC000000020E00B3C400103000000010000000400000000000080FAD431C00000002032743C40000000C089E731C00000002075D93C400000008065B731C00000002001BF3C4000000080FAD431C00000002032743C4001030000000100000004000000000000C02D382BC0000000E027ED3C400000008056B42BC00000002009E83C40000000808FE22AC0000000A04E3B3D40000000C02D382BC0000000E027ED3C400103000000010000000400000000000000F86607C00000001022A2414000000000589307C00000001022AA4140000000005A5107C00000009005A3414000000000F86607C00000001022A2414001030000000100000004000000000000801C4715C0000000903FF0414000000000226215C000000090BBEB4140000000000D9515C0000000904AF54140000000801C4715C0000000903FF041400103000000010000000400000000000000F44908C0000000D0D5F4414000000000AD6808C0000000103AF5414000000000C03708C00000001054F6414000000000F44908C0000000D0D5F441400103000000010000000400000000000000963EF93F000000100958434000000000963EF63F000000905852434000000000FE20F63F000000103B5C434000000000963EF93F00000010095843400103000000010000000400000000000000B681F83F00000050D9794340000000002264F33F00000090FC72434000000000CA50F83F00000090258F434000000000B681F83F00000050D9794340010300000001000000060000000000000073FB0940000000500BDE43400000000079D60B400000009005DB4340000000004782084000000010BEA1434000000000D1E902400000009025C7434000000000F9E60740000000509FF443400000000073FB0940000000500BDE43400103000000010000000400000000000080E4171140000000D00EFB434000000080051B1140000000D037E743400000000025600E40000000503402444000000080E4171140000000D00EFB43400103000000020000002900000000000080166C1FC00000009047E1454000000000E52D1CC000000090C5BE454000000000787EFCBF0000001012AE454000000000B8FDE1BF0000009004644540000000002222F73F000000900C4D454000000000EA93FB3F000000503541454000000000D76B094000000050E937454000000000F9660940000000100AEF444000000000BCDCEE3F0000001032844440000000004008A93F000000109F04444000000000B0A2D5BF00000050C0B74340000000005086CA3F00000010B95D434000000000945FE0BF000000909929434000000000D4E5E6BF00000050B0CD4240000000003A4CFABF00000010B7AF424000000000880801C0000000109E5D424000000080E49711C0000000D0715C424000000000895615C0000000D0CE14424000000080566C15C000000050E714424000000080662618C0000000501317424000000080166C19C0000000D02F6E42400000000038BA1DC00000009068A0424000000000ACC91DC00000005087D9424000000000B5C11BC000000090CA16434000000080D1481DC0000000508739434000000000B5D11BC000000090608343400000000049211EC000000090AFD5434000000080A2111CC00000005066D643400000000007BA1BC0000000904F82444000000000B7BF18C00000005034CA4440000000006D601AC0000000D00FFA444000000080D16820C0000000D0F6EF4440000000C0066720C0000000108D134540000000C0717D21C000000090EBF944400000000017CC21C0000000D0D40D454000000080D12821C000000050032D45400000008003BD21C0000000902D204540000000405B7021C0000000101159454000000000311522C000000090B2434540000000803C6B22C0000000108E93454000000080166C1FC00000009047E14540040000000000000033B31BC0000000D0DD9542400000008068E41BC000000050EA9A42400000000011D11BC000000050139742400000000033B31BC0000000D0DD954240
189	Saint Lucia	0106000020E61000000100000001030000000100000004000000D0CD8C7E347A4EC0F0AF743E3C6B2B404C6AF6402B8A4EC088069B3A8FC22B402C836A8313774EC0A87C410B09382C40D0CD8C7E347A4EC0F0AF743E3C6B2B40
190	Sudan	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
191	Sweden	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
192	Syrian Arab Republic	0106000020E61000000100000001030000000100000011000000FCFF71C2842D4540CA8B4CC0AF8D4240246893C327A544405A7FBDC2822D4240AC9E3E027F8044404A6A6803B0354140A48C2AC3B86543403A950C0055B04040DCAF743E3C6B424026EACC3D242840402C6211C30ED34140AA6E2EFEB65740404456293DD3CF414012DBDD03749F40405C16BEBED64F42402AF04E3E3D1A4140AC984A3FE13A42405A73B9C150514140ACBF97C283FC4140AE984A3FE1524140D4FA5B02F0DD4140261DACFF73CA4140DC42908312F641404ECB48BDA7F64140BC380EBC5A584240A6AD11C1381E4240AC1C2103795442409E2C6002B76A4240FC1A4982709D43402A6893C32755424004093543AA62444082A52C431C8F4240FCFF71C2842D4540CA8B4CC0AF8D4240
193	Switzerland	0106000020E6100000010000000103000000020000001500000060137CD3F4C91E40620438BD8BC54740A085B18520272140FEEA1C03B2CB4740D0CF0D4DD92121402AF38FBE49E7474070B7EBA529222340960B957F2DC54740C051BAF42F11234012A8FE4124A3474070F1F09E03F3224096F63FC05A874740707B6649803223408AABCABE2B8847403076C3B645F12440BE22BF7E886F4740C02975C938EE2440D2FA5B02F0454740E06ABB09BE192440DA88997D1E454740C0069B3A8F422440E6031F83151D4740A09BC6F65A902240BABC5642773F4740D0D03FC1C5122240DEAF743E3CEB464020BC783F6EDF20403A14E97E4E3B474020417FA1476C1F4076A9F57EA3F54640A0EDB5A0F7261C403AF38FBE49F74640C0A8C5E0612A1B407E8461C092374740009F20B1DDDD17406234D6FECE1A4740408FC70C54F61B405A0ABABDA4BF4740402235ED625A1E4046959A3DD0CA474060137CD3F4C91E40620438BD8BC547400400000040A4198BA66B2140AECB290131D94740C05626FC52572140DE82177D05DB47406075C8CD705B21406A70067FBFD8474040A4198BA66B2140AECB290131D94740
194	Trinidad and Tobago	0106000020E61000000200000001030000000100000006000000CC27B9C326764EC0B04D637B2D98254080C0030308814EC020A5A2B1F6472440F8E175FD82F54EC0781B62BCE6152440204A09C1AABA4EC040DC2A88818E244028508BC1C3D44EC010DF52CE176B2540CC27B9C326764EC0B04D637B2D98254001030000000100000004000000A8B6627FD9514EC0F0A4A2B1F6672640589DD5027B6C4EC0A0C1E105115126400CDCF3FC69434EC000B4E73235B12640A8B6627FD9514EC0F0A4A2B1F6672640
195	Thailand	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
196	Tajikistan	0106000020E61000000100000001030000000100000029000000D2A623809BBA52406A368FC3609E4240BE0A293FA95352401E90847D3BBB42407E36AB3E57EB51406AE2E47E875642402AFF93BF7BDB51404E8BC1C3B4894240FED8243FE2E55140FE6393FC88F34240960B957F2DD051403A622D3E05F642403E8F8AFF3BD75140BE13ECBFCE1F43406AD993C0E6BD5140BE79AA436E3C4340E6543200548A51404A80D3BB78F74240C23D0801F9895140CA880B40A3C4424096E1783E036151404A55A18158CA4240FAEAAA402D5451404E8E0244C18E42408293A641D13851407E36AB3E57AB4240722D5A80B6035140BE5510035D774240CA793881E9F150404E70EA03C99742401666DAFE951851407A03CC7C071943400E7BA180ED0751404E499D80267E43404286C77E16D850404E4CDE00339B43405A91D10149DC50409A77D503E6BD4340D2C43BC093225140D261BEBC00C74340EA8711C2A340514026FF93BF7B0B44408EFCC1C073265140DA76137CD31644400E4E44BFB6535140D273D2FBC619444052137D3ECA5651402ABA2EFCE062444012786000E16E514056103CBEBD514440FAE769C0209B514092D2A57F49864440129F3BC1FEB251404216A243E05C44404E22C2BF08985140B20A9B012E3044404ED74CBED9BE5140C6D3F203571F444026179CC1DF9F51400E84640113F44340BE07E8BE9C625140FAB48AFED01044406AA6B4FE965351408224253D0CC54340BA162D40DBBF514042D47D0052B34340FEF02C4146DE51409A8026C286CF4340A67A32FFE80F52404AC5C6BC8E98434096DE37BEF669524076AF05BD37BA43402EF6D03E567452408AB1BE81C94D43402A145B41D3B65240B2AD11C1383C4340C2310400C7B9524082B4FF01D6D242406ADF15C1FFCB5240868192020BB44240D2A623809BBA52406A368FC3609E4240
197	Tokelau	0106000020E610000003000000010300000001000000040000006CF7AB00DF6665C0908B868C47C122C00E4B033F2A6765C0C0A02FBDFDC122C01ECC26C0306765C068DF4DB7ECB022C06CF7AB00DF6665C0908B868C47C122C001030000000100000004000000399ECF80FA7A65C058B5BFB33D6A22C00642B280897B65C00053CC41D06922C094145800537B65C058A9BBB20B5622C0399ECF80FA7A65C058B5BFB33D6A22C001030000000100000004000000501F813F7C8F65C0680C1D3BA82C21C091F98040E78F65C0404B3B35971B21C0807EDFBF798F65C0A082C30B222221C0501F813F7C8F65C0680C1D3BA82C21C0
198	Tonga	0106000020E61000000F00000001030000000100000004000000000000C025DD65C0000000003A6D35C0000000C030DF65C000000040A75D35C0000000802ADD65C0000000405D4E35C0000000C025DD65C0000000003A6D35C001030000000100000004000000000000C0AAE465C000000040952D35C0000000C080EB65C000000040631935C00000000083E165C000000080B22335C0000000C0AAE465C000000040952D35C001030000000100000004000000000000C058D865C000000080C14634C0000000C057D965C0000000C0163C34C00000004052D865C0000000C0BA3C34C0000000C058D865C000000080C14634C001030000000100000004000000000000003FCD65C0000000003AED33C00000008085CD65C000000000F6E833C00000000082CC65C000000000B5E133C0000000003FCD65C0000000003AED33C0010300000001000000040000000000000032CA65C0000000006BD233C0000000005CCB65C000000000DCCF33C0000000801BCA65C0000000C0A0C333C00000000032CA65C0000000006BD233C00103000000010000000400000000000040D0E165C0000000C003CD33C0000000C027E365C000000000EEBF33C0000000409DE265C000000000D6B433C000000040D0E165C0000000C003CD33C00103000000010000000400000000000080B8C865C000000080B6C033C0000000C0D4C965C000000040A7BD33C00000004032C865C00000004024B033C000000080B8C865C000000080B6C033C0010300000001000000040000000000004096E065C0000000C0FEB033C0000000C025E165C0000000003AAD33C0000000C02DE065C0000000400AA733C00000004096E065C0000000C0FEB033C001030000000100000004000000000000C0D2C765C000000000F7A733C0000000C005C965C0000000006BA233C0000000C057C965C0000000802D9833C0000000C0D2C765C000000000F7A733C00103000000010000000500000000000000B4D465C0000000408DD432C0000000009AD565C000000040F0CD32C000000000CBD465C00000008076C832C000000040F0D365C0000000C037CF32C000000000B4D465C0000000408DD432C00103000000010000000400000000000000F7C165C0000000C068B432C00000004021C365C00000008046B232C0000000405BC265C0000000405DAE32C000000000F7C165C0000000C068B432C001030000000100000004000000000000C0A1C065C0000000C09BB732C00000000063C165C0000000404BAE32C0000000409DC065C000000040C7B132C0000000C0A1C065C0000000C09BB732C00103000000010000000400000000000000DFC265C00000008096AC32C00000000019C465C0000000C00DB432C0000000C0B4C365C000000040E0AB32C000000000DFC265C00000008096AC32C0010300000001000000040000000000004023BD65C0000000C057A332C00000004042C265C0000000C0EBA132C0000000000EBE65C000000000A39132C00000004023BD65C0000000C057A332C001030000000100000004000000000000C0A1F465C00000004022422FC0000000C0E2F565C000000040F02D2FC000000080E2F365C0000000C0251F2FC0000000C0A1F465C00000004022422FC0
199	Togo	0106000020E6100000010000000103000000010000000E000000805181936D60F63F3009DFFB1BDC224080F67B629D2AFA3F70CBD765F8DF184080804754A82EF33F70F9D687F566184000CDCCCCCCCCE03F2079E75086CA1B4000D35D126745E73F58A7CAF78CA42040003402F1BA7ED83FA87878CF8185214000D911876CA0E13F18EFAB72A1D2224000A8703D0AD7CB3F0806820019EA2240006A4293C492D73F385A80B6D5842440007817B6662BC3BF286002B7EE46264000B3169F0260ED3FC8887D0228FE2540003E9CC074DAE83F8818213CDAC024400048E17A14AEF53F08EC6AF294FD2340805181936D60F63F3009DFFB1BDC2240
200	Sao Tome and Principe	0106000020E6100000020000000103000000010000000400000060F0A65B76181A400000C0CDE2C5923FC0E2A7716FDE194000590306499FD03F40A243E048C01A4000D9EE5701BED93F60F0A65B76181A400000C0CDE2C5923F0103000000010000000400000020A3755435B11D408021DFA5D4E5F83FC020B248134F1D404098766A2EB7F93F4095490D6DA01D4040FCB9A1293BFB3F20A3755435B11D408021DFA5D4E5F83F
201	Tunisia	0106000020E6100000060000000103000000010000000400000020F52D73BAFC2540FEFFFFFFFFDF4040A014AE47E1BA2540DEEE5701BED14040F0989EB0C47325402E2F3201BFF0404020F52D73BAFC2540FEFFFFFFFFDF404001030000000100000004000000C0A9F23D232126403A3E7782FD51414090B81E85EB1126403641B8020A4F414010A7B1BD16EC2540DA7954FCDF534140C0A9F23D232126403A3E7782FD5141400103000000010000000400000000B728B341462640AEDA6E826F564140E0AC33BE2F76264052465C001A6941404054FEB5BC9A2640E676137CD366414000B728B341462640AEDA6E826F56414001030000000100000004000000305FD042029E254026F38FBE498F424090978A8D799525408AC9C6832D904240E0A9F23D23A12540E200DE0209904240305FD042029E254026F38FBE498F424001030000000100000017000000E015FC36C4B023401ED5E940D6914240A08B868C478124405E37177FDB974240A0DF6B088EC32440FA230C03965C424010C74ACCB3222640D6C43BC093864240A04E95EF19E9244006D3A23EC90F424050C2137AFD412640EEAC33BE2F9E4140B079008BFC022440B6B6D4415E15414020356090F4A92440FE264D83A2D94040D0737E8AE3182640923FFCFCF7CE40408009DCBA9B572640D2FD9C82FC9A40402018247D5A0D2740BE196EC0E795404090069B3A8F222740826649809A384040606211C30E932440940F5EBBB4B13F407032384A5E6D244044E78BBD17BB3E405083A279001323407C82A8FB003C3E40307156444D1C22403AD505BCCC0C4040301E8A027DB220405E70784144444040C04069A851F81D402E266F8099F140409018213CDA802040021E8A027D524140605FD042025E20402EE78BBD17434240004356B77A3E214022C022BF7E784240E02FF7C951582340A6B0524145AB4240E015FC36C4B023401ED5E940D691424001030000000100000004000000E01B62BCE6D521402EF911BF62C14240402C9D0FCFCA21403214E97E4EC3424090B08D78B2E3214086397AFCDEC44240E01B62BCE6D521402EF911BF62C14240
224	Zimbabwe	0106000020E61000000100000001030000000100000019000000145D177E707E40407857923CD74331C064F833BC59894040ECD571FC505932C00CC11C3D7E5940401CCE5147C7F132C0B4B915C26A824040A023D5777EF133C0E4B2B5BE4840404080ED60C43E9934C05CE61F7D933E4040202C7FBE2D5835C0086EDE38294C3F40DC8E37F92D6A36C0D85147C7D5E43D402CCE5147C73136C0A808C6C1A55F3D40546C21C8413136C0009C5088800F3D409C4F72874DCC35C050431B800D043C4020D714C8EC9035C0E8A63FFB91B63B40D4A50D87A58134C01823128596493B402CAAB706B67E34C0D03730B951383B404C1F0F7D771734C088812040862A3A40048448861C8733C0700C01C0B14339404437894160CD31C01073F4F8BD093B403447C8409EF531C0D834EF3845D33B40FC66F0F78BF530C0E03DB2B96AC23C4060198D7C5E8D30C0D83A71395EED3C4070D68A36C7F12FC0A81D37FC6E6A3E4010840EBA84432FC0F8907EFB3A6C3E40C833BDC4580230C0A8F27684D3463F4034508BC1C30430C01C66DAFE957D40405C21567F84B530C0145D177E707E40407857923CD74331C0
225	Indonesia	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
226	Guadeloupe	0106000020E61000000400000001030000000100000004000000549A94826E9F4EC0281286014BBE2F40506AF6402BAA4EC0387A19C572DB2F40586AF6402BA24EC0047976F9D6033040549A94826E9F4EC0281286014BBE2F400103000000010000000400000024508BC1C3844EC014861DC6A44F3040ACC5A700188B4EC0142DCF83BB4B30407CA279008B7E4EC0D4EAE5779A58304024508BC1C3844EC014861DC6A44F304001030000000100000004000000D8D30E7F4DAC4EC024809BC58B553040D8BE47FDF5D84EC0380473F4F8E52F40D4D30E7F4DE44EC04CCDE50643553040D8D30E7F4DAC4EC024809BC58B55304001030000000100000004000000D01533C2DB674FC084FDD7B969E33140D8D0CDFE406F4FC0545FD04202EE3140242FC03E3A654FC064AA0B7899E93140D01533C2DB674FC084FDD7B969E33140
202	Turkey	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
203	Tuvalu	0106000020E61000000900000001030000000100000004000000C1374D9F1D676640106B4606B91B21C0032159C08466664028873254C5EC20C0AB893E1F656766405031CEDF840221C0C1374D9F1D676640106B4606B91B21C00103000000010000000400000047EF54C0BD4B6640E0D02170242020C027F911BF624B6640589A94826E1F20C00F751F80D44B66408047E17A140E20C047EF54C0BD4B6640E0D02170242020C001030000000100000004000000B92EC37FBA4C664068B29C84D20720C0D5C1FA3F874C6640F0FFFFFFFFFF1FC01799B9C0E54C66400096766A2EF71FC0B92EC37FBA4C664068B29C84D20720C001030000000100000004000000B3DAFCBF6A566640D083B9DDCBED1DC07100FDBEFF556640E0A7C5E061EA1DC0A38636001B566640A029577897DB1DC0B3DAFCBF6A566640D083B9DDCBED1DC001030000000100000004000000DD24068115256640C0A143E048C01CC0156C5CFFAE24664080A9F23D23C11CC027232E008D24664010E7FC14C7B11CC0DD24068115256640C0A143E048C01CC0010300000001000000040000000F7BA180ED096640B0B4C4CA682419C039BCE7C07209664080D349B6BA1C19C003D9243FE209664090BF9657AE0719C00F7BA180ED096640B0B4C4CA682419C001030000000100000004000000B3DD3D4077296640D07E69519F7418C05740DAFF00296640304B3B35975B18C0FDD8243FE229664070BC7328436518C0B3DD3D4077296640D07E69519F7418C0010300000001000000040000009F3E027F78046640B039B01C21C316C0C36AF3FF2A04664000F30016F9C516C087A8FB00240466402033333333B316C09F3E027F78046640B039B01C21C316C001030000000100000004000000796649809A026640C01FB75F3EA916C0ABA78FC01F026640C01FB75F3EA916C05B828C808A026640B01C588E90A116C0796649809A026640C01FB75F3EA916C0
204	Turkmenistan	0106000020E6100000020000000103000000010000000400000000000090EC884A40000000102A734340000000D00F8A4A4000000050048C4340000000D0CC8C4A40000000502460434000000090EC884A40000000102A7343400103000000010000003700000000000010E9634D40000000D03A54454000000050D9014E40000000D0D61B454000000090F4114E4000000010C8B0444000000090E4EF4E400000001012904440000000908A464F400000009092F74340000000888318504000000010007A43400000004835A950400000001064004340000000486AA2504000000090E5AE4240000000485E6D504000000010F1C442400000000813335040000000D0FF8F4240000000083B20504000000010E9234240000000D0498F4F400000001054EE414000000090798D4F40000000D0B4B9414000000090715C4F40000000909AA041400000009092274F4000000010229241400000005066A34E4000000050BACD4140000000901F944E40000000103353424000000090A12A4E4000000010FB5342400000009060AB4D400000005003C5424000000090A2B94C400000005036F84240000000D0299B4C40000000901624434000000090ACB84B4000000090050B4340000000902E574B4000000010C8B8424000000010ECF34A40000000D0E8AC4240000000D0EFFD4A40000000D039754340000000104CC54A4000000050FCAA434000000090CC944A40000000907896434000000010D0A14A40000000D0DFD343400000001002DE4A40000000900EC343400000001044B44A40000000D039D54340000000D0B4C94A4000000050A9FB4340000000D0A4774A4000000050CAFE4340000000909A804A400000005090E1434000000050685C4A40000000D019394440000000D094754A4000000010748A44400000009089DF4A4000000050C14E44400000009079354B40000000D00F5A4440000000D0521F4B40000000D0AC704440000000D0EF5D4B4000000090158D44400000009050094B40000000D0DEBC444000000090E5E64A4000000050DB0F4540000000102C794A40000000D08CFC4440000000106D684A40000000D010D9444000000050E3704A40000000500B8644400000005054384A4000000010D7DE444000000090EB814A4000000010C71145400000009026164B40000000D0292B4540000000107DBA4B4000000050B1A44440000000901F004C40000000D00AAA444000000050B9854C40000000D050A1444000000010547E4C40000000904FF24440000000D067034D40000000109840454000000090FD414D40000000D0F7264540000000500C154D40000000907253454000000010E9634D40000000D03A544540
205	United Republic of Tanzania	0106000020E610000004000000010300000001000000040000007C5704FF5BD74340F004508C2CF91FC02C2CF180B2CB434030C745B588C81FC0FC14C78157F34340701803EB388E1EC07C5704FF5BD74340F004508C2CF91FC001030000000100000005000000C4AAD0402CB94340E0E7F7FD9BD718C07CA2EBC20FC24340700DFAD2DBDF19C0DC73D2FBC699434030F6234564E818C0FCDB65BFEEA6434060BC732843E516C0C4AAD0402CB94340E0E7F7FD9BD718C001030000000100000004000000ACAD11C138DE4340703BDD79E2D915C03429B000A6D64340B0415F7AFBC313C0CCCDFE40B9ED4340B02407EC6AA213C0ACAD11C138DE4340703BDD79E2D915C001030000000100000020000000E83A71395EAD3F4080EDE2FDB8FDEFBF34327381CBF5404080A6CAF78C04F0BF2C6893C327CD42408038BA4A77F707C00CC45DBD8ACE424060C745B588080CC07C1E87C1FC99434030404B57B0AD12C00C9A417C60634340808B683BA62E18C0A40854FF20C6434000F3E32F2DFA1BC0FCE769C020A3434080B06F2711511EC004274D83A2B143408047E17A14CE21C0E473D2FBC6E94340982094F771FC23C0F4BB067DE93744404098F738D3F424C09454C37E4FA24340F8CA9F6F0B5626C05401F73C7FF84240B8963AC8EB9126C01CA8FE4124BB424050DD7877647427C0DCB2B5BE481842401053CC41D06927C03414E97E4EEB4140E0DC257156D426C054103CBEBD7B4140085DA5BBEB2427C004274D83A2294140006420CF2E7723C0140F45813E9140404886FF7403FD22C07C1893FE5E78404028B9A64066CF22C088812040860A3F400808910C392E21C0185E11FC6FC53E402082E3326E6220C058B5DD04DF8C3D4010C8409E5D2E19C0D84334BA836C3D40301B2B31CFCA11C0182A8E03AF063E40D069C020E91311C08831957EC2D53E40A0F61E2E390E0AC0D8E09A3BFAD73E40202BDCF291D407C07814AE47E16A3E40C09A8F6B43E506C0E8D03FC1C5923E408023D5777E3103C0583A58FFE7E43E4080ED7E15E09B00C0287A19C5727B3E40C0982B836A03F1BFE83A71395EAD3F4080EDE2FDB8FDEFBF
206	Uganda	0106000020E610000001000000010300000001000000120000008C8461C092FF4040D03465A71FE410403414E97E4E3B414000282F32015F0D400C0F45813E81414080412D060F53FE3FACA78FC01FF440400024A8C5E061BA3F34327381CBF5404080A6CAF78C04F0BFE83A71395EAD3F4080EDE2FDB8FDEFBF287A19C5727B3E40C0982B836A03F1BF68AA0B7899F93D4040A75CE15D6EF7BF8893A641D1983D40C0F5BA45602CF6BF981B62BCE6F53D400096C151F26AEA3F98035ABA824D3F40600491459AF800407834D6FECEBA3E40407A1EDC9D9503405837177FDBDB3E408058B08D78F20B40C850A4FB392D3F4020D449B6BA5C0E402C2F3201BF184040E046B41D53170C40DC0660032282404040EE7E15E01B0F40DC8BDAFD2AC2404000A8CAF78C040E408C8461C092FF4040D03465A71FE41040
207	United Kingdom	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
227	Netherlands Antilles	0106000020E61000000300000001030000000100000004000000000000807F0C51C0000000403571284000000040121051C000000040860A2840000000C0A11A51C0000000408E832840000000807F0C51C0000000403571284001030000000100000004000000000000C0CB3D51C0000000C0D4652840000000C0784A51C00000004097BB284000000000CE2F51C0000000409F142840000000C0CB3D51C0000000C0D465284001030000000100000004000000000000C0057B4FC000000020F975314000000000937F4FC000000020438531400000008024784FC0000000E0827D3140000000C0057B4FC000000020F9753140
208	Ukraine	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
209	United States	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
210	Burkina Faso	0106000020E6100000010000000103000000010000001E000000805A9A5B21AC06C0F8B9BE0F07012640404ED367077C05C05850C3B7B0F622400016DBA4A2110DC010CBBDC0ACE823408052B3075AD112C0889E077767652340404DF38E531416C04852280B5FDF2440E0E7F7FD9B1715C0F009F5F411B02740A051B81E85AB11C0E83E5585069A2840C0D571FC505911C0001286014B3E2A40408FE046CAB60FC0C07C7901F6012B40C0361AC05B800BC0F8B2D1393F552A4040C2F5285C0F0AC020895E46B1642B4040C745B5880807C028861DC6A44F2B40C088450C3BCC03C0C85417F032932C40C0F61E2E390E00C0D0E1934E24602C4000E10CFE7EB1FFBF406211C30EF32C40004450357A35E7BFF0B837BF612A2E4000C47E880D16CE3F803BFBCA83D42D4000D15D126745E33FF017080264682B4080A435069D90F43F30035C902DB32A4000B7B06EBCBBEF3F181286014BBE2A400009698D41A7EF3FA84D637B2D182A40002A931ADA40F93F80069B3A8F42294040713D0AD723014058DF6B088E63294000166A4DF32E0340807D586FD4CA274000416491261E0040982FF7C951D8264080B16A10E6F6F63F701EA33CF3EA264000B3169F0260ED3FC8887D0228FE2540007817B6662BC3BF286002B7EE4626400033A14962C9E3BFD8D03FC1C5D22540805A9A5B21AC06C0F8B9BE0F07012640
211	Uruguay	0106000020E6100000010000000103000000010000001300000004D0EFFB37E74CC0E83EC7478BBF3EC088F37002D3CD4CC07436AB3E572F3EC0CC1533C2DB674CC0F8FCBE7FF31A3EC054978C6324014CC0B06A2C616D143FC0A880423D7DCA4BC02CBF0CC688D83EC0F44465C39AF04AC0A8B0E07EC0F73FC028594E42E98B4AC0A6F886C2675D40C034FCE07CEAC24AC02AFCE07CEA9240C0A07A32FFE8AF4AC09814E63DCEDE40C004E5B67D8F124BC0805D143DF05541C0ACBF2500FF284CC0B0014A438D7441C02C836A83138F4CC0042A1C412A3B41C0004224438EEB4CC03035423F533F41C0F84124438E334DC0D81EF64201F740C088751C3F542E4DC002249A40119140C080AE7D01BD124DC07EE15CC30C8D40C028742502D5054DC0DAE8D500A57740C0A8FE08C380194DC0E88711C2A33940C004D0EFFB37E74CC0E83EC7478BBF3EC0
212	Uzbekistan	0106000020E6100000010000000103000000010000003200000026E17B7F8318504006000000007A43405461A5828A464F400AA6457D92F743402C38F581E4EF4E40CE8558FD11904440643D997FF4114E40FA2F1004C8B044402CD8463CD9014E405216BEBED61B4540B47A32FFE8634D40562EC6C03A5445408C24253D0C154D40A29BFD8172534540343E7782FD414D40CEDC43C2F7264540C4F886C267034D409EA4C002984045400C9700FC537E4C408254C37E4FF24440D4CDFE40B9854C405E73B9C150A144402CC9737D1F004C400AA376BF0AAA4440240B98C0ADFF4B4032EACC3D24804640DC7C957CEC484D4052465C001AC946401C6F2BBD36034F4052431B800DBE4540D2A623809B3B50402AFC523F6FDE45407E6649809A7450402250FD83487045400E7BA180ED87504062853FC39B7F45408296E7C1DD815040021808026400454002CD203EB0A1504002180802640045400AE5284014AE504056FB743C6696444026179CC1DFFB5040A6BC564277974440428908FF221D5140B6BF97C2834C4440D6A623809B4351400603B34291B044404E2844C021BE51400E2769FE98204540FECC203EB0D15140128123810619454062BEBC00FB8B5140EA66B8019FC3444066D0D03FC1DA5140E2EBA4BE2C8F4440D270033E3FEC51406A4F3BFC35C744406EC18BBE820C52402A35B401D88044400E846401134B524032569BFF57694440E65DF58079ED51400AEB387EA81244404ED74CBED9BE5140C6D3F203571F44404E22C2BF08985140B20A9B012E304440129F3BC1FEB251404216A243E05C4440FAE769C0209B514092D2A57F4986444012786000E16E514056103CBEBD51444052137D3ECA5651402ABA2EFCE06244400E4E44BFB6535140D273D2FBC61944408EFCC1C073265140DA76137CD3164440EA8711C2A340514026FF93BF7B0B4440D2C43BC093225140D261BEBC00C743405A91D10149DC50409A77D503E6BD43404286C77E16D850404E4CDE00339B43400E7BA180ED0751404E499D80267E43401666DAFE951851407A03CC7C07194340CA793881E9F150404E70EA03C997424086BA0F406AA250407E78CF81E5AE42409AED7C3F35A950400E1808026400434026E17B7F8318504006000000007A4340
213	Saint Vincent and the Grenadines	0106000020E6100000040000000103000000010000000400000050198D7C5EB54EC0A82975C9382E29407C69183E22BA4EC0000AF5F411302940003FE3C281B64EC070AA0B789939294050198D7C5EB54EC0A82975C9382E294001030000000100000004000000C8A02FBDFDA94EC0B0E1934E246029405C2250FD83AC4EC0286E15C440672940A0B0E07EC0A74EC0802FF7C951782940C8A02FBDFDA94EC0B0E1934E2460294001030000000100000004000000A88F87BEBB9B4EC00038A11001FF29405091D10149A04EC0201077F52AFA29405825917D90994EC0D0D24ECDE5162A40A88F87BEBB9B4EC00038A11001FF294001030000000100000004000000D027B9C326964EC098703D0AD7432A40F42059C004A44EC030B937BF616A2A40A88C463EAF964EC030895E46B1C42A40D027B9C326964EC098703D0AD7432A40
214	Venezuela	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
215	British Virgin Islands	0106000020E61000000300000001030000000100000004000000963270404B2A50C0C453E57B46623240D00FB1C1C22950C0B4F8F884EC703240AC8F87BEBB2350C05CB08D78B2733240963270404B2A50C0C453E57B4662324001030000000100000004000000BC61A2410A1B50C0E4B2B5BE4870324070D921FE611A50C0EC46753A9081324016A88C7F9F1450C0EC46753A90813240BC61A2410A1B50C0E4B2B5BE48703240010300000001000000040000003CBC75FEED1350C06440DAFF00BF32407E72DBBE471150C0A453E57B46B232400427DBC01D1A50C0BC59677C5FBC32403CBC75FEED1350C06440DAFF00BF3240
228	United Arab Emirates	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
229	Timor-Leste	0106000020E610000002000000010300000001000000040000000636C9CB861C5F40A051DC4B9E5E22C066BE6E3DF5155F4060E4D11540ED22C0A6C2F64DF4025F40381025C111AE22C00636C9CB861C5F40A051DC4B9E5E22C001030000000100000006000000060C040132D05F40E0BEB9BF7AF420C072B7D0F730485F4030E9B58535DF22C08A4523CB7F4A5F406097276DDD2122C0F26D733B823C5F40F80177D777E821C00E81238106765F400020990E9DF620C0060C040132D05F40E0BEB9BF7AF420C0
230	Pitcairn Islands	0106000020E610000003000000010300000001000000040000005C9D6340764260C024BDFDB9681439C0083C3080704360C030B1F9B8361039C09605137F144260C030B1F9B8361039C05C9D6340764260C024BDFDB9681439C001030000000100000004000000EE7EDC7EF9315FC0007EC68503AD38C015DB6B41EF325FC0F05F3C8386AA38C0285C1D0071315FC0A0321AF9BCAA38C0EE7EDC7EF9315FC0007EC68503AD38C001030000000100000004000000CCAFE600410960C0F07BB779E36838C0A171E140C80A60C074F41439445438C068EEE87FB90960C0E085E63A8D5438C0CCAFE600410960C0F07BB779E36838C0
216	Viet Nam	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
217	United States Virgin Islands	0106000020E610000003000000010300000001000000040000002E508BC1C33050C0D4AC33BE2FC63140F25701BEDB2350C08C8461C092BF3140D6D64FFF593950C0D450A4FB39AD31402E508BC1C33050C0D4AC33BE2FC63140010300000001000000040000006CE525FF932A50C0040341800C55324064E525FF933250C014895E46B1543240C2559E40D82E50C08CF1D3B8375F32406CE525FF932A50C0040341800C5532400103000000010000000400000012B7D100DE3550C07C21E4BCFF4F324068EEE87FB94150C074B5DD04DF5C3240B0B6627FD93950C0CC3A71395E5D324012B7D100DE3550C07C21E4BCFF4F3240
218	Namibia	0106000020E6100000010000000103000000010000001C000000187CB779E3483740DC8827BB99A931C0D0548847E279374034B1F9B836A031C0D03730B951F83840A8D1AB014A8F31C0700C01C0B14339404437894160CD31C028D505BCCC5C3840D0976C3CD8F231C028231285969D3740AC4D637B2D7C32C0506117450F4C3740D87B7F83F6FE31C02093C5FD47FE3440947DC9C6835132C0087FF8F9EFFD34400CD0EFFB37FF35C00809C38025FF33408872DBBE470136C0703123BC3D003440C41858C7F1C338C048E466B801FF3340ECF62004E46B3CC0189C5088801F334078751C3F54F63CC0809FAA42032D324030C901BB9AE83CC08809DCBA9B6731408008AA46AFB63CC0D8B2B5BE481031403035423F53073CC0E0722EC5557D30403844317903943CC01020990E9D962E40FCE4B67D8F523BC0C050A4FB39ED2C40ACBCE47FF21B38C080116DC7D4052D4000E275FD828D36C060BEA085049C27405C01857AFA1432C070F8FBC56C81274014F148BC3C4131C0706BD44334522A4024594E42E9F330C03088653387FC2B4014459DB9876C31C0C8E68EFE9773324008D6FF39CC6331C020990F0874EA3240800E2C47C8D031C0C06BED7DAADA34407CEA1F44320432C0187CB779E3483740DC8827BB99A931C0
219	Wallis and Futuna Islands	0106000020E610000002000000010300000001000000040000000B5707405C4166C0489CA38E8EA32CC0D7DF12807F4466C0D8A02FBDFDA12CC021E4BCFF0F4666C0F8519ACDE3782CC00B5707405C4166C0489CA38E8EA32CC0010300000001000000040000009E4A06802A0566C0C08FDB2F9FB42AC04AE00F3FFF0466C070EF6FD05E6D2AC0BC378600E00366C078D9CBB6D3862AC09E4A06802A0566C0C08FDB2F9FB42AC0
220	Samoa	0106000020E61000000200000001030000000100000004000000A38FF980C06D65C070E49D43190A2CC0F2845E7F128265C0986E2EFEB6BF2BC09D53C900507A65C0D8D78008719D2BC0A38FF980C06D65C070E49D43190A2CC0010300000001000000040000009829ADBF258965C0F86584B707F92AC001F73C7FDA8665C0E8EB6AF2949D2BC0D2BEB9BFFA9865C0B89FFD4811112BC09829ADBF258965C0F86584B707F92AC0
221	Swaziland	0106000020E61000000100000001030000000100000008000000186C239EECE63E400CF94A20254E3AC038895E46B1543F40D879E2395BC039C058D97745F0F73F40E4CC920035F539C0B4A44E40131140400CDFC2BAF1D63AC038D505BCCCFC3F4024D714C8EC503BC038F911BF62293F40AC415F7AFB333BC018274D83A2D13E40DC82A5BA80CF3AC0186C239EECE63E400CF94A20254E3AC0
222	Yemen	0106000020E61000000900000001030000000100000004000000DCC77C40A0AB4A40E8C98B4CC03728407C18213CDAA04A40C021E4BCFF3F2840DCB5F63E55A54A40305A80B6D5442840DCC77C40A0AB4A40E8C98B4CC037284001030000000100000004000000DCFD9C82FC8A4A4050D6A88768442840845D86FF74814A40F0B3E732355128406CF5F23B4D8C4A40285DC136E2592840DCFD9C82FC8A4A4050D6A8876844284001030000000100000004000000DC7FD6FCF81D4A4058BB5F05F8662840AC6BED7DAA324A4070A48977804F28409CE67283A10A4A4000AB24B20F722840DC7FD6FCF81D4A4058BB5F05F8662840010300000001000000040000002CEACC3D24B84540606C06B8204329400C4BE7C3B3B24540C8E4D4CE305529408C93A641D1B8454008274D83A25129402CEACC3D24B84540606C06B82043294001030000000100000005000000844B00FE29E34A40704B3B35973B2940140341800C3D4B4030EC6AF2941D29405C7C7C4276E04A4018CEFE40B99D28404C8BC1C3B4A94A40B038BA4A77172940844B00FE29E34A40704B3B35973B294001030000000100000004000000442F3201BF6045406051BD35B0652B40FC298E03AF564540F00241800C552B40AC68ACFD9D654540A017EFC7ED8F2B40442F3201BF6045406051BD35B0652B40010300000001000000040000003CD505BCCC64454060B81E85EBD12B408C4E417E36584540A0BB5F05F8062C40FC05820019624540E853E57B46222C403CD505BCCC64454060B81E85EBD12B4001030000000100000004000000ACA78FC01F4C454028B0743E3C8B2E407C93A641D1484540405C8FC2F5C82E4024F04E3E3D524540986BED7DAAEA2E40ACA78FC01F4C454028B0743E3C8B2E400103000000010000001400000014CD203EB01D4A40A82634492C592F404C888043A88C4840C074B0FECF092D4074F833BC59594840D0BEB9BF7A142C40DCB5F63E55D54640406002B7EEAE2A405CE597C118874640383B8BDEA98029407C81204086FA454058A48977802F29409415E0BBCDBB45402807B474055B2940C4E9B303AE9F45404823DA8EA96B2A40DC09A1832E574540B86BED7DAA6A2E401C27F73B14654540BC2C98F8A3603040CCB837BF619A4540D4A6B1BD16AC30404C853FC39BA745401C0341800C753140E4F4D901D73B464074D9E90775693140AC6BED7DAA2A4740AC6BED7DAAAA3040ACE67283A12A4740F8FDF0F3DF3B2F400C068200196248401C0C040132443240249C16BCE8FF494054742502D5FF32402C29B000A68E4A40AC9658198DA4304094AEEFC341264A40F4488446B045304014CD203EB01D4A40A82634492C592F40
223	Zambia	0106000020E6100000010000000103000000010000002A000000D03730B951F83840A8D1AB014A8F31C0D0548847E279374034B1F9B836A031C0B020CEC309003640A0FFACF9F12B30C0908461C092FF35400861DF4E22022AC060CDE50643053840D80AD28C45032AC0601E15FF77FC3740D8E26E10ADBD25C0E0D03FC1C5723840F010548D5EED26C0200341800C55394020581CCEFC6226C0F8A6B1BD165C394060C745B5884827C090ABAE4335013A409047E17A14CE27C098FA96395DDE3A4060FCA5457DF227C0C8C282FB01333B402878B471C42227C0485C8FC2F5A83B40D89AADBCE49728C0E8A9F23D23713C4088E49D43190A29C048431B800D043D40381268B0A9CB2AC038DB87BCE5963D40700569C6A2712AC0386893C327CD3D4078C745B588E82AC018A5BDC117CE3D40789AE7887C4F28C098FA96395D7E3D405068757286EA28C008857AFA08083D40E8010F0C20C428C0909FAA42035D3C40E0FB8C0B071A27C0486C06B820B33C40A0BA46CB814E25C038F38FBE495F3C40985EB7088C8522C0B8F27684D3E63C4058E15CC30CF520C0185E11FC6FC53E402082E3326E6220C088812040860A3F400808910C392E21C07C1893FE5E78404028B9A64066CF22C0AC59D93EE4D94040980E80B8AB1F25C0DC8558FD11A0404058E28E37F9C525C0DCFD9C82FCA240403824EEB1F44928C07C96E7C1DDC54040005B5D4E09B828C0DCFA5B02F0854040D8D362F0303529C034DB87BCE5564040183E05C078362BC0849CF7FF719C40402815FE0C6F062CC0287E384888363E4058EBC37AA3F62DC0A81D37FC6E6A3E4010840EBA84432FC0D83A71395EED3C4070D68A36C7F12FC0E03DB2B96AC23C4060198D7C5E8D30C0D834EF3845D33B40FC66F0F78BF530C01073F4F8BD093B403447C8409EF531C0700C01C0B14339404437894160CD31C0D03730B951F83840A8D1AB014A8F31C0
232	Marshall Islands	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
233	Saint Pierre and Miquelon	0106000020E610000002000000010300000001000000040000002814E97E4E134CC006E2E7BF076147404076FA415D1E4CC0EA73D2FBC66147402C11A8FE41164CC0220B98C0AD6747402814E97E4E134CC006E2E7BF0761474001030000000100000004000000044BE7C3B3224CC0A28FF980407F47400009C380252F4CC0FEBDDBBC71644740D81BB5C2F4314CC0D68E1B7E378F4740044BE7C3B3224CC0A28FF980407F4740
234	Saint Helena	0106000020E61000000400000001030000000100000004000000407AFB73D1C823C032802903073244C0A08B683BA60E24C000E8F7FD9B2744C040FFE6C589E723C0D6D0CDFE402744C0407AFB73D1C823C032802903073244C001030000000100000004000000207138F3AB6928C0D4D9907F668E42C0E052CC41D0A928C0D20FB1C1C28D42C0C0389CF9D58428C0FAF0BA7EC18642C0207138F3AB6928C0D4D9907F668E42C00103000000010000000400000040A23EC91DA616C0E08827BB99F92FC0C0953FDF162C17C06086FF7403FD2FC060B06F2711D116C0E0D8B27C5DCE2FC040A23EC91DA616C0E08827BB99F92FC001030000000100000004000000A0AE42CA4FBA2CC0108E90813CEB1FC0C0BD874B8EC32CC090698995D1881FC010CB9F6F0B962CC01083BEF4F6C71FC0A0AE42CA4FBA2CC0108E90813CEB1FC0
235	San Marino	0106000020E61000000100000001030000000100000004000000207CB779E3D428404E89963C9EFA4540300D36751E052940069700FC53FE4540D0DE52CE17EB2840024BE7C3B3F24540207CB779E3D428404E89963C9EFA4540
236	Turks and Caicos Islands	0106000020E6100000060000000103000000010000000400000042BFB67EFAC851C0D4C43BC0936E3540AC8905BEA2C951C0A4E0F082887835406EEBA7FFACC851C074B950F9D782354042BFB67EFAC851C0D4C43BC0936E3540010300000001000000040000007E7EDFBF791D52C07CABAE4335A13540282FC03E3A1D52C04C6C06B820B33540ACB0E07EC01B52C06428D2FD9CB635407E7EDFBF791D52C07CABAE4335A1354001030000000100000004000000C27FBA8102DE51C0ACE9B303AEA735408069183E22E251C06CBEA08504BC35402847C8409EDD51C09CE0F08288B83540C27FBA8102DE51C0ACE9B303AEA735400103000000010000000400000098266C3F19EA51C0E4D03FC1C5D235404C6AF6402BEA51C0F43A71395EBD354042FB58C16FF651C0ACE0F08288D8354098266C3F19EA51C0E4D03FC1C5D2354001030000000100000004000000A492C83EC81052C0E4B2B5BE48C03540C05B2041F11452C02CE78BBD17DB3540EC5701BEDB0F52C0642B137EA9CB3540A492C83EC81052C0E4B2B5BE48C03540010300000001000000040000008C44F64196F851C01C7CB779E3D835408669183E220252C01C7497C459F1354072D921FE61FA51C0DC3C80457EF135408C44F64196F851C01C7CB779E3D83540
237	Western Sahara	0106000020E61000000100000001030000000100000017000000B075E107E77B2FC0A4C2BCC799563540B8415F7AFBF330C06428D2FD9C5635407099B67F650D31C0A409DCBA9BC33440D812F241CFEA30C0BC5CA8FC6BF13540302C7FBE2DB830C0DCD03FC1C542364058AC1A84B97D30C02C809BC58B55364080F3E2C4571330C02C6211C30E533740A0C745B588882FC02C6552431BC837406044696FF08D2FC05CECA17DACE83740800569C6A20130C08414AE47E1AA3740404D2CF015AD2FC01C8A90BA9DE537400011548D5ECD2DC03CEACC3D24B0384000FA7DFFE6F52CC07C15E0BBCD2B3A4080E28E37F9252BC0F48F4C874EBB3A40A026FA7C94592AC044CE6DC2BDAA3B4040941282555521C0B46BED7DAAAA3B406099B67F655521C02CD461855B4A3B40E075A6D0795521C0C401BC0512003A403091D101490028C01C00000000003A40E0D02170240028C044F6D03E5674374010FA7DFFE6352AC08C87A2409FE43640001E6CB1DBFF29C0F43FC1C58A563540B075E107E77B2FC0A4C2BCC799563540
238	Serbia	0106000020E6100000010000000103000000010000001A000000A02E19C7481234405E7347FFCB47454080F755B950593440825D86FF74714540C807043A933A3340B2EC10FFB0C14540D8D03FC1C58233405A40DAFF00D74540D887F546AD3C33401E7B2FBE6801464000F4DF83D79E334022AE9CBD33064640E04BC5C6BC1A3340520438BD8B2D4640E828EB37135F3340A674B0FECF714640B0073E062B0A334082AEEFC3416E4640E04334BA836C33405E3A58FFE79C4640087C7F83F6FA324092BD50C076B04640A82D043928D132406E361D01DCF44640A0780778D24234407E6CCB80B30E4740B0DDAF027C833540FA14C781579346404862BB7B80663540767B1002F263464000A0C37C79253640DAB5F63E553D4640B06BED7DAA7A364082992842EA5A464078F01307D0C33640462234828D474640B06186C6137536404A4C50C3B73C464098592F8672AE364076309B00C31C4640285FD042025E364032D8463CD9E945400894BF7B47013740D6CABDC0AC98454080ABAE4335713640A6AAD0402C69454088035ABA825D36407E5D86FF74294540185932C7F296344066FAEC80EBF04440A02E19C7481234405E7347FFCB474540
239	Holy See (Vatican City)	0106000020E6100000010000000103000000010000000400000080DD3DE1E2E328405E41DE5A99F344406041451B3FE7284066C511FC38F44440C043A75CCFE9284056EC8FED61F3444080DD3DE1E2E328405E41DE5A99F34440
240	Svalbard	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
241	Saint Martin	0106000020E61000000100000001030000000100000004000000F0F63C7FDA804FC07C87A2409F143240481F0F7D77814FC034CEFBFF381132404CDA8D3EE6914FC05483A279000F3240F0F63C7FDA804FC07C87A2409F143240
242	Saint Barthelemy	0106000020E6100000010000000103000000010000000400000048A69883A0834FC0C45A0A48FB0332404CDA8D3EE6914FC05483A279000F3240481F0F7D77814FC034CEFBFF3811324048A69883A0834FC0C45A0A48FB033240
243	Guernsey	0106000020E6100000010000000103000000010000000400000080EA1A2D07BA04C006E5284014B6484080D349B6BA5C05C08E8461C092B7484080DBF3FC690304C032E109BDFEC0484080EA1A2D07BA04C006E5284014B64840
244	Jersey	0106000020E610000001000000010300000001000000040000008084EB51B81E00C052793BC2699B484000B5C4CA68A401C0FE08C38025974840C0CF26874FFA01C0FE17080264A048408084EB51B81E00C052793BC2699B4840
246	Taiwan	0106000020E610000007000000010300000001000000040000002E29779FE3645E40FC928D075B003640A668E55E605F5E40DC2B2CB81F143640962F682101635E40D45A0A48FB1336402E29779FE3645E40FC928D075B003640010300000001000000040000002E35B401D8EA5D4034D505BCCC8C374026ED7F80B5E15D40AC48DBF8138937400A1286014BE65D40049A417C609B37402E35B401D8EA5D4034D505BCCC8C3740010300000001000000040000007E54C37E4F8E5D40F440F33977673840E651F17F478D5D4094C3B64599693840A69BFD81728F5D4084ACE0B7217238407E54C37E4F8E5D40F440F33977673840010300000001000000040000002A145B41D39A5D405CD7DAFB546538400E691B7FA2915D405CCE177B2F66384066CD8FBFB4995D4024809BC58B8538402A145B41D39A5D405CD7DAFB5465384001030000000100000008000000B6404981056F5E40C4E7A4F78D23394012A8FE4124805E40C4EF3504C701394052103CBEBD755E40F45E7D3CF4793840DAA6EA1ED92D5E402C0516C094ED3540B268E55E60035E40BC622AFD840B3740B6F8DB9E20075E40348FE046CA9E37405E55682096405E40CC53E57B46023940B6404981056F5E40C4E7A4F78D233940010300000001000000040000002EFF93BF7BFB5D40B41F46088F223A40669D2ADF33FA5D4004B58AFED0283A405A4C1762F5FC5D40C47D737FF5283A402EFF93BF7BFB5D40B41F46088F223A400103000000010000000400000072D993C0E6FD5D40A421E4BCFF2F3A40D2DC0A6135FD5D4094AF21382E373A40FE17080264005E40B48636001B383A4072D993C0E6FD5D40A421E4BCFF2F3A40
\.


--
-- Data for Name: capitals; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY capitals (id, name, country_id, geom) FROM stdin;
1	Sukhumi	68	0101000020E6100000309E4143FF8244402E90A0F831804540
2	Kabul	31	0101000020E6100000C4E9245B5D4F5140FCDF1115AA494140
3	Mariehamn	142	0101000020E61000000F4757E9EEEE3340CDCCCCCCCC0C4E40
4	Tirana	4	0101000020E6100000F54C2F3196D13340C2F7FE06EDA94440
5	Algiers	2	0101000020E6100000CDE506431D560840B24AE9995E604240
7	Andorra la Vella	188	0101000020E6100000D3872EA86F59F83F5534D6FECE404540
8	Luanda	6	0101000020E61000003481221631942A409D103AE812AE21C0
9	The Valley	128	0101000020E61000008A39083A5A874FC072C119FCFD363240
11	St. Johns	1	0101000020E610000092955F0663EC4EC0F12E17F19D203140
12	Buenos Aires	8	0101000020E61000004B3FE1ECD6304DC02A8F6E84454D41C0
13	Yerevan	5	0101000020E6100000F12A6B9BE23F464056F31C91EF164440
14	Oranjestad	127	0101000020E6100000D5AE09698D8051C01AFCFD62B6042940
15	Canberra	9	0101000020E61000009770E82D1EA462406ABC749318A441C0
16	Vienna	57	0101000020E6100000999F1B9AB25F304052F01472A51A4840
17	Baku	3	0101000020E6100000C64FE3DEFCEE48406EBF7CB262344440
20	Dhaka	14	0101000020E6100000BAC0E5B1669A5640FBE6FEEA71CF3740
22	Minsk	102	0101000020E61000004AEB6F09C08F3B4040F67AF7C7F34A40
23	Brussels	129	0101000020E610000063B48EAA26681140863DEDF0D76C4940
24	Belmopan	15	0101000020E6100000A3409FC8933056C0AEEFC34142403140
25	Porto-Novo	19	0101000020E61000008C31B08EE30705409A27D714C8FC1940
26	Hamilton	12	0101000020E61000005EBA490C023250C0342BDB87BC254040
27	Thimphu	32	0101000020E61000009AB2D30FEA68564078CF81E508793B40
28	La Paz	17	0101000020E6100000FA264D83A20751C0003620425C7D30C0
29	Sarajevo	16	0101000020E610000033C34659BF693240EDF318E599ED4540
30	Gaborone	182	0101000020E610000088669E5C53EC3940E8154F3DD2A038C0
32	Brasília	21	0101000020E610000052D2C3D0EAF047C0CF11F92EA5962FC0
33	Camp Justice	118	0101000020E6100000B003E78C28BD4B409D8026C286573540
34	Road Town	215	0101000020E610000007EC6AF2942750C054AC1A84B96D3240
36	Sofia	22	0101000020E610000001A1F5F0655237402B14E97E4E594540
37	Ouagadougou	210	0101000020E610000038A110018750F8BF2BA391CF2BBE2840
38	Bujumbura	29	0101000020E6100000C58CF0F6205C3D407CF31B261AE40AC0
39	Phnom Penh	25	0101000020E610000082E49D4319395A4063F20698F9162740
40	Yaoundé	35	0101000020E6100000454772F90F0127401E6E8786C5C80E40
41	Ottawa	24	0101000020E6100000028063CF9EEC52C03524EEB1F4B54640
44	Bangui	40	0101000020E610000049F4328AE58E32407653CA6B25941140
45	NDjamena	36	0101000020E6100000FB0626378A1C2E402AFEEF880A452840
46	Santiago	33	0101000020E6100000E0D6DD3CD5AA51C02FC03E3A75B940C0
47	Beijing	30	0101000020E610000073637AC2121A5D407BD7A02FBDF34340
48	Flying Fish Cove	150	0101000020E6100000B5A50EF27A6B5A4026C5C72764D724C0
50	Bogotá	38	0101000020E61000006893C3279D8452C052431B800DD81240
51	Moroni	37	0101000020E6100000B6679604A89F4540FC5580EF366F27C0
52	Kinshasa	28	0101000020E6100000B54E5C8E57882E40B45A608F89C411C0
53	Brazzaville	27	0101000020E6100000BF60376C5B7C2E40594C6C3EAE0D11C0
54	Avarua	43	0101000020E6100000DEAE97A608F963C0234910AE803635C0
55	San José	39	0101000020E61000007FFB3A70CE0555C0E4DC26DC2BDB2340
56	Yamoussoukro	87	0101000020E61000005D4E0988492815C06DAB59677C4F1B40
57	Zagreb 	80	0101000020E61000005DA45016BEF62F40AC70CB4752E84640
58	Havana	41	0101000020E6100000187C9A93179654C0D9B11188D70D3740
60	Nicosia	44	0101000020E6100000D905836BEEB04040F19F6EA0C0974140
61	Prague	58	0101000020E6100000AA60545227E02C4079CDAB3AAB094940
64	Roseau	47	0101000020E61000007B4963B48EB04EC080F0A1444B9E2E40
65	Santo Domingo	48	0101000020E6100000236937FA987B51C08CF50D4C6E7C3240
66	Quito	49	0101000020E6100000DE74CB0EF19D53C0124F7633A31FC7BF
67	Cairo	50	0101000020E61000005646239F573C3F40CF49EF1B5F0B3E40
68	San Salvador	55	0101000020E6100000055262D7F64D56C0342E1C08C9622B40
70	Asmara	54	0101000020E6100000B98C9B1A68764340DD42572250A52E40
71	Tallinn	53	0101000020E61000004D158C4AEAC0384050508A56EEB74D40
72	Addis Ababa	56	0101000020E61000009697FC4FFE6043400FB8AE9811F62140
73	Stanley	62	0101000020E61000004C1B0E4B03ED4CC03D7FDAA84ED949C0
76	Helsinki	60	0101000020E6100000E9B7AF03E7F0384053CE177B2F164E40
77	Paris	65	0101000020E6100000257497C459D10240DBA50D87A56D4840
78	Cayenne	59	0101000020E6100000A3EA573A1F284AC08DB454DE8EB01340
83	Tbilisi	68	0101000020E610000082531F48DE6946403D1059A489DB4440
84	Berlin	72	0101000020E6100000CEC4742156CF2A407558E1968F424A40
85	Accra	69	0101000020E61000008BC1C3B46FEEC7BF2C280CCA346A1640
87	Athens	74	0101000020E6100000B4024356B7BA37403D7D04FEF0FD4240
90	Basse-Terre	226	0101000020E61000007044F7AC6BDA4EC03F541A31B3033040
91	Hagåtña	73	0101000020E61000008A0629780A18624023F609A018F12A40
92	Guatemala City	75	0101000020E6100000973B33C170A056C0CC7A319413452D40
95	Bissau	168	0101000020E61000007E54C37E4F3C2FC0B3B5BE4868C32740
97	Port-au-Prince	78	0101000020E6100000842D76FBAC1352C0EAE74D452A983240
98	Tegucigalpa	79	0101000020E61000009818CBF44BCC55C005A3923A01252C40
100	Budapest	81	0101000020E6100000912749D74C0A33409A249694BBBF4740
101	Reykjavík	82	0101000020E61000009679ABAE43D135C0765089EB18085040
102	New Delhi	83	0101000020E610000058CB9D99604D53402BBD361B2B9D3C40
103	Jakarta	225	0101000020E6100000F1A1444B1EB65A409B75C6F7C5D518C0
104	Tehran	84	0101000020E6100000457F68E6C9B14940FB3BDBA337D84140
105	Baghdad	88	0101000020E6100000BFF2203D452E46400DFFE9060AA84040
106	Dublin	51	0101000020E61000007B4963B48E0A19C0187D0569C6AC4A40
108	Tel Aviv	85	0101000020E610000098874CF910644140A52C431CEB0A4040
109	Rome	86	0101000020E610000053B131AF23FE284010AD156D8EF34440
110	Kingston	90	0101000020E6100000FD4B5299623353C0E0BC38F1D50A3240
111	Tokyo	89	0101000020E6100000E09D7C7A6C776140C1012D5DC1DA4140
113	Amman	91	0101000020E6100000D07EA4880CF94140B612BA4BE2F43F40
114	Astana	98	0101000020E61000008D5E0D501ADE5140BEA085048C944940
115	Nairobi	92	0101000020E6100000FC89CA86356942406760E4654DACF4BF
117	Pristina	238	0101000020E6100000D06394675E2A3540C007AF5DDA544540
119	Bishkek	93	0101000020E61000003A2009FB76A4524089B2B794F36F4540
120	Vientiane	99	0101000020E6100000E0BDA3C684A85940CF8250DEC7F93140
121	Riga	101	0101000020E61000003FFF3D78ED1A3840EDD632198E794C40
123	Maseru	181	0101000020E6100000DD5ED218AD833B402C499EEBFB5C3DC0
126	Vaduz	106	0101000020E610000031242713B70A2340A0E062450D924740
127	Vilnius	103	0101000020E6100000304B3B359747394006A051BAF4574B40
128	Luxembourg	136	0101000020E610000082CAF8F719871840FE45D09849CE4840
130	Skopje	112	0101000020E61000009ED15625916D3540F165A208A9FF4440
131	Antananarivo	108	0101000020E6100000C93CF20703C1474062F8889812E132C0
132	Lilongwe	123	0101000020E61000002A1BD65416E340406C79E57ADBEC2BC0
133	Kuala Lumpur	121	0101000020E61000000586AC6EF56B5940FB5DD89AAD1C0940
135	Bamako	113	0101000020E61000004A09C1AA7A0120C0041DAD6A49472940
139	Nouakchott	116	0101000020E610000062A2410A9EEA2FC05F46B1DCD2123240
140	Port Louis	115	0101000020E6100000FDDD3B6A4CC04C404ED53DB2B92A34C0
142	Mexico City	120	0101000020E610000032E4D87A86C858C0EBFCDB65BF6E3340
143	Palikir	63	0101000020E6100000BC58182227C56340F6083543AAA81B40
144	Chisinau	172	0101000020E610000030F5F3A622DD3C4092921E8656814740
146	Ulaanbaatar	110	0101000020E610000016A3AEB5F7B95A40821ABE8575F14740
147	Podgorica	140	0101000020E61000007FC2D9AD65423340ACC5A70018374540
148	Plymouth	111	0101000020E61000009240834D9D1B4FC02FDFFAB0DEB43040
149	Rabat	114	0101000020E6100000D3DC0A6135661BC0718FA50F5DFC4040
150	Maputo	122	0101000020E61000001D554D10754D40401A14CD0358E439C0
151	Naypyidaw	18	0101000020E61000002C9ACE4E0605584030D7A20568C33340
152	Stepanakert	3	0101000020E6100000CF31207BBD614740D673D2FBC6E94340
153	Windhoek	218	0101000020E6100000698CD651D5103140A1F2AFE5958F36C0
155	Kathmandu	156	0101000020E61000007C0BEBC6BB54554032384A5E9DB73B40
156	Amsterdam	154	0101000020E6100000F2B391EBA69413405C3AE63C632F4A40
158	Nouméa	124	0101000020E610000005C24EB16ACE64408A90BA9D7D4136C0
159	Wellington	160	0101000020E61000004B3FE1ECD6D865405BCEA5B8AAA444C0
160	Managua	159	0101000020E6100000988A8D791D8F55C0B189CC5CE03A2840
161	Niamey	126	0101000020E61000008D45D3D9C9000140628731E9EF052B40
162	Abuja	153	0101000020E6100000C4245CC823981D405DA9674128272240
163	Alofi	125	0101000020E61000004CDE00335F3D65C096253ACB2C0E33C0
164	Kingston	143	0101000020E61000004AB4E4F1B4FE6440CDB051D66F0E3DC0
165	Pyongyang	94	0101000020E6100000919A7631CD705F40E030D12005854340
166	Nicosia	44	0101000020E6100000D905836BEEB04040F19F6EA0C0974140
167	Saipan	131	0101000020E6100000022CF2EB07386240676490BB085B2E40
168	Oslo	155	0101000020E6100000B728B3412681254003EACDA8F9F44D40
169	Muscat	118	0101000020E6100000DCD8EC48F5334D40AE0D15E3FC953740
170	Islamabad	163	0101000020E610000035F0A31AF6455240240C03965CDD4040
172	Ramallah	91	0101000020E6100000A736DD578AC44140057F092648E83F40
173	Panama City	165	0101000020E6100000162F1686C8D953C07F15E0BBCD332240
174	Port Moresby	167	0101000020E610000089B14CBFC4656240FAEDEBC039E322C0
175	Asuncion	161	0101000020E6100000437573F1B7C94CC0A4A5F276844339C0
176	Lima	162	0101000020E6100000DBDFD91EBD4253C0F8C43A55BE1728C0
177	Manila	173	0101000020E61000006C04E275FD3E5E407E1EA33CF3322D40
178	Adamstown	230	0101000020E61000009C4D4700374360C0450DA661F81039C0
179	Warsaw	164	0101000020E610000013109370210335408A56EE05661D4A40
182	Doha	169	0101000020E6100000156F641EF9C34940C7BDF90D13493940
184	Bucharest	171	0101000020E6100000E5982CEE3F1A3A408A01124DA0364640
185	Moscow	175	0101000020E610000010E9B7AF03CF4240B6BB07E8BEE04B40
186	Kigali	176	0101000020E6100000541D7233DC1C3E40FA7E6ABC7453FFBF
187	St. Pierre	233	0101000020E6100000793D98141F174CC0C05DF6EB4E634740
189	Apia	220	0101000020E6100000F415A4190B7865C010AD156D8EB32BC0
190	San Marino	235	0101000020E61000008E3EE60302E528404AB72572C1F74540
192	Riyadh	177	0101000020E610000004CB113290734740388600E0D8BF3840
193	Dakar	183	0101000020E610000039639813B45D31C087527B116D872D40
194	Belgrade	238	0101000020E610000075745C8DEC723440420A9E42AE644640
195	Victoria	179	0101000020E6100000DD989EB0C4B94B407730629F007A12C0
196	Freetown	185	0101000020E610000005871744A4762AC0B0FF3A376DEE2040
198	Bratislava	57	0101000020E61000000A3197546D1B3140C05FCC96AC124840
199	Ljubljana	184	0101000020E6100000AED689CBF1022D407B4D0F0A4A074740
200	Honiara	20	0101000020E6100000E9482EFF21FF6340AFB5F7A92AE422C0
201	Mogadishu	187	0101000020E61000003C6A4C88B9A846404F90D8EE1E600040
202	Pretoria	180	0101000020E6100000D5EB1681B13A3C4095B9F94674BF39C0
203	King Edward Point	245	0101000020E6100000FEF15EB5323F42C0C74B378941244BC0
204	Seoul	96	0101000020E61000001EE0490B97BE5F400A85083884C84240
205	Tskhinvali	68	0101000020E6100000A88C7F9F71FB4540A3AF20CD581C4540
206	Juba	190	0101000020E61000000AD7A3703D923F40DE91B1DAFC6F1340
207	Madrid	188	0101000020E6100000C503CAA65CA10DC02C6519E258354440
210	Basseterre	178	0101000020E6100000E84CDA54DD5B4FC0C9923996774D3140
211	Castries	189	0101000020E61000002B685A62657E4EC060CAC0012D052C40
212	Marigot	241	0101000020E61000001684F23E8E8A4FC0CFDBD8EC48113240
213	Khartoum	190	0101000020E610000014083BC5AA474040223999B855002F40
215	Longyearbyen 	240	0101000020E6100000AE47E17A140E36408716D9CEF7835340
216	Mbabane	221	0101000020E61000006747AAEFFC223F40ECA012D7314E3AC0
218	Bern	193	0101000020E6100000F4C5DE8B2FCA1D40AABA473657794740
219	Damascus	192	0101000020E6100000D236FE44652342405ABA826DC4C14040
220	Taipei	246	0101000020E610000076A4FACE2F645E4026C808A870083940
221	Dushanbe	196	0101000020E610000064ADA1D45E325140B79BE09BA6474340
222	Dodoma	205	0101000020E6100000EB387EA834E04140FF5A5EB9DEA618C0
223	Bangkok	195	0101000020E6100000C251F2EA1C205940E6E61BD13D832B40
225	Lomé	199	0101000020E61000002D98F8A3A8B3F33FE8A1B60DA3B01840
226	Nukunonu	197	0101000020E61000004260E5D0227B65C02DB29DEFA76622C0
227	Nukuʻalofa	198	0101000020E61000003ACD02ED8EE665C090F5D4EAAB2335C0
228	Tiraspol	172	0101000020E6100000DB166536C8983D4098FA7953916C4740
229	Port of Spain	194	0101000020E61000008C81751C3FC04EC0433C122F4F4F2540
231	Tunis	201	0101000020E6100000DE5A26C3F15C24409AB1683A3B674240
232	Ankara	202	0101000020E6100000B27F9E060C6E4040C2A1B77878F74340
233	Ashgabat	204	0101000020E6100000C3B7B06EBC294D4026529ACDE3FA4240
234	Cockburn Town	236	0101000020E610000097C5C4E6E3C851C0EA40D653AB773540
236	Charlotte Amalie	217	0101000020E6100000B056ED9A903B50C09D8026C286573240
237	Kampala	206	0101000020E61000000AA2EE03904A40404C1B0E4B033FD63F
238	Kiev	208	0101000020E6100000F5B9DA8AFD853E40FDF675E09C394940
239	Abu Dhabi	228	0101000020E610000062A06B5F40594B4042D0D1AA964C3840
240	London	207	0101000020E6100000FFB3E6C75F5AC0BFE44BA8E0F0C04940
241	Washington	209	0101000020E6100000EFCA2E185C4253C0AF9811DE1E744340
243	Tashkent	212	0101000020E6100000C4E9245B5D4F514033A48AE255A64440
245	Vatican City	239	0101000020E6100000A5DDE8633EE82840A911FA997AF34440
246	Caracas	214	0101000020E61000000A9E42AED4B950C0C24EB16A10F62440
247	Hanoi	216	0101000020E610000068E89FE062755A409301A08A1B073540
249	El Aaiún	237	0101000020E61000003333333333532AC02C9D0FCF12203B40
250	Sanaa	222	0101000020E61000004E27D9EA72184640695721E527BD2E40
251	Lusaka	223	0101000020E6100000C4978922A4523C400BB3D0CE69C62EC0
252	Harare	224	0101000020E6100000C616821C94083F4069C537143ED331C0
\.

--
-- PostgreSQL database dump complete
--

