# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of key used to encrypt the data of the disk."""

    #: Volume is encrypted at rest with Platform managed key. It is the default encryption type.
    ENCRYPTION_AT_REST_WITH_PLATFORM_KEY = "EncryptionAtRestWithPlatformKey"


class OperationalStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operational status of the resource."""

    INVALID = "Invalid"
    UNKNOWN = "Unknown"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    UPDATING = "Updating"
    RUNNING = "Running"
    STOPPED = "Stopped"
    STOPPED_DEALLOCATED_ = "Stopped (deallocated)"


class ProvisioningStates(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the iSCSI Target."""

    INVALID = "Invalid"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PENDING = "Pending"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku name."""

    #: Premium locally redundant storage
    PREMIUM_LRS = "Premium_LRS"
    #: Premium zone redundant storage
    PREMIUM_ZRS = "Premium_ZRS"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku tier."""

    #: Premium Tier
    PREMIUM = "Premium"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the state of virtual network rule."""

    PROVISIONING = "provisioning"
    DEPROVISIONING = "deprovisioning"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    NETWORK_SOURCE_DELETED = "networkSourceDeleted"


class StorageTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage Target type."""

    ISCSI = "Iscsi"
    NONE = "None"
