#include <iostream>
#include <ctype.h>
#include <vector>

#include "Field.hh"
#include "Symmetry.hh"
#include "PointConfiguration.hh"
#include "Permutation.hh"
#include "IntegerSet.hh"


namespace topcom {

};

int main(const int argc, const char** argv) {
  using namespace topcom;

  if (argc < 2) {
    MessageStreams::forced() << "usage: " << argv[0] << " d" << std::endl;
    return 1;
  }
  parameter_type d(atol(argv[1]));
  PointConfiguration cross;
  cross.push_back(Vector(1, FieldConstants::MINUSONE));
  cross.push_back(Vector(1, FieldConstants::ONE));
  PointConfiguration interval(cross);
  for (parameter_type i = 1; i < d; ++i) {
    cross.direct_sum(interval);
  }
  cross.homogenize();
  MessageStreams::result() << cross << std::endl;
  
  // symmetries to be added.
  parameter_type n = 2*d;
  std::vector<Symmetry> pa;
  if (d > 0) {
    for (parameter_type i = 0; i < d; ++i) {     
      Symmetry planereflect(n);
      parameter_type tmp(planereflect[2 * i]);
      planereflect[2 * i] = planereflect[(2 * i + 1) % n];
      planereflect[(2 * i + 1) % n] = tmp;
      pa.push_back(planereflect);
    }
    Symmetry pointreflect(n);
    for (parameter_type i = 0; i < d - 1; ++i) {
      parameter_type tmp = pointreflect[2 * i];
      pointreflect[2 * i] = pointreflect[(2 * i + 2) % n];
      pointreflect[(2 * i + 2) % n] = tmp;
      tmp = pointreflect[(2 * i + 1) % n];
      pointreflect[(2 * i + 1) % n] = pointreflect[(2 * i + 3) % n];
      pointreflect[(2 * i + 3) % n] = tmp;
    }
    pa.push_back(pointreflect);
  }
  MessageStreams::result() << pa << std::endl;
  return 0;
}

// eof cross.cc
