#ifndef INCLUDED_TTHSUM_H
#define INCLUDED_TTHSUM_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * The tthsum application.
 */

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Option flags.
 */
struct tthsum_options {
    int has_locale;
    unsigned progress_every_mib;
    int use_mmap;
    int verbose;
    int warn;
};

/**
 * Generate a tthsum digest.
 */
int tthsum_generate_roots(const char** filenames, int files,
	const struct tthsum_options* opt);

/**
 * Check a tthsum digest.
 */
int tthsum_check_digest(const char* filenames,
	const struct tthsum_options* opt);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_TTHSUM_H */
