/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.text.DecimalFormat;
import java.util.Vector;
import spec.reporter.Metrics;
import spec.reporter.ReportProps;
import spec.reporter.Run;

public class Result {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static double maxBarWidth = 0.0;
    private static DecimalFormat memFormat = new DecimalFormat("##.0");
    private int best = -1;
    private int digits = 3;
    public StringBuffer invalidReason = new StringBuffer();
    public String name;
    public double referenceTime;
    public Run[] run;
    public boolean valid = true;
    public double weight;
    private int worst = -1;
    private double score;
    private int warehouses;
    public double heapsize;
    public double heapused;
    public double min_thread_transactions;
    public double max_thread_transactions;
    public double elapsed;
    public double meas_int;
    public double expected_peak;
    public int jvm_instances;
    public double ramp_up_int;
    public long start_rampup_time_milliseconds;
    public long end_rampdown_time_milliseconds;
    public long start_time_milliseconds;
    public long end_time_milliseconds;

    public Result(String string, ReportProps reportProps) {
        int n;
        this.name = string;
        this.weight = 1.0;
        this.referenceTime = reportProps.getDouble("config." + string + ".ref");
        if (maxBarWidth <= 0.0) {
            maxBarWidth = reportProps.getDouble("config.report.maxBarWidth");
        }
        Vector<Run> vector = new Vector<Run>(8);
        this.score = reportProps.getDouble("result." + string + ".company.score");
        this.warehouses = reportProps.getInt("result." + string + ".warehouses");
        this.elapsed = reportProps.getDouble("result." + string + ".elapsed_milliseconds");
        this.meas_int = reportProps.getDouble("input.measurement_seconds");
        this.jvm_instances = reportProps.getInt("input.jvm_instances");
        this.expected_peak = reportProps.getDouble("input.expected_peak_warehouse");
        this.ramp_up_int = reportProps.getDouble("input.ramp_up_seconds");
        this.heapsize = reportProps.getDouble("result." + string + ".company.heapsize");
        this.heapused = reportProps.getDouble("result." + string + ".company.heapused");
        if (this.jvm_instances > 1) {
            this.start_rampup_time_milliseconds = reportProps.getLong("result." + string + ".start_rampup_time_milliseconds");
            this.end_rampdown_time_milliseconds = reportProps.getLong("result." + string + ".end_rampdown_time_milliseconds");
            this.start_time_milliseconds = reportProps.getLong("result." + string + ".start_time_milliseconds");
            this.end_time_milliseconds = reportProps.getLong("result." + string + ".end_time_milliseconds");
        }
        this.min_thread_transactions = reportProps.getDouble("result." + string + ".company.min_thread_transactions");
        this.max_thread_transactions = reportProps.getDouble("result." + string + ".company.max_thread_transactions");
        for (n = 0; n < 6; ++n) {
            Run run = new Run(reportProps, n, 17.0, this);
            vector.addElement(run);
        }
        this.best = 2;
        this.worst = 1;
        this.run = new Run[vector.size()];
        if (this.run.length == 0) {
            this.valid = false;
            this.invalidReason.append(string + " was not run\n");
        } else {
            for (n = 0; n < this.run.length; ++n) {
                this.run[n] = (Run)vector.elementAt(n);
            }
        }
    }

    public double score() {
        return this.score;
    }

    public int warehouses() {
        return this.warehouses;
    }

    public double elapsed() {
        return this.elapsed;
    }

    public double meas_int() {
        return this.meas_int;
    }

    public double ramp_up_int() {
        return this.ramp_up_int;
    }

    public double expected_peak() {
        return this.expected_peak;
    }

    public long rampup_millis() {
        return this.start_rampup_time_milliseconds;
    }

    public long rampdown_millis() {
        return this.end_rampdown_time_milliseconds;
    }

    public long start_millis() {
        return this.start_time_milliseconds;
    }

    public long end_millis() {
        return this.end_time_milliseconds;
    }

    public String toDetailRows() {
        StringBuffer stringBuffer = new StringBuffer("<TR>\n");
        if (this.run.length == 0) {
            stringBuffer.append("  <TD>" + this.name + "</TD>\n");
            stringBuffer.append("  <TD COLSPAN=8><I>not run</I></TD>\n");
            stringBuffer.append("</TABLE>");
        } else {
            stringBuffer.append("  <TD VALIGN=TOP ALIGN=RIGHT ROWSPAN=" + this.run.length + ">" + this.warehouses + "</TD>\n");
            stringBuffer.append("  <TD VALIGN=TOP ALIGN=RIGHT ROWSPAN=" + this.run.length + ">" + Metrics.format(this.score) + "</TD>\n");
            stringBuffer.append("  <TD VALIGN=TOP ALIGN=RIGHT ROWSPAN=" + this.run.length + ">" + Metrics.format(this.heapsize) + "</TD>\n");
            stringBuffer.append("  <TD VALIGN=TOP ALIGN=RIGHT ROWSPAN=" + this.run.length + ">" + Metrics.format(this.heapused) + "</TD>\n");
            stringBuffer.append("  <TD VALIGN=TOP ALIGN=CENTER ROWSPAN=" + this.run.length + ">" + Metrics.format(100.0 * (this.max_thread_transactions - this.min_thread_transactions) / this.max_thread_transactions) + "% </TD>\n");
            stringBuffer.append("  <TD VALIGN=TOP ALIGN=RIGHT ROWSPAN=" + this.run.length + ">" + Metrics.format(0.1 * ((this.elapsed - 1000.0 * this.meas_int) / this.meas_int)) + "</TD>\n");
            stringBuffer.append(this.detailRow(0));
            stringBuffer.append("</TR>\n");
            for (int i = 1; i < this.run.length; ++i) {
                stringBuffer.append("<TR>\n");
                stringBuffer.append(this.detailRow(i));
                stringBuffer.append("</TR>\n");
            }
        }
        return stringBuffer.toString();
    }

    private String detailRow(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Run.transaction[n] + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + this.run[n].count + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.format(this.run[n].totaltime) + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.format(this.run[n].maximumtime) + "</TD>\n");
        return stringBuffer.toString();
    }

    public String toRow(int n) {
        StringBuffer stringBuffer = new StringBuffer("<TR>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + this.warehouses() + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.format(this.score()) + "</TD>\n");
        if (n <= this.warehouses() && this.warehouses() <= 2 * n) {
            stringBuffer.append("  <TD ALIGN=RIGHT> *  </TD>\n");
        } else {
            stringBuffer.append("  <TD ALIGN=RIGHT>    </TD>\n");
        }
        stringBuffer.append("</TR>\n");
        return stringBuffer.toString();
    }

    public String toFirstRow(int n) {
        StringBuffer stringBuffer = new StringBuffer("<TR>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + this.warehouses() + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.format(this.score()) + "</TD>\n");
        if (n <= this.warehouses() && this.warehouses() <= 2 * n) {
            stringBuffer.append("  <TD ALIGN=RIGHT> *  </TD>\n");
        } else {
            stringBuffer.append("  <TD ALIGN=RIGHT>  &nbsp   </TD>\n");
        }
        stringBuffer.append("  <TD ALIGN=RIGHT>  &nbsp </TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>  &nbsp   </TD>\n");
        stringBuffer.append("</TR>\n");
        return stringBuffer.toString();
    }

    public String shifted_toRow(int n) {
        StringBuffer stringBuffer = new StringBuffer("<TR>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + this.warehouses() + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>&nbsp</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>&nbsp</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.format(this.score()) + "</TD>\n");
        if (n <= this.warehouses() && this.warehouses() <= 2 * n) {
            stringBuffer.append("  <TD ALIGN=RIGHT> *  </TD>\n");
        } else {
            stringBuffer.append("  <TD ALIGN=RIGHT>  &nbsp   </TD>\n");
        }
        stringBuffer.append("</TR>\n");
        return stringBuffer.toString();
    }

    public String TwoRow(Result result, Metrics metrics, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("<TR>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + this.warehouses() + "</TD>\n");
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.format(this.score()) + "</TD>\n");
        if (n <= this.warehouses() && this.warehouses() <= 2 * n) {
            stringBuffer.append("  <TD ALIGN=RIGHT> *  </TD>\n");
        } else {
            stringBuffer.append("  <TD ALIGN=RIGHT>  &nbsp   </TD>\n");
        }
        stringBuffer.append("  <TD ALIGN=RIGHT>" + Metrics.format(metrics.score_at_wh(this.warehouses())) + "</TD>\n");
        if (n2 <= this.warehouses() && this.warehouses() <= 2 * n2) {
            stringBuffer.append("  <TD ALIGN=RIGHT> *  </TD>\n");
        } else {
            stringBuffer.append("  <TD ALIGN=RIGHT>   &nbsp  </TD>\n");
        }
        stringBuffer.append("</TR>\n");
        return stringBuffer.toString();
    }
}

