/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.overlay;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.media.j3d.Canvas3D;
import org.j3d.renderer.java3d.overlay.MouseOverlay;

public class ImageButtonOverlay
extends MouseOverlay {
    private static final int NUM_BUFFERS = 4;
    public static final int INACTIVE_IMAGE = 0;
    public static final int ACTIVE_IMAGE = 1;
    public static final int CLICKED_IMAGE = 2;
    public static final int MOUSEOVER_IMAGE = 3;
    private boolean[] hasImage = new boolean[4];
    private boolean mouseOver = false;
    private boolean stuck = false;
    private boolean clicked = false;

    public ImageButtonOverlay(Canvas3D canvas3D, Dimension dimension, BufferedImage[] bufferedImageArray) {
        this(canvas3D, dimension, true, false, bufferedImageArray);
    }

    public ImageButtonOverlay(Canvas3D canvas3D, Dimension dimension, boolean bl, boolean bl2, BufferedImage[] bufferedImageArray) {
        super(canvas3D, dimension, bl, bl2, null, 4);
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            boolean bl3 = this.hasImage[i] = bufferedImageArray[i] != null;
            if (!this.hasImage[i]) continue;
            this.updateBuffer(bufferedImageArray[i], i);
        }
        this.setActiveBuffer(0);
    }

    public void initialize() {
        this.addMouseListener(this);
        super.initialize();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.clicked = true;
        this.switchButtons();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.clicked = false;
        this.switchButtons();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.stuck = !this.stuck;
        this.clicked = false;
        this.switchButtons();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.switchButtons();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.clicked = false;
        this.switchButtons();
    }

    private synchronized void switchButtons() {
        if (this.mouseOver && this.clicked && this.hasImage[2]) {
            this.setActiveBuffer(2);
        } else if (this.mouseOver && this.hasImage[3]) {
            this.setActiveBuffer(3);
        } else if (this.stuck && this.hasImage[1]) {
            this.setActiveBuffer(1);
        } else if (this.hasImage[0]) {
            this.setActiveBuffer(0);
        } else {
            System.err.println("No images to choose from in ButtonOverlay");
        }
    }

    public void repaint() {
    }
}

