/*
 *  acm : an aerial combat simulator for X -- Viewers handling module
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _vlist_h
#define _vlist_h

#include "pm.h"

#ifdef viewer_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Attach a new viewer to the given aircraft and return its pointer.
 * The field c->vl must be already initialized or set to NULL.
 */
EXTERN viewer * viewer_new(craft *c);


/**
 * Release the viewer, close the window, and detach the viewer from the
 * craft's list of viewers.
 */
EXTERN void viewer_free(viewer *v);

#undef EXTERN
#endif
