# ASN counter

Count the number of hits (HTTP, packets, etc) per autonomous system
number (ASN) and related network blocks. 

This is useful when you get a lot of traffic on a server to figure out
which network is responsible for the traffic, to direct abuse
complaints or block whole networks, or on core routers to figure out
who your peers are and who you might want to seek particular peering
agreements with.

## Features

 - reads packets from a text file (or stdin) one per line
 - counts number of hits, packets, sizes, latency, etc per ASN and netblock
 - can parse some tcpdump output or read packets directly from
   interfaces with [scapy][]
 - fast ASN lookups [pyasn][]
 - automatic download of [relevant databases](https://archive.routeviews.org/route-views4/bgpdata/) from
   [routeviews.org](https://routeviews.org/)
 - Prometheus exporter
 - written in Python
 - optional Python REPL interpreter shell to drill into reports

 [scapy]: https://scapy.readthedocs.io/
 [pyasn]: https://github.com/hadiasghari/pyasn

See the [manual page](asncounter.1.md) for full documentation and
examples. See also the [test suite and performance metrics](test/README.md).

See [CONTRIBUTING.md](CONTRIBUTING.md) for how to contribute, file
issues, or get help.

# Installation

Simply:

    pip install asncounter

Can also run from the source directory directly.

Note that the `pip` install does not build or deploy the manual page,
as that depends on `pandoc` or some markdown-to-man converter, which
feels too complicated to setup in the Python tool chain.

The Debian package properly builds and ships the manual page, however,
see `debian/rules` for an example of how to package this on your own
distribution.

## Dependencies

- [pyasn][]

## Optional dependencies

- [manhole][]: to get a debugging socket
- [scapy][]: to scrape packets directly without tcpdump (slower)
- [prometheus_client][]: to export Prometheus metrics
- [netaddr][]: to aggregate network blocks in the REPL or manhole

[prometheus_client]: https://prometheus.github.io/client_python/
[manhole]: https://github.com/ionelmc/python-manhole
[netaddr]: https://netaddr.readthedocs.io
