
# 0.16

Read all about it at these links:

  * http://elm-lang.org/blog/compilers-as-assistants
  * https://github.com/elm-lang/elm-platform/blob/master/upgrade-docs/0.16.md


# 0.15

### Improve Import Syntax

The changes in 0.14 meant that people were seeing pretty long import sections,
sometimes with two lines for a single module to bring it in qualified and to
expose some unqualified values. The new syntax is like this:

```elm
import List
  -- Just bring `List` into scope, allowing you to say `List.map`,
  -- `List.filter`, etc.

import List exposing (map, filter)
  -- Bring `List` into scope, but also bring in `map` and `filter`
  -- without any prefix.

import List exposing (..)
  -- Bring `List` into scope, and bring in all the values in the
  -- module without a prefix.

import List as L
  -- Bring `L` into scope, but not `List`. This lets you say `L.map`,
  -- `L.filter`, etc.

import List as L exposing (map, filter)
  -- Bring `L` into scope along with unqualified versions of `map`
  -- and `filter`.

import List as L exposing (..)
  -- Bring in all the values unqualified and qualified with `L`.
```

This means you are doing more with each import, writing less overall. It also
makes the default imports more comprehensive because you now can refer to
`List` and `Result` without importing them explicitly as they are in the
defaults.

### Revise Port Syntax

One common confusion with the `port` syntax is that the only difference
between incoming ports and outgoing ports is whether the type annotation comes
with a definition. To make things a bit clearer, we are using the keywords
`foreign input` and `foreign output`.

```elm
foreign input dbResults : Stream String

foreign output dbRequests : Stream String
foreign output dbRequests =
    Stream.map toRequest userNames
```

### Input / Output

The biggest change in 0.15 is the addition of tasks, allowing us to represent
arbitrary effects in Elm in a safe way. This parallels how ports work, so we
are trying to draw attention to that in syntax. First addition is a way to
create new inputs to an Elm program.

```elm
input actions : Input Action
```

This creates a `Input` that is made up of an `Address` you can send messages to
and a `Stream` of those messages. This is similar to a `foreign input` except
there we use the name as the address. The second addition is a way to run
tasks.

```elm
output Stream.map toRequest userNames
```

This lets us turn tasks into effects in the world. Sometimes it is useful to
pipe the results of these tasks back into Elm. For that, we have the third and
final addition.

```elm
input results : Stream (Result Http.Error String)
input results from
    Stream.map toRequest userNames
```

# 0.14.1

Modify default import of `List` to expose `(::)` as well.


# 0.14

### Breaking Changes

  * Keyword `data` renamed to `type`
  * Keyword `type` renamed to `type alias`


# 0.13

### Improvements:

  * Type aliases in port types 
  * Add Keyboard.alt and Keyboard.meta
  * Add Debug.crash, Debug.watch, Debug.watchSummary, and Debug.trace
  * Add List.indexedMap and List.filterMap
  * Add Maybe.map
  * Add Basics.negate
  * Add (>>) to Basics as in F#
  * Add --bundle-runtime flag which creates stand-alone Elm programs
  * Error on ambiguious use of imported variables
  * Replace dependency on Pandoc with cheapskate+kate
  * Better architecture for compiler. Uses types to make compilation pipeline
    safer, setting things up for giving programmatic access to the AST to
    improve editor and IDE support.

### Breaking Changes:

  * Rename (.) to (<<) as in F#
  * Rename Basics.id to Basics.identity
  * Rename Basics.div to (//)
  * Rename Basics.mod to (%)
  * Remove Maybe.justs for (List.filterMap identity)
  * Remove List.and for (List.foldl (&&) True)
  * Remove List.or  for (List.foldl (||) False)
  * Unambiguous syntax for importing ADTs and type aliases
  * sqrt and logBase both only work on Floats now

# 0.12.3

  * Minor changes to support webgl as a separate library
  * Switch from HSV to HSL
  * Programmatic access to colors with toHsl and toRgb

# 0.12.1

### Improvements:

  * New Array library (thanks entirely to @Xashili)
  * Json.Value can flow through ports
  * Improve speed and stack usage in List library (thanks to @maxsnew)
  * Add Dict.filter and Dict.partition (thanks to @hdgarrood)

### Breaking Changes:

  * Revamp Json library, simpler with better names
  * Revamp JavaScript.Experimental library to have slightly better names
  * Remove JavaScript library which was made redundant by ports

# 0.12

### Breaking Changes:

  * Overhaul Graphics.Input library (inspired by Spiros Eliopoulos and Jeff Smitts)
  * Overhaul Text library to accomodate new Graphics.Input.Field
    library and make the API more consistent overall
  * Overhaul Regex library (inspired by Attila Gazso)
  * Change syntax for "import open List" to "import List (..)"
  * Improved JSON format for types generated by elm-doc
  * Remove problematic Mouse.isClicked signal
  * Revise the semantics of keepWhen and dropWhen to only update when
    the filtered signal changes (thanks Max New and Janis Voigtländer)

### Improvements:

  * Add Graphics.Input.Field for customizable text fields
  * Add Trampoline library (thanks to @maxsnew and @timthelion) 
  * Add Debug library (inspired by @timthelion)
  * Drastically improved performance on markdown parsing (thanks to @Dandandan) 
  * Add Date.fromTime function
  * Use pointer-events to detect hovers on layered elements (thanks to @Xashili)
  * Fix bugs in Bitwise library
  * Fix bug when exporting Maybe values through ports

# 0.11

  * Ports, a new FFI that is more general and much nicer to use
  * Basic compiler tests (thanks to Max New)

# 0.10.1

  * sort, sortBy, sortWith (thanks to Max Goldstein)
  * elm-repl
  * Bitwise library
  * Regex library
  * Improve Transform2D library (thanks to Michael Søndergaard)

# 0.10

  * Native strings
  * Tango colors
  * custom precedence and associativity for infix operators
  * elm-doc released with new documentation format
  * Realiasing in type errors
  * Rename Matrix2D => Transform2D
  * Add Random.floatList (thank you Max GoldStein)
  * Fix remove function in Dict (thank you Max New)
  * Start using language-ecmascript for JS generation
  * Make compatable with cabal-1.18 (thank you Justin Leitgeb)
  * All functions with 10+ arguments (thanks to Max New)

# 0.9.1

  * Allow custom precedence and associativity for user-defined infix ops
  * Realias types before printing
  * Switch to Tango color scheme, adding a bunch of nice colors
  * add the greyscale function for easily producing greys
  * Check the type of main
  * Fix miscellaneous bugs in type checker
  * Switch name of Matrix2D to Transform2D

# 0.9

Build Improvements:
  * Major speed improvements to type-checker
  * Type-checker should catch _all_ type errors now
  * Module-level compilation, only re-compile if necessary
  * Import types and type aliases between modules
  * Intermediate files are generated to avoid unneeded recompilation
    and shorten compile time. These files go in ElmFiles/ by default
  * Generated files are placed in ElmFiles/ by default, replicating
    the directory structure of your source code.

Error Messages:
  * Cross-module type errors
  * Errors for undefined values
  * Pretty printing of expressions and types
 
Syntax:
  * Pattern matching on literals
  * Pattern aliases with `as` (Andrew)
  * Unary negation
  * Triple-quoted multi-line strings
  * Type annotations in let expressions (Andrew)
  * Record Constructors
  * Record type aliases can be closed on the zeroth column
  * (,,) syntax in types
  * Allow infix op definitions without args: (*) = add
  * Unparenthesized if, let, case, lambda at end of binary expressions

elm-server:
  * Build multi-module projects
  * Report all errors in browser

Libraries:
  * Detect hovering over any Element
  * Set alpha of arbitrary forms in collages
  * Switch Text.height to use px instead of em

Bug Fixes:
  * Many bug fixes for collage, especially when rendering Elements.

Website:
  * Hot-swapping
  * Much faster page load with pre-compiled Elm files (Max New)




forgot to fill this in again...


# 0.7.2

* Add a WebSockets library.
* Add support for the mathematical looking operator for function composition (U+2218).


forgot to fill this in for a while...


# 0.5.0

* Add Dict, Set, and Automaton libraries!

* Add (,,) notation for creating tuples.

* Redo HTTP library, allowing any kind of request and more flexibility.

* Remove the library prefixes `Data.`, `Graphics.`, and `Signal.` because
  they were more confusing than helpful.

* Better type error reporting for ambiguous uses of variables and for
  variables in aliased modules.

* Add `readInt` and `readFloat` functions.
* Add `complement` function to compute complementary colors.
* Ensure that `String` is treated as an alias of `[Char]`.

* Fix bug in pattern parsing. `A B _ _` was parsed as `A (B _ _)`.
* Make pattern matching a bit more compact in generated code.
* Make generated JS more readable.

* The Haskell API exports the absolute path to the Elm runtime
  system (with the corresponding version number). This makes it easier
  to run Elm programs with less setup.



# 0.4.0

This version is all about graphics: nicer API with more features and major
efficiency improvements. I am really excited about this release!

* Add native Markdown support. You can now embed markdown directly in .elm files
  and it is used as an `Element`. Syntax is `[markdown| ... |]` where `...` is
  formatted as described [here](http://daringfireball.net/projects/markdown/).
  Content can span multiple lines too.

* Drastically improve the `collage` interface. You can now move, rotate, and scale
  the following forms:
  - Elements (any Element you want can be turned into a Form with `toForm`)
  - Images
  - Shapes (shapes can be textured now too)
  - Lines
  This will make it way easier to make games in Elm. Games can now include text,
  gifs, videos, and any other Element you can think of.

* Add `--minify` flag, to minify JS code.

* Significantly improve performance of pattern matching.

* Compiler performs beta-reduction in some simple cases.

* The rendering section of the Elm runtume-system (RTS) has been totally rewritten,
  making screen refreshes use fewer cycles, less memory, and cause less garbage-collection.



# 0.3.6

* Add JSON library.

* Type-error messages improved. Gives better context for error, making them
  easier to find. Better messages for runtime errors as well (errors that
  the type checker cannot find yet).

* Add Comparable super-type which allows the comparision of any values
  of type {Int,Float,Char,String}. Now possible to make Set and Map libraries.

* Parser now handles decimal numbers.

* Added many new functions for manipulating numbers:
  - truncate, round, floor, ceiling :: Float -> Int
  - toFloat :: Int -> Float
  - (^) :: Number -> Number -> Number
  - e :: Float

* Foreign import/export statements no longer have to preceed all other
  variable and datatype definitions. They can be mixed in, making things
  a bit more readable/natural.

* Bug fixes:
  - The `toText` function did not escape strings properly
  - Correct `castJSTupleToTupleN` family of functions
  - `foldr1` took the leftmost element as the base case instead of the rightmost
  - Fix minor display issue in latest version of Chrome.
  - Fix behavior of [ lo .. hi ] syntax (now [4..0] == [], not [0]).



# 0.3.5

* Add JavaScript event interface. Allows Elm to import and export JS values
  and events. This makes it possible to import and export Elements, so users
  can use JS techniques and libraries if necessary. Conversion between JS
  and Elm values happens with functions from here:
    http://localhost:8000/docs/Foreign/JavaScript.elm
    http://localhost:8000/docs/Foreign/JavaScript/Experimental.elm

* Add new flags to help with JavaScript event interface.

* Add three built-in event listeners (elm_title, elm_log, elm_redirect) that
  make it possible to make some common/simple imperative actions without
  having to worry about writing the JS yourself. For example:
        foreign export jsevent "elm_title"
            title :: Signal JSString
  will update the page's title to the current value of the title signal.
  Empty strings are ignored. "elm_redirect" and "elm_log" events work much
  the same way, except that "elm_log" does not skip empty strings.

* Add new Signal functions:
    count       :: Signal a -> Signal Int
    keepIf      :: (a -> Bool) -> a -> Signal a -> Signal a
    dropIf      :: (a -> Bool) -> a -> Signal a -> Signal a
    keepWhen    :: Signal Bool -> a -> Signal a -> Signal a
    dropWhen    :: Signal Bool -> a -> Signal a -> Signal a
    dropRepeats :: Signal a -> Signal a
    sampleOn    :: Signal a -> Signal b -> Signal b
    clicks      :: Signal ()
  The keep and drop functions make it possible to filter events, which
  was not possible in prior releases. More documentation:
  http://elm-lang.org/docs/Signal/Signal.elm

* Add examples of JS event interface and new signal functions:
  https://github.com/evancz/Elm/tree/master/Examples/elm-js

* Use more compressed format for strings. Should make strings 10-12 times
  more space efficient than in previous releases. Anecdotal evidence:
  Elm's home page is now 70% of its previous size.

* Add new function to Data.List:
    last :: [a] -> a

* Fix parenthesization bug with binary operators.



# 0.3.0

### Major Changes (Read this part!)

* Add a basic module system.
* Elm's JavaScript runtime is now distributed with the elm package.
  Previously it was available for download as an unversioned JavaScript
  file (elm-mini.js). It is now installed with the elm compiler as
  elm-runtime-0.3.0.js. Be sure to serve the Elm runtime system that matches
  the version of the compiler used to generate JavaScript. When working
  locally, the compiler will automatically use your local copy of this file.
* BREAKING CHANGE: rgb and rgba (in the color module) now take their red,
  green, and blue components as integers between 0 and 255 inclusive.
* Improve error messages for parse errors and runtime errors.


### New Functions and Other Additions

* Add support for keyboard events: Keyboard.Raw
* Add buttons in Signal.Input:
  button :: String -> (Element, Signal Bool)
* Add new basic element (an empty rectangle, good for adding spaces):
  rectangle :: Int -> Int -> Element
* Add (an awkwardly named) way to display right justified text: rightedText
* Add two basic libraries: Data.Char and Data.Maybe
* Add some new colors: magenta, yellow, cyan, gray, grey
* Add functions to Data.List module: take, drop
* Add functions to Prelude (the default imports):
  fst, snd, curry, uncurry, and a bunch of list functions
* Add --make, --separate-js, and --only-js flags to help compile
  with the new module system.
