!{\src2tex{textfont=tt}}
!!****m* etsf_split/etsf_io_split_put
!! NAME
!!  etsf_io_split_put
!!
!! FUNCTION
!!    Simply write the split definition (of associated pointers) to the file.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * split <type(etsf_split)> = 
!!     copy the allocated arrays from this argument to the disk.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_split_put(ncid, split, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_split), intent(in) :: split
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_split_put'


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_split_put : enter'
!ENDDEBUG

  if (associated(split%my_kpoints)) then
    call etsf_io_low_write_var(ncid, "my_kpoints", &
                            & split%my_kpoints, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (associated(split%my_grid_points_vector3)) then
    call etsf_io_low_write_var(ncid, "my_grid_points_vector3", &
                            & split%my_grid_points_vector3, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (associated(split%my_spins)) then
    call etsf_io_low_write_var(ncid, "my_spins", &
                            & split%my_spins, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (associated(split%my_grid_points_vector1)) then
    call etsf_io_low_write_var(ncid, "my_grid_points_vector1", &
                            & split%my_grid_points_vector1, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (associated(split%my_grid_points_vector2)) then
    call etsf_io_low_write_var(ncid, "my_grid_points_vector2", &
                            & split%my_grid_points_vector2, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (associated(split%my_coefficients)) then
    call etsf_io_low_write_var(ncid, "my_coefficients", &
                            & split%my_coefficients, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (associated(split%my_components)) then
    call etsf_io_low_write_var(ncid, "my_components", &
                            & split%my_components, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (associated(split%my_states)) then
    call etsf_io_low_write_var(ncid, "my_states", &
                            & split%my_states, &
                            & lstat, error_data = error_data)
    if (.not. lstat) return
  end if


!DEBUG
!write (*,*) 'etsf_io_split_put : exit'
!ENDDEBUG

end subroutine etsf_io_split_put
!!***
