#!/bin/sh

. "`dirname \"$0\"`/common_minimal.sh"

ACCEPT_SCRIPT="$THIS_DIR/test_handle.py"
ACCEPT_ARGS="accept $STORE_TYPE $STORE $JOURNAL $PREFS"

COUNTER_SCRIPT="$THIS_DIR/test_handle.py"
COUNTER_ARGS="counter $STORE_TYPE $STORE $JOURNAL $PREFS"

DECLINE_SCRIPT="$THIS_DIR/test_handle.py"
DECLINE_ARGS="decline $STORE_TYPE $STORE $JOURNAL $PREFS"

FREEBUSY_SCRIPT="$BASE_DIR/tools/make_freebusy.py"
FREEBUSY_ARGS="-s -n"
FREEBUSY_QUOTA_ARGS="-s -q"

LIST_SCRIPT="$THIS_DIR/list_table.py"
LIST_ARGS="$STORE_TYPE $STORE $JOURNAL"

OUTGOING_SCRIPT="$BASE_DIR/imip_person_outgoing.py"

PERSON_SCRIPT="$BASE_DIR/imip_person.py"

SET_DELEGATES="$BASE_DIR/tools/set_delegates.py"
SET_DELEGATES_ARGS="-T $STORE_TYPE -j $JOURNAL" 

SET_QUOTA_GROUPS="$BASE_DIR/tools/set_quota_groups.py"
SET_QUOTA_GROUPS_ARGS="-T $STORE_TYPE -j $JOURNAL" 

SET_QUOTA_LIMITS="$BASE_DIR/tools/set_quota_limits.py"
SET_QUOTA_LIMITS_ARGS="-T $STORE_TYPE -j $JOURNAL" 

TAB=`printf '\t'`

PYTHONPATH="$BASE_DIR"
export PYTHONPATH

if [ "$STORE_TYPE" = "file" ]; then
    rm -rf "$STORE"
    rm -rf "$JOURNAL"
elif [ "$STORE_TYPE" = "postgresql" ]; then
    dropdb "$DBNAME"
    createdb "$DBNAME"
    psql -q -f "$BASE_DIR/conf/postgresql/schema.sql" "$DBNAME" 2>> $DBERROR
fi

rm -rf "$STATIC"
rm -rf "$PREFS"
rm -f "$ERROR"
rm -f out*.tmp
