#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

# Copyright © 2017
#       Dominik George <nik@naturalnet.de>
#
# Provided that these terms and disclaimer and all copyright notices
# are retained or reproduced in an accompanying document, permission
# is granted to deal in this work without restriction, including un‐
# limited rights to use, publicly perform, distribute, sell, modify,
# merge, give away, or sublicence.
#
# This work is provided “AS IS” and WITHOUT WARRANTY of any kind, to
# the utmost extent permitted by applicable law, neither express nor
# implied; without malicious intent or gross negligence. In no event
# may a licensor, author or contributor be held liable for indirect,
# direct, other damage, loss, or other issues arising in any way out
# of dealing in the work, even if advised of the possibility of such
# damage or existence of a defect, except proven that it results out
# of said person’s immediate fault when using the work as intended.

import os
import unittest

from .util import round_sequence_r

from mmllib.parser import mml_file
from mmllib.playlist import convert_to_timedlist

class PlaylistTests(unittest.TestCase):
    def setUp(self):
        self.datadir = os.path.join(os.path.dirname(__file__), "data")
        self.examplesdir = os.path.abspath(os.path.join(self.datadir, "..", "..", "examples"))

    def test_convert_to_timedlist(self):
        mmlfile = os.path.join(self.examplesdir, "loreley.mml")
        res, errors = convert_to_timedlist(mml_file(mmlfile))
        expected = [(0.39473684210526316,
                     [(0.0, [(1, 391.99543598174927)]), (0.34538999999999997, [(1, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 130.81278265029931)]),
                      (0.19736000000000001, [(4, 195.99771799087463)]),
                      (0.39473000000000003, [(4, 261.62556530059862)]),
                      (0.59209999999999996, [(1, 440.0), (2, 349.22823143300388)]),
                      (0.76480000000000004, [(1, 0), (2, 0)]),
                      (0.78947000000000001,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 195.99771799087463)]),
                      (1.13486, [(1, 0), (2, 0), (4, 0)]),
                      (1.18421,
                       [(1, 523.25113060119725),
                        (2, 349.22823143300388),
                        (4, 130.81278265029931)]),
                      (1.38157, [(4, 220.0)]),
                      (1.57894, [(1, 493.88330125612413), (4, 293.66476791740757)]),
                      (1.9243399999999999, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 440.0), (2, 349.22823143300388), (4, 246.94165062806206)]),
                      (2.31907, [(1, 0), (2, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 130.81278265029931)]),
                      (0.19736000000000001, [(4, 195.99771799087463)]),
                      (0.39473000000000003, [(4, 261.62556530059862)]),
                      (0.78947000000000001, [(4, 195.99771799087463)]),
                      (1.0361800000000001, [(1, 0), (2, 0)]),
                      (1.13486, [(4, 0)]),
                      (1.18421,
                       [(1, 349.22823143300388),
                        (2, 293.66476791740757),
                        (4, 87.307057858250971)]),
                      (1.38157, [(4, 174.61411571650194)]),
                      (1.57894, [(4, 220.0)]),
                      (1.875, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 349.22823143300388),
                        (2, 293.66476791740757),
                        (4, 174.61411571650194)]),
                      (2.31907, [(1, 0), (2, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 329.62755691286992),
                        (2, 261.62556530059862),
                        (4, 97.998858995437331)]),
                      (0.19736000000000001, [(4, 164.81377845643496)]),
                      (0.39473000000000003, [(4, 195.99771799087463)]),
                      (0.51809000000000005, [(1, 0), (2, 0)]),
                      (0.59209999999999996, [(1, 329.62755691286992), (2, 261.62556530059862)]),
                      (0.76480000000000004, [(1, 0), (2, 0)]),
                      (0.78947000000000001,
                       [(1, 329.62755691286992),
                        (2, 261.62556530059862),
                        (4, 164.81377845643496)]),
                      (1.13486, [(1, 0), (2, 0), (4, 0)]),
                      (1.18421,
                       [(1, 293.66476791740757),
                        (2, 246.94165062806206),
                        (3, 195.99771799087463),
                        (4, 97.998858995437331)]),
                      (1.57894, [(1, 261.62556530059862), (2, 220.0)]),
                      (1.875, [(3, 0), (4, 0)]),
                      (1.9243399999999999, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 293.66476791740757),
                        (2, 246.94165062806206),
                        (3, 195.99771799087463),
                        (4, 97.998858995437331)]),
                      (2.31907, [(1, 0), (2, 0), (3, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 329.62755691286992),
                        (2, 261.62556530059862),
                        (3, 195.99771799087463),
                        (4, 130.81278265029931)]),
                      (0.39473000000000003, [(3, 0), (4, 97.998858995437331)]),
                      (0.78947000000000001, [(4, 82.40688922821748)]),
                      (1.18421, [(4, 65.406391325149656)]),
                      (1.5296000000000001, [(1, 0), (2, 0)]),
                      (1.875, [(4, 0)]),
                      (1.9736800000000001, [(1, 391.99543598174927)]),
                      (2.31907, [(1, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 130.81278265029931)]),
                      (0.19736000000000001, [(4, 195.99771799087463)]),
                      (0.39473000000000003, [(4, 261.62556530059862)]),
                      (0.59209999999999996, [(1, 440.0), (2, 349.22823143300388)]),
                      (0.76480000000000004, [(1, 0), (2, 0)]),
                      (0.78947000000000001,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 195.99771799087463)]),
                      (1.13486, [(1, 0), (2, 0), (4, 0)]),
                      (1.18421,
                       [(1, 523.25113060119725),
                        (2, 349.22823143300388),
                        (4, 130.81278265029931)]),
                      (1.38157, [(4, 220.0)]),
                      (1.57894, [(1, 493.88330125612413), (4, 293.66476791740757)]),
                      (1.9243399999999999, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 440.0), (2, 349.22823143300388), (4, 246.94165062806206)]),
                      (2.31907, [(1, 0), (2, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 130.81278265029931)]),
                      (0.19736000000000001, [(4, 195.99771799087463)]),
                      (0.39473000000000003, [(4, 261.62556530059862)]),
                      (0.78947000000000001, [(4, 195.99771799087463)]),
                      (1.0361800000000001, [(1, 0), (2, 0)]),
                      (1.13486, [(4, 0)]),
                      (1.18421,
                       [(1, 349.22823143300388),
                        (2, 293.66476791740757),
                        (4, 87.307057858250971)]),
                      (1.38157, [(4, 174.61411571650194)]),
                      (1.57894, [(4, 220.0)]),
                      (1.875, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 349.22823143300388),
                        (2, 293.66476791740757),
                        (4, 174.61411571650194)]),
                      (2.31907, [(1, 0), (2, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 329.62755691286992),
                        (2, 261.62556530059862),
                        (4, 97.998858995437331)]),
                      (0.34538999999999997, [(4, 0)]),
                      (0.39473000000000003, [(4, 195.99771799087463)]),
                      (0.51809000000000005, [(1, 0), (2, 0)]),
                      (0.59209999999999996, [(1, 329.62755691286992), (2, 261.62556530059862)]),
                      (0.74012999999999995, [(4, 0)]),
                      (0.76480000000000004, [(1, 0), (2, 0)]),
                      (0.78947000000000001,
                       [(1, 329.62755691286992),
                        (2, 261.62556530059862),
                        (4, 130.81278265029931)]),
                      (1.13486, [(1, 0), (2, 0), (4, 0)]),
                      (1.18421,
                       [(1, 391.99543598174927),
                        (2, 246.94165062806206),
                        (3, 146.83238395870379),
                        (4, 97.998858995437331)]),
                      (1.5296000000000001, [(1, 0), (2, 0), (3, 0), (4, 0)]),
                      (1.57894,
                       [(1, 349.22823143300388),
                        (2, 246.94165062806206),
                        (3, 146.83238395870379),
                        (4, 97.998858995437331)]),
                      (1.9243399999999999, [(1, 0), (2, 0), (3, 0), (4, 0)]),
                      (1.9736800000000001,
                       [(1, 293.66476791740757),
                        (2, 246.94165062806206),
                        (3, 174.61411571650194),
                        (4, 97.998858995437331)]),
                      (2.31907, [(1, 0), (2, 0), (3, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 261.62556530059862),
                        (3, 164.81377845643496),
                        (4, 130.81278265029931)]),
                      (0.39473000000000003, [(3, 0), (4, 82.40688922821748)]),
                      (0.78947000000000001, [(4, 97.998858995437331)]),
                      (1.18421, [(4, 65.406391325149656)]),
                      (1.5296000000000001, [(1, 0)]),
                      (1.875, [(4, 0)]),
                      (1.9736800000000001, [(1, 329.62755691286992)]),
                      (2.31907, [(1, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 293.66476791740757),
                        (2, 246.94165062806206),
                        (4, 97.998858995437331)]),
                      (0.39473000000000003, [(4, 146.83238395870379)]),
                      (0.59209999999999996, [(1, 329.62755691286992), (2, 261.62556530059862)]),
                      (0.76480000000000004, [(1, 0), (2, 0)]),
                      (0.78947000000000001,
                       [(1, 293.66476791740757),
                        (2, 246.94165062806206),
                        (4, 195.99771799087463)]),
                      (1.13486, [(1, 0), (2, 0), (4, 0)]),
                      (1.18421,
                       [(1, 391.99543598174927),
                        (2, 246.94165062806206),
                        (3, 293.66476791740757),
                        (4, 97.998858995437331)]),
                      (1.5296000000000001, [(1, 0), (2, 0), (3, 0)]),
                      (1.57894,
                       [(1, 293.66476791740757),
                        (2, 246.94165062806206),
                        (4, 146.83238395870379)]),
                      (1.9243399999999999, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 293.66476791740757),
                        (2, 246.94165062806206),
                        (4, 195.99771799087463)]),
                      (2.31907, [(1, 0), (2, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 493.88330125612413),
                        (2, 293.66476791740757),
                        (3, 391.99543598174927),
                        (4, 97.998858995437331)]),
                      (0.39473000000000003, [(4, 146.83238395870379)]),
                      (0.78947000000000001, [(4, 195.99771799087463)]),
                      (1.0361800000000001, [(1, 0), (2, 0), (3, 0)]),
                      (1.13486, [(4, 0)]),
                      (1.18421,
                       [(1, 440.0),
                        (2, 261.62556530059862),
                        (3, 329.62755691286992),
                        (4, 65.406391325149656)]),
                      (1.57894, [(4, 164.81377845643496)]),
                      (1.875, [(1, 0), (2, 0), (3, 0)]),
                      (1.9736800000000001,
                       [(1, 440.0),
                        (2, 261.62556530059862),
                        (3, 329.62755691286992),
                        (4, 220.0)]),
                      (2.31907, [(1, 0), (2, 0), (3, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 246.94165062806206),
                        (3, 293.66476791740757),
                        (4, 73.416191979351879)]),
                      (0.39473000000000003, [(4, 146.83238395870379)]),
                      (0.69077999999999995, [(1, 0), (2, 0), (3, 0)]),
                      (0.78947000000000001,
                       [(1, 391.99543598174927),
                        (3, 293.66476791740757),
                        (4, 246.94165062806206)]),
                      (1.13486, [(1, 0), (3, 0), (4, 0)]),
                      (1.18421, [(1, 369.99442271163446), (2, 220.0), (3, 146.83238395870379)]),
                      (1.57894, [(1, 391.99543598174927), (2, 246.94165062806206)]),
                      (1.875, [(3, 0)]),
                      (1.9243399999999999, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 440.0),
                        (2, 261.62556530059862),
                        (3, 146.83238395870379),
                        (4, 184.99721135581723)]),
                      (2.31907, [(1, 0), (2, 0), (3, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 97.998858995437331),
                        (3, 146.83238395870379),
                        (4, 246.94165062806206)]),
                      (0.39473000000000003, [(2, 123.47082531403103), (4, 293.66476791740757)]),
                      (0.78947000000000001, [(2, 130.81278265029931), (4, 329.62755691286992)]),
                      (1.18421, [(2, 146.83238395870379), (4, 349.22823143300388)]),
                      (1.57894, [(2, 130.81278265029931), (4, 329.62755691286992)]),
                      (1.875, [(1, 0), (3, 0)]),
                      (1.9736800000000001,
                       [(1, 391.99543598174927),
                        (2, 123.47082531403103),
                        (3, 349.22823143300388),
                        (4, 293.66476791740757)]),
                      (2.31907, [(1, 0), (2, 0), (3, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 130.81278265029931)]),
                      (0.19736000000000001, [(4, 195.99771799087463)]),
                      (0.39473000000000003, [(4, 261.62556530059862)]),
                      (0.51809000000000005, [(1, 0), (2, 0)]),
                      (0.59209999999999996, [(1, 440.0), (2, 349.22823143300388)]),
                      (0.76480000000000004, [(1, 0), (2, 0)]),
                      (0.78947000000000001,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 195.99771799087463)]),
                      (1.13486, [(1, 0), (2, 0), (4, 0)]),
                      (1.18421,
                       [(1, 523.25113060119725),
                        (2, 349.22823143300388),
                        (4, 130.81278265029931)]),
                      (1.38157, [(4, 220.0)]),
                      (1.57894, [(1, 493.88330125612413), (4, 293.66476791740757)]),
                      (1.9243399999999999, [(1, 0), (2, 0)]),
                      (1.9736800000000001,
                       [(1, 440.0), (2, 349.22823143300388), (4, 246.94165062806206)]),
                      (2.31907, [(1, 0), (2, 0), (4, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 391.99543598174927),
                        (2, 329.62755691286992),
                        (4, 130.81278265029931)]),
                      (0.19736000000000001, [(4, 195.99771799087463)]),
                      (0.39473000000000003, [(4, 261.62556530059862)]),
                      (0.56742999999999999, [(4, 0)]),
                      (0.78947000000000001, [(1, 659.25511382573984), (2, 391.99543598174927)]),
                      (1.13486, [(1, 0), (2, 0)]),
                      (1.18421,
                       [(1, 587.32953583481515),
                        (2, 349.22823143300388),
                        (4, 87.307057858250971)]),
                      (1.38157, [(4, 220.0)]),
                      (1.57894, [(4, 293.66476791740757)]),
                      (1.7516400000000001, [(4, 0)]),
                      (1.875, [(1, 0), (2, 0)]),
                      (1.9736800000000001, [(1, 587.32953583481515), (2, 349.22823143300388)]),
                      (2.31907, [(1, 0), (2, 0)])]),
                    (2.3684210526315792,
                     [(0.0,
                       [(1, 523.25113060119725),
                        (2, 329.62755691286992),
                        (4, 97.998858995437331)]),
                      (0.19736000000000001, [(4, 195.99771799087463)]),
                      (0.39473000000000003, [(4, 261.62556530059862)]),
                      (0.51809000000000005, [(1, 0), (2, 0)]),
                      (0.56742999999999999, [(4, 0)]),
                      (0.59209999999999996, [(1, 523.25113060119725), (2, 329.62755691286992)]),
                      (0.76480000000000004, [(1, 0), (2, 0)]),
                      (0.78947000000000001, [(1, 523.25113060119725), (2, 329.62755691286992)]),
                      (1.13486, [(1, 0), (2, 0)]),
                      (1.18421,
                       [(1, 493.88330125612413),
                        (2, 349.22823143300388),
                        (3, 195.99771799087463),
                        (4, 293.66476791740757)]),
                      (1.5296000000000001, [(3, 0), (4, 0)]),
                      (1.57894, [(1, 440.0), (3, 195.99771799087463), (4, 261.62556530059862)]),
                      (1.9243399999999999, [(1, 0), (2, 0), (3, 0), (4, 0)]),
                      (1.9736800000000001,
                       [(1, 493.88330125612413),
                        (2, 349.22823143300388),
                        (3, 195.99771799087463),
                        (4, 293.66476791740757)]),
                      (2.31907, [(1, 0), (2, 0), (3, 0), (4, 0)])]),
                    (1.9736842105263159,
                     [(0.0,
                       [(1, 523.25113060119725),
                        (2, 329.62755691286992),
                        (3, 195.99771799087463),
                        (4, 130.81278265029931)]),
                      (0.39473000000000003, [(3, 0), (4, 164.81377845643496)]),
                      (0.78947000000000001, [(4, 195.99771799087463)]),
                      (1.18421, [(4, 130.81278265029931)]),
                      (1.5296000000000001, [(1, 0), (2, 0), (4, 0)])])]
        self.assertListEqual(round_sequence_r(res), round_sequence_r(expected))
        self.assertEqual(errors, [])

if __name__ == "__main__":
    unittest.main()
