# Generated by Django 4.2.2 on 2023-08-09 15:11

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('data', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AnalysisBase',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='name used for multiple fits', max_length=300)),
                ('gpu_requested', models.BooleanField(default=False, help_text='use GPU rather than CPU')),
                ('time_recieved', models.DateTimeField(auto_now_add=True, help_text='analysis requested')),
                ('time_started', models.DateTimeField(blank=True, help_text='analysis initiated', null=True)),
                ('time_complete', models.DateTimeField(blank=True, help_text='analysis stopped', null=True)),
                ('analysis_success', models.BooleanField(default=False, help_text='Successful completion of analysis')),
                ('is_public', models.BooleanField(default=False, help_text='does the user want their data to be public')),
                ('current_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('data_id', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='data.data')),
            ],
        ),
        migrations.CreateModel(
            name='AnalysisParameterBase',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Parameter Name', max_length=100)),
                ('value', models.FloatField(blank=True, default=None, help_text='the value of the parameter', null=True)),
                ('data_type', models.CharField(blank=True, default=None, help_text='parameter type (int/double)', max_length=100, null=True)),
                ('unit', models.CharField(blank=True, help_text='string for what unit the parameter is', max_length=100, null=True)),
                ('lower_limit', models.FloatField(blank=True, default=None, help_text='optional lower limit', null=True)),
                ('upper_limit', models.FloatField(blank=True, default=None, help_text='optional upper limit', null=True)),
                ('analyze', models.BooleanField(default=False, help_text='Should this parameter be analyzed?')),
                ('base_id', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, to='analyze.analysisbase')),
            ],
        ),
    ]
