-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2008  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Ada.Text_IO;
with Externals.Simple;
with Globals;
with Interfaces.C;
with Interfaces.C.Strings;

package body Readline is

   pragma Linker_Options("ada-readline-c.o");
   pragma Linker_Options("-lreadline");

   function C_Get_String (Prompt : in Interfaces.C.Char_Array)
     return Interfaces.C.Strings.Chars_Ptr;
   pragma Import(C, C_Get_String, "rl_gets");

   procedure C_Add_History (History : in Interfaces.C.Char_Array);
   pragma Import(C, C_Add_History, "add_history");

   procedure  C_Disable_Tab_Completion;
   pragma Import(C, C_Disable_Tab_Completion, "rl_disable_tab_completion");

   procedure  C_Enable_Tab_Completion;
   pragma Import(C, C_Enable_Tab_Completion, "rl_enable_tab_completion");

   procedure C_Read_History(F : in Interfaces.C.Char_Array);
   pragma Import(C, C_Read_History, "read_history");

   procedure C_Write_History(F : in Interfaces.C.Char_Array);
   pragma Import(C, C_Write_History, "write_history");

   function Get_String (Prompt                : String  := "";
                        Enable_Tab_Completion : Boolean := False)
     return String is
      use Interfaces.C;
      use Interfaces.C.Strings;

      C_Result : Chars_Ptr;
   begin
      if Enable_Tab_Completion then
         C_Enable_Tab_Completion;
      else
         C_Disable_Tab_Completion;
      end if;
      C_Result := C_Get_String(To_C(Prompt));
      return To_Ada(Value(C_Result));
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Readline.Get_String");
         raise;
   end Get_String;

   procedure Add_History (History      : in String;
                          Remove_Empty : in Boolean := True) is
   begin
      if not (Remove_Empty and History = "") then
         C_Add_History(Interfaces.C.To_C(History));
      end if;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Readline.Add_History");
         raise;
   end Add_History;

   procedure Save_History is
   begin
      C_Write_History(Interfaces.C.To_C(Globals.ToStr(Globals.Topal_Directory) & "/history"));
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Readline.Save_History");
         raise;
   end Save_History;

   procedure Load_History is
      H : constant String := Globals.ToStr(Globals.Topal_Directory) & "/history";
   begin
      if Externals.Simple.Test_R(H) then
         C_Read_History(Interfaces.C.To_C(H));
      end if;
   exception
      when others =>
         Ada.Text_IO.Put_Line(Ada.Text_IO.Standard_Error,
                              "Exception raised in Readline.Load_History");
         raise;
   end Load_History;



end Readline;
