// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UQADD_4H_TRACE_AARCH64_H_
#define VIXL_SIM_UQADD_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uqadd_4H[] = {
  0x00fc, 0x00fe, 0x6666, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x807c, 0xb331, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0xb332, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807e, 0x3333, 0x5556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x007f, 0x3334, 0x5557, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x3335, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0081, 0x3343, 0x55d2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x008f, 0x33b0, 0x55d3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008e, 0x00fc, 0x33b1, 0x55d4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x00fd, 0x33b2, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x00fe, 0x6666, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x807c, 0xb331, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0xb332, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807e, 0xb333, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807f, 0xb334, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x8080, 0xdddd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xab29, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab28, 0xcd4b, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4a, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x5555, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x3333, 0x5556, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3334, 0x5557, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x3335, 0x5565, 0x807a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x3343, 0x55d2, 0x807b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008f, 0x33b0, 0x55d3, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x33b1, 0x55d4, 0xb330, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x6666, 0xaaaa, 0xfffa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0xb331, 0xd554, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0xb332, 0xd555, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0xb333, 0xd556, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xb334, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8080, 0xdddd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab29, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4b, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7ffd, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x5555, 0x7ffe, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5556, 0x7fff, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x5557, 0x800d, 0x807b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3335, 0x5565, 0x807a, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3343, 0x55d2, 0x807b, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b0, 0x55d3, 0x807c, 0xb331, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0xaaaa, 0xfffa, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb331, 0xd554, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0xd555, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xd556, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb334, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xdddd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7ffe, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7ffd, 0x7fff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffe, 0x8000, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x7fff, 0x800e, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5557, 0x800d, 0x807b, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5565, 0x807a, 0x807c, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d2, 0x807b, 0x807d, 0xb332, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x807c, 0xb331, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffb, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xfffc, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xfff0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7fff, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7ffe, 0x8000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7fff, 0x8001, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8000, 0x800f, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x800e, 0x807c, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800d, 0x807b, 0x807d, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807a, 0x807c, 0x807e, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0xb332, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0xb331, 0xd554, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb330, 0xd553, 0xfffc, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffb, 0xfffd, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xfffc, 0xfffe, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xfffd, 0xffff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfffe, 0xffff, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xff83, 0xfff1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff0, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7fff, 0x0001, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8000, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8001, 0x0010, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x800f, 0x007d, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800e, 0x807c, 0x007e, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0x007f, 0x3334, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807e, 0x3333, 0x5556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0xb332, 0x5555, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb331, 0xd554, 0x7ffd, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xfffc, 0x7ffe, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xfffd, 0x7fff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfffe, 0x8000, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0x8001, 0xaaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xaaaa, 0xcccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xcccc, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xff80, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xff81, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xff82, 0xff84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xff82, 0xff84, 0xfff2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xff83, 0xfff1, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff0, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfffe, 0xffff, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x0001, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x0002, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0001, 0x0003, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0002, 0x0011, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x0010, 0x007e, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800f, 0x007d, 0x007f, 0x0081, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x007e, 0x0080, 0x3335, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x007f, 0x3334, 0x5557, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x3333, 0x5556, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0x5555, 0x7ffe, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0x7ffd, 0x7fff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0x7ffe, 0x8000, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x7fff, 0x8001, 0x8003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0x8000, 0x8002, 0xaaac, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x8001, 0xaaab, 0xccce, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xaaaa, 0xcccd, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xcccc, 0xff81, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xff80, 0xff82, 0xff84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xff81, 0xff83, 0xff85, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff83, 0xff85, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff84, 0xfff2, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xfff1, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff0, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0x0002, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0001, 0x0003, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0004, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0003, 0x0012, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0011, 0x007f, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007e, 0x0080, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007f, 0x0081, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x3335, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3334, 0x5557, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5556, 0x7fff, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffe, 0x8000, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7fff, 0x8001, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8000, 0x8002, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8001, 0x8003, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8002, 0xaaac, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaab, 0xccce, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccd, 0xff82, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff82, 0xff84, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff84, 0xff93, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff85, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff84, 0xfff2, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff1, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x0010, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0002, 0x0011, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0003, 0x0012, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0004, 0x0020, 0x00fa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0012, 0x008d, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0011, 0x007f, 0x008e, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x008f, 0x33b0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0081, 0x3343, 0x55d2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x3335, 0x5565, 0x807a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x5557, 0x800d, 0x807b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x7fff, 0x800e, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8000, 0x800f, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8001, 0x8010, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8002, 0x8011, 0xab27, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8003, 0xaaba, 0xcd49, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0xaaac, 0xccdc, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0xff82, 0xff91, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff83, 0xff92, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff83, 0xff92, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff84, 0xff93, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff85, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff2, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x007d, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0010, 0x007e, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0011, 0x007f, 0x008e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x0012, 0x008d, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x0020, 0x00fa, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x008d, 0x00fb, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x008e, 0x00fc, 0x33b1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x008f, 0x33b0, 0x55d3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x3343, 0x55d2, 0x807b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3335, 0x5565, 0x807a, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5557, 0x800d, 0x807b, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x800e, 0x807c, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x800f, 0x807d, 0x807f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8010, 0x807e, 0xab28, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8011, 0xab27, 0xcd4a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xff90, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff91, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff91, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff92, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff93, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x007e, 0x0080, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x007d, 0x007f, 0x0081, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007e, 0x0080, 0x008f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0011, 0x007f, 0x008e, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x008d, 0x00fb, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0020, 0x00fa, 0x00fc, 0x00fe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fb, 0x00fd, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008e, 0x00fc, 0x33b1, 0x55d4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008f, 0x33b0, 0x55d3, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3343, 0x55d2, 0x807b, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5565, 0x807a, 0x807c, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800d, 0x807b, 0x807d, 0x807f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800e, 0x807c, 0x807e, 0x8080, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800f, 0x807d, 0x807f, 0xab29, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8010, 0x807e, 0xab28, 0xcd4b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8011, 0xab27, 0xcd4a, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaba, 0xcd49, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccdc, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff90, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x007f, 0x3334, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x007e, 0x0080, 0x3335, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007f, 0x0081, 0x3343, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x008f, 0x33b0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x008e, 0x00fc, 0x33b1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fb, 0x00fd, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fa, 0x00fc, 0x00fe, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x00fd, 0x33b2, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x33b1, 0x55d4, 0xb330, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b0, 0x55d3, 0x807c, 0xb331, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d2, 0x807b, 0x807d, 0xb332, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807a, 0x807c, 0x807e, 0xb333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0x807f, 0xb334, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807e, 0x8080, 0xdddd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807f, 0xab29, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0xab28, 0xcd4b, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab27, 0xcd4a, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd49, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x3333, 0x5556, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x007f, 0x3334, 0x5557, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x0080, 0x3335, 0x5565, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x0081, 0x3343, 0x55d2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x008f, 0x33b0, 0x55d3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008e, 0x00fc, 0x33b1, 0x55d4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x00fd, 0x33b2, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x00fe, 0x6666, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x807c, 0xb331, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0xb332, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807e, 0xb333, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807f, 0xb334, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x8080, 0xdddd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xab29, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab28, 0xcd4b, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4a, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x5555, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x3333, 0x5556, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3334, 0x5557, 0x800d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0080, 0x3335, 0x5565, 0x807a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0081, 0x3343, 0x55d2, 0x807b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008f, 0x33b0, 0x55d3, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x33b1, 0x55d4, 0xb330, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x33b2, 0x8888, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x6666, 0xaaaa, 0xfffa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0xb331, 0xd554, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0xb332, 0xd555, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0xb333, 0xd556, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xb334, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8080, 0xdddd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab29, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4b, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7ffd, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x5555, 0x7ffe, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5556, 0x7fff, 0x800e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3334, 0x5557, 0x800d, 0x807b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3335, 0x5565, 0x807a, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3343, 0x55d2, 0x807b, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b0, 0x55d3, 0x807c, 0xb331, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b1, 0x55d4, 0xb330, 0xd553, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0x8888, 0xd552, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0xaaaa, 0xfffa, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb331, 0xd554, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0xd555, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xd556, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb334, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xdddd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7ffe, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7ffd, 0x7fff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffe, 0x8000, 0x800f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5556, 0x7fff, 0x800e, 0x807c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5557, 0x800d, 0x807b, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5565, 0x807a, 0x807c, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d2, 0x807b, 0x807d, 0xb332, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d3, 0x807c, 0xb331, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x55d4, 0xb330, 0xd553, 0xfffc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xd552, 0xfffb, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffb, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xfffc, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7fff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7ffe, 0x8000, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7fff, 0x8001, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8000, 0x800f, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x800e, 0x807c, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800d, 0x807b, 0x807d, 0x807f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807a, 0x807c, 0x807e, 0xb333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0xb332, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0xb331, 0xd554, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb330, 0xd553, 0xfffc, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffb, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffa, 0xfffc, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x8000, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7fff, 0x8001, 0x8003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x8000, 0x8002, 0x8011, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8001, 0x8010, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x800f, 0x807d, 0x807f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800e, 0x807c, 0x807e, 0x8080, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807b, 0x807d, 0x807f, 0xb334, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807e, 0xb333, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0xb332, 0xd555, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb331, 0xd554, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd553, 0xfffc, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x8001, 0xaaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x8000, 0x8002, 0xaaac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8001, 0x8003, 0xaaba, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8002, 0x8011, 0xab27, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8010, 0x807e, 0xab28, 0x0000, 0x0000, 0x0000, 0x0000,
  0x800f, 0x807d, 0x807f, 0xab29, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807c, 0x807e, 0x8080, 0xdddd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807f, 0xb334, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0xb333, 0xd556, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb332, 0xd555, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffc, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xaaaa, 0xcccd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x8001, 0xaaab, 0xccce, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8002, 0xaaac, 0xccdc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8003, 0xaaba, 0xcd49, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8011, 0xab27, 0xcd4a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8010, 0x807e, 0xab28, 0xcd4b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807f, 0xab29, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x8080, 0xdddd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xb334, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xd556, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xcccc, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xaaaa, 0xcccd, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaab, 0xccce, 0xff90, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0xaaac, 0xccdc, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8003, 0xaaba, 0xcd49, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8011, 0xab27, 0xcd4a, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0xab28, 0xcd4b, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0xab29, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8080, 0xdddd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb334, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xff80, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xcccc, 0xff81, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccd, 0xff82, 0xff91, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xccce, 0xff90, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0xccdc, 0xfffd, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaba, 0xcd49, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab27, 0xcd4a, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab28, 0xcd4b, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xab29, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xdddd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xff81, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xff80, 0xff82, 0xff84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff81, 0xff83, 0xff92, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccd, 0xff82, 0xff91, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccce, 0xff90, 0xfffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xccdc, 0xfffd, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd49, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4a, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcd4b, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xff82, 0xff84, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xff81, 0xff83, 0xff85, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff82, 0xff84, 0xff93, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff83, 0xff92, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xff91, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff90, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_uqadd_4H = 576;

#endif  // VIXL_SIM_UQADD_4H_TRACE_AARCH64_H_
